/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.vdb.materialization;

import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.vdb.materialization.DatabaseDialect;
import com.metamatrix.vdb.materialization.MaterializedViewScriptGenerator;
import com.metamatrix.vdb.materialization.template.ExpandedTemplate;
import com.metamatrix.vdb.materialization.template.TemplateData;
import com.metamatrix.vdb.materialization.template.TemplateExpander;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;

public class MaterializedViewScriptGeneratorImpl
implements MaterializedViewScriptGenerator {
    private static final String TEMPLATE_PATH = "com/metamatrix/vdb/materialization/template/";
    private static final String PARENT_TEMPLATE = "scriptMaterializedView";
    private static final String PLATFORM_SPECIALIZED_TEMPLATE = "loadMaterializedView_";
    private static final String TEMPLATE_EXT = ".stg";
    private TemplateData templateData;

    public MaterializedViewScriptGeneratorImpl(TemplateData materializedViewTemplateData) {
        this.templateData = materializedViewTemplateData;
    }

    @Override
    public void generateMaterializationTruncateScript(OutputStream stream, DatabaseDialect dialect) throws IOException {
        this.generateTemplate("truncate", this.templateData, dialect, stream);
    }

    @Override
    public void generateMaterializationLoadScript(OutputStream stream) throws IOException {
        this.generateTemplate("load", this.templateData, DatabaseDialect.METAMATRIX, stream);
    }

    @Override
    public void generateMaterializationSwapScript(OutputStream stream, DatabaseDialect dialect) throws IOException {
        this.generateTemplate("swap", this.templateData, dialect, stream);
    }

    @Override
    public void generateMaterializationConnectionPropFile(OutputStream stream) throws IOException {
        this.generateTemplate("connectionProps", this.templateData, DatabaseDialect.CONNECTION_PROPS, stream);
    }

    private void generateTemplate(String command, TemplateData data, DatabaseDialect database, OutputStream stream) throws IOException {
        String name = database.getType() + "_" + command;
        TemplateExpander expander = new TemplateExpander(data, database);
        Reader[] templateReaders = this.getTemplateReaders(command, database);
        ExpandedTemplate template = expander.expand(name, templateReaders, command);
        this.closeReaders(templateReaders);
        this.toStream(template, stream);
    }

    private Reader[] getTemplateReaders(String command, DatabaseDialect database) throws IOException {
        InputStreamReader parent = this.getReader(PARENT_TEMPLATE);
        InputStreamReader child = this.getReader(PLATFORM_SPECIALIZED_TEMPLATE + database);
        return new Reader[]{parent, child};
    }

    private void closeReaders(Reader[] readers) throws IOException {
        for (int i = 0; i < readers.length; ++i) {
            readers[i].close();
        }
    }

    private InputStreamReader getReader(String fileName) throws IOException {
        String templateName = TEMPLATE_PATH + fileName + TEMPLATE_EXT;
        InputStream inputStream = MaterializedViewScriptGeneratorImpl.class.getClassLoader().getResourceAsStream(templateName);
        if (inputStream == null) {
            throw new MetaMatrixRuntimeException("Unable to find resource: " + templateName);
        }
        return new InputStreamReader(inputStream);
    }

    private void toStream(ExpandedTemplate template, OutputStream stream) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(stream);
        writer.write(template.contents, 0, template.contents.length());
        writer.flush();
    }
}

