/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.vdb.materialization;

import com.metamatrix.core.util.StringUtil;
import com.metamatrix.vdb.materialization.DatabaseDialect;

public class ScriptType {
    public static final String MATERIALIZATION_SCRIPT_NAME_SEPARATOR = "_";
    public static final String MATERIALIZATION_MODEL_FILE_PREFIX = "MaterializationModel";
    public static final String MATERIALIZATION_CREATE_SCRIPT_FILE_PREFIX = "Create";
    public static final String MATERIALIZATION_LOAD_SCRIPT_FILE_PREFIX = "Load";
    public static final String MATERIALIZATION_TRUNCATE_SCRIPT_FILE_PREFIX = "Truncate";
    public static final String MATERIALIZATION_SWAP_SCRIPT_FILE_PREFIX = "Swap";
    public static final String MATERIALIZATION_SCRIPT_FILE_SUFFIX = ".ddl";
    public static final String MATERIALIZATION_CONNECTION_PROP_FILE_PREFIX = "Connection";
    public static final String MATERIALIZATION_CONNECTION_PROP_FILE_SUFFIX = ".properties";
    public static final String MATERIALIZATION_SCRIPTS_LOG_FILE_SUFFIX = ".log";

    public static String createScriptFileName(String vdbName, String vdbVersion) {
        return ScriptType.buildRuntimeScriptName(vdbName, vdbVersion, MATERIALIZATION_CREATE_SCRIPT_FILE_PREFIX, MATERIALIZATION_SCRIPT_FILE_SUFFIX);
    }

    public static String createScriptFileName(DatabaseDialect dbDialect, String vdbName) {
        return ScriptType.buildVDBScriptName(dbDialect.getType(), vdbName, MATERIALIZATION_CREATE_SCRIPT_FILE_PREFIX, MATERIALIZATION_SCRIPT_FILE_SUFFIX);
    }

    public static String loadScriptFileName(String vdbName, String vdbVersion) {
        return ScriptType.buildRuntimeScriptName(vdbName, vdbVersion, MATERIALIZATION_LOAD_SCRIPT_FILE_PREFIX, MATERIALIZATION_SCRIPT_FILE_SUFFIX);
    }

    public static String loadScriptFileName(DatabaseDialect dbDialect, String vdbName) {
        return ScriptType.buildVDBScriptName(dbDialect.getType(), vdbName, MATERIALIZATION_LOAD_SCRIPT_FILE_PREFIX, MATERIALIZATION_SCRIPT_FILE_SUFFIX);
    }

    public static String swapScriptFileName(String vdbName, String vdbVersion) {
        return ScriptType.buildRuntimeScriptName(vdbName, vdbVersion, MATERIALIZATION_SWAP_SCRIPT_FILE_PREFIX, MATERIALIZATION_SCRIPT_FILE_SUFFIX);
    }

    public static String swapScriptFileName(DatabaseDialect dbDialect, String vdbName) {
        return ScriptType.buildVDBScriptName(dbDialect.getType(), vdbName, MATERIALIZATION_SWAP_SCRIPT_FILE_PREFIX, MATERIALIZATION_SCRIPT_FILE_SUFFIX);
    }

    public static String truncateScriptFileName(String vdbName, String vdbVersion) {
        return ScriptType.buildRuntimeScriptName(vdbName, vdbVersion, MATERIALIZATION_TRUNCATE_SCRIPT_FILE_PREFIX, MATERIALIZATION_SCRIPT_FILE_SUFFIX);
    }

    public static String truncateScriptFileName(DatabaseDialect dbDialect, String vdbName) {
        return ScriptType.buildVDBScriptName(dbDialect.getType(), vdbName, MATERIALIZATION_TRUNCATE_SCRIPT_FILE_PREFIX, MATERIALIZATION_SCRIPT_FILE_SUFFIX);
    }

    public static String connectionPropertyFileName(String vdbName, String vdbVersion) {
        return ScriptType.buildRuntimeScriptName(vdbName, vdbVersion, MATERIALIZATION_CONNECTION_PROP_FILE_PREFIX, MATERIALIZATION_CONNECTION_PROP_FILE_SUFFIX);
    }

    public static String logFileName(String vdbName, String vdbVersion) {
        StringBuffer sb = new StringBuffer();
        sb.append(vdbName).append(MATERIALIZATION_SCRIPT_NAME_SEPARATOR).append(vdbVersion).append(MATERIALIZATION_SCRIPTS_LOG_FILE_SUFFIX);
        return sb.toString();
    }

    public static boolean isDDLScript(String name) {
        return StringUtil.endsWithIgnoreCase((String)name, (String)MATERIALIZATION_SCRIPT_FILE_SUFFIX);
    }

    public static boolean isMaterializationScript(String name) {
        return StringUtil.indexOfIgnoreCase((String)name, (String)MATERIALIZATION_MODEL_FILE_PREFIX) >= 0;
    }

    public static boolean isCreateScript(String name) {
        return StringUtil.indexOfIgnoreCase((String)name, (String)MATERIALIZATION_CREATE_SCRIPT_FILE_PREFIX) >= 0;
    }

    public static boolean isLoadScript(String name) {
        return StringUtil.indexOfIgnoreCase((String)name, (String)MATERIALIZATION_LOAD_SCRIPT_FILE_PREFIX) >= 0;
    }

    public static boolean isSwapScript(String name) {
        return StringUtil.indexOfIgnoreCase((String)name, (String)MATERIALIZATION_SWAP_SCRIPT_FILE_PREFIX) >= 0;
    }

    public static boolean isTruncateScript(String name) {
        return StringUtil.indexOfIgnoreCase((String)name, (String)MATERIALIZATION_TRUNCATE_SCRIPT_FILE_PREFIX) >= 0;
    }

    private static String buildRuntimeScriptName(String vdbName, String version, String type, String suffix) {
        StringBuffer sb = new StringBuffer();
        sb.append(vdbName).append(MATERIALIZATION_SCRIPT_NAME_SEPARATOR).append(version).append(MATERIALIZATION_SCRIPT_NAME_SEPARATOR).append(type).append(suffix);
        return sb.toString();
    }

    private static String buildVDBScriptName(String dbType, String vdbName, String type, String suffix) {
        StringBuffer sb = new StringBuffer();
        sb.append(dbType).append(MATERIALIZATION_SCRIPT_NAME_SEPARATOR).append(vdbName).append(MATERIALIZATION_SCRIPT_NAME_SEPARATOR).append(type).append(suffix);
        return sb.toString();
    }
}

