/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.vdb.materialization.template;

import com.metamatrix.vdb.materialization.DatabaseDialect;
import com.metamatrix.vdb.materialization.template.ExpandedTemplate;
import com.metamatrix.vdb.materialization.template.Template;
import com.metamatrix.vdb.materialization.template.TemplateData;
import java.io.Reader;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.language.DefaultTemplateLexer;

public class TemplateExpander {
    private TemplateData data;
    private DatabaseDialect database;

    public TemplateExpander(TemplateData data, DatabaseDialect database) {
        this.data = data;
        this.database = database;
    }

    public ExpandedTemplate expand(String nameTemplate, Reader[] templateReaders, String templateName) {
        return new ExpandedTemplate(this.expandText(nameTemplate), this.expandFromReaders(templateReaders, templateName), this.database.getType());
    }

    private String expandFromReaders(Reader[] readers, String templateName) {
        StringTemplateGroup group = new StringTemplateGroup(readers[0], DefaultTemplateLexer.class);
        for (int i = 1; i < readers.length; ++i) {
            StringTemplateGroup tempGroup = group;
            group = new StringTemplateGroup(readers[i], DefaultTemplateLexer.class);
            group.setSuperGroup(tempGroup);
        }
        return this.processTemplate(group.getInstanceOf(templateName));
    }

    public String expandText(String templateText) {
        return this.processTemplate(new StringTemplate(templateText));
    }

    private String processTemplate(final StringTemplate template) {
        this.data.populateTemplate(new Template(){

            @Override
            public void setAttribute(String attributeName, Object value) {
                template.setAttribute(attributeName, value);
            }
        }, this.database);
        return template.toString();
    }
}

