/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.vdb.runtime;

import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.config.util.ConfigUtil;
import com.metamatrix.common.vdb.api.ModelInfo;
import com.metamatrix.common.vdb.api.VDBDefn;
import com.metamatrix.common.vdb.api.VDBStream;
import com.metamatrix.vdb.runtime.BasicModelInfo;
import com.metamatrix.vdb.runtime.BasicVDBInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class BasicVDBDefn
extends BasicVDBInfo
implements VDBDefn {
    private Map connectorTypes = null;
    private Map connectorBindings = null;
    private VDBStream vdbcontent = null;
    private ArrayList validityErrors = null;
    private short status = 1;
    private boolean invalidVDBorModel = false;
    private Map visibilityMap = null;
    private char[] dataroles;
    private Properties headerProperties;

    public BasicVDBDefn(String name) {
        super(name);
    }

    @Override
    public VDBStream getVDBStream() {
        return this.vdbcontent;
    }

    public void setVDBStream(VDBStream stream) {
        this.vdbcontent = stream;
    }

    @Override
    public boolean doesVDBHaveValidityError() {
        return this.invalidVDBorModel;
    }

    public void addConnectorBinding(String modelName, ConnectorBinding binding) {
        this.addConnectorBinding(binding);
        BasicModelInfo model = (BasicModelInfo)this.getModel(modelName);
        if (model != null) {
            model.addConnectorBindingByName(binding.getFullName());
        }
    }

    public void addConnectorBinding(ConnectorBinding binding) {
        if (this.connectorBindings == null) {
            this.connectorBindings = new HashMap();
        }
        this.connectorBindings.put(binding.getName(), binding);
    }

    public void renameConnectorBinding(String existingBindingName, String newBindingName) {
        ConnectorBinding cb = this.removeConnectorBindingFromMap(existingBindingName);
        if (cb != null) {
            Collection ms = this.getModels();
            for (BasicModelInfo model : ms) {
                if (!model.isConnectorBindingUsed(cb.getFullName())) continue;
                model.renameConnectorBinding(existingBindingName, newBindingName);
            }
            ConnectorBinding newcb = ConfigUtil.getEditor().createConnectorComponent(cb.getConfigurationID(), cb, newBindingName, cb.getRoutingUUID());
            this.addConnectorBinding(newcb);
        }
    }

    public void removeConnectorBinding(String bindingName) {
        ConnectorBinding cb;
        if (this.connectorBindings != null && (cb = this.getConnectorBindingByName(bindingName)) != null) {
            Collection ms = this.getModels();
            for (BasicModelInfo model : ms) {
                if (!model.isConnectorBindingUsed(cb.getFullName())) continue;
                model.removeConnectorBindingName(cb.getFullName());
            }
            this.removeFromAvailableConnectorBindings(bindingName);
        }
    }

    public void removeConnectorBindingNameOnly(String bindingName) {
        ConnectorBinding cb;
        if (this.connectorBindings != null && (cb = this.getConnectorBindingByName(bindingName)) != null) {
            Collection ms = this.getModels();
            for (BasicModelInfo model : ms) {
                if (!model.isConnectorBindingUsed(cb.getFullName())) continue;
                model.removeConnectorBindingName(cb.getFullName());
            }
            this.removeConnectorBindingFromMap(bindingName);
        }
    }

    private ConnectorBinding removeConnectorBindingFromMap(String bindingName) {
        ConnectorBinding cb = null;
        if (this.connectorBindings != null) {
            cb = (ConnectorBinding)this.connectorBindings.remove(bindingName);
        }
        return cb;
    }

    private void removeFromAvailableConnectorBindings(String bindingName) {
        ConnectorBinding cb = this.removeConnectorBindingFromMap(bindingName);
        if (cb != null && !this.isConnectorTypeInUse(cb.getComponentTypeID().getFullName())) {
            this.removeConnectorType(cb.getComponentTypeID().getFullName());
        }
    }

    public void removeConnectorBinding(String modelName, String bindingName) {
        ConnectorBinding cb;
        if (this.connectorBindings != null && (cb = this.getConnectorBindingByName(bindingName)) != null) {
            BasicModelInfo model = (BasicModelInfo)this.getModel(modelName);
            if (model != null) {
                model.removeConnectorBindingName(cb.getFullName());
            }
            if (!this.isBindingInUse(cb)) {
                this.removeFromAvailableConnectorBindings(cb.getFullName());
            }
        }
    }

    public boolean isBindingInUse(ConnectorBinding binding) {
        Collection ms = this.getModels();
        for (BasicModelInfo model : ms) {
            if (!model.isConnectorBindingUsed(binding.getFullName())) continue;
            return true;
        }
        return false;
    }

    public boolean isBindingInUse(String bindingName) {
        Collection ms = this.getModels();
        for (BasicModelInfo model : ms) {
            if (!model.isConnectorBindingUsed(bindingName)) continue;
            return true;
        }
        return false;
    }

    private boolean isConnectorTypeInUse(String typeName) {
        if (this.connectorTypes == null) {
            return true;
        }
        for (ConnectorBinding cb : this.connectorBindings.values()) {
            if (!cb.getComponentTypeID().getFullName().equalsIgnoreCase(typeName)) continue;
            return true;
        }
        return false;
    }

    public void setConnectorBinding(String modelName, ConnectorBinding binding) {
        this.addConnectorBinding(binding);
        BasicModelInfo model = (BasicModelInfo)this.getModel(modelName);
        if (model != null) {
            ArrayList<String> names = new ArrayList<String>(1);
            names.add(binding.getFullName());
            model.setConnectorBindingNames(names);
        }
    }

    protected void setConnectorBindings(Map bindings) {
        if (bindings != null) {
            if (this.connectorBindings == null) {
                this.connectorBindings = new HashMap(bindings.size());
            }
            this.connectorBindings.putAll(bindings);
        }
    }

    protected void setConnectorTypes(Map types) {
        if (types != null) {
            if (this.connectorTypes == null) {
                this.connectorTypes = new HashMap(types.size());
            }
            this.connectorTypes.putAll(types);
        }
    }

    public void removeConnectorType(String typeName) {
        if (this.connectorTypes != null) {
            this.connectorTypes.remove(typeName);
        }
    }

    public void addConnectorType(ComponentType type) {
        if (this.connectorTypes == null) {
            this.connectorTypes = new HashMap();
        }
        this.connectorTypes.put(type.getName(), type);
    }

    public Map getConnectorTypes() {
        HashMap m = new HashMap();
        if (this.connectorTypes != null) {
            m.putAll(this.connectorTypes);
        }
        return m;
    }

    @Override
    public ComponentType getConnectorType(String componentTypeName) {
        if (this.connectorTypes == null) {
            return null;
        }
        if (this.connectorTypes.containsKey(componentTypeName)) {
            return (ComponentType)this.connectorTypes.get(componentTypeName);
        }
        return null;
    }

    public Map getConnectorBindings() {
        HashMap m = new HashMap();
        if (this.connectorBindings != null) {
            m.putAll(this.connectorBindings);
        }
        return m;
    }

    @Override
    public ConnectorBinding getConnectorBindingByRouting(String routingUUID) {
        if (this.connectorBindings == null) {
            return null;
        }
        for (ConnectorBinding cb : this.connectorBindings.values()) {
            if (!cb.getRoutingUUID().equals(routingUUID)) continue;
            return cb;
        }
        return null;
    }

    @Override
    public ConnectorBinding getConnectorBindingByName(String bindingName) {
        if (this.connectorBindings == null) {
            return null;
        }
        ConnectorBinding cb = (ConnectorBinding)this.connectorBindings.get(bindingName);
        return cb;
    }

    @Override
    public Map getModelToBindingMappings() {
        HashMap bm = new HashMap();
        Collection mdlsd = this.getModels();
        for (ModelInfo m : mdlsd) {
            ConnectorBinding cb;
            ArrayList<String> uuids;
            if (m.getConnectorBindingNames().size() > 0) {
                uuids = new ArrayList<String>();
                for (String name : m.getConnectorBindingNames()) {
                    cb = (ConnectorBinding)this.connectorBindings.get(name);
                    uuids.add(cb.getRoutingUUID());
                }
                bm.put(m.getName(), uuids);
                continue;
            }
            if (m.getConnectorBindingNames().size() <= 0) continue;
            uuids = new ArrayList();
            for (String name : m.getConnectorBindingNames()) {
                cb = (ConnectorBinding)this.connectorBindings.get(name);
                uuids.add(cb.getRoutingUUID());
            }
            bm.put(m.getName(), uuids);
        }
        return bm;
    }

    public Collection getModelNames() {
        Collection mdlsd = this.getModels();
        ArrayList<String> mdls = new ArrayList<String>(mdlsd.size());
        for (ModelInfo m : mdlsd) {
            mdls.add(m.getName());
        }
        return mdls;
    }

    public ModelInfo removeModelInfo(String modelName, boolean removeBindings) {
        ModelInfo m = super.removeModelInfo(modelName);
        if (m != null && removeBindings) {
            List names = m.getConnectorBindingNames();
            for (String cbName : names) {
                ConnectorBinding cb = this.getConnectorBindingByName(cbName);
                if (cb == null || this.isBindingInUse(cb)) continue;
                this.removeConnectorBinding(cb.getFullName());
            }
        }
        return m;
    }

    @Override
    public ModelInfo removeModelInfo(String modelName) {
        return this.removeModelInfo(modelName, true);
    }

    @Override
    public ModelInfo getMatertializationModel() {
        ModelInfo matModel = null;
        for (ModelInfo aModel : this.getModels()) {
            if (aModel == null || !aModel.isMaterialization()) continue;
            matModel = aModel;
            break;
        }
        return matModel;
    }

    @Override
    public short getStatus() {
        if (this.invalidVDBorModel) {
            return 1;
        }
        return this.status;
    }

    public void setStatus(short status) {
        this.status = status;
    }

    @Override
    public boolean isActiveStatus() {
        if (this.invalidVDBorModel) {
            return false;
        }
        return this.status == 3 || this.status == 3;
    }

    public void setVDBValidityError(boolean hasError) {
        this.invalidVDBorModel = hasError;
    }

    public void setVDBValidityError(boolean hasError, String msg) {
        this.invalidVDBorModel = hasError;
        if (this.validityErrors == null) {
            this.validityErrors = new ArrayList();
        }
        if (msg != null) {
            this.validityErrors.add(msg);
        }
    }

    @Override
    public String[] getVDBValidityErrors() {
        if (this.validityErrors != null) {
            return this.validityErrors.toArray(new String[this.validityErrors.size()]);
        }
        return new String[0];
    }

    public void determineVdbsStatus() {
        if (this.invalidVDBorModel) {
            this.setStatus((short)1);
            return;
        }
        Map mapConnBind = this.getModelToBindingMappings();
        boolean bHasMissingValues = false;
        boolean bHasNoBindings = false;
        boolean requiresBindings = false;
        for (ModelInfo mi : this.getModels()) {
            if (!mi.requiresConnectorBinding()) continue;
            requiresBindings = true;
            break;
        }
        if (!requiresBindings) {
            this.setStatus((short)2);
            return;
        }
        int connBind = 0;
        for (List list : mapConnBind.values()) {
            if (list == null || list.size() == 0) {
                bHasMissingValues = true;
                continue;
            }
            connBind += list.size();
        }
        if (connBind == 0) {
            bHasNoBindings = true;
        }
        short siStatus = bHasNoBindings || bHasMissingValues ? (short)1 : 3;
        this.setStatus(siStatus);
    }

    public synchronized void removeUnmappedBindings() {
        HashSet allBindingNames = new HashSet();
        for (ModelInfo model : this.getModels()) {
            allBindingNames.addAll(model.getConnectorBindingNames());
        }
        for (ConnectorBinding binding : this.getConnectorBindings().values()) {
            String bindingName = binding.getFullName();
            if (allBindingNames.contains(bindingName)) continue;
            this.connectorBindings.remove(bindingName);
        }
    }

    @Override
    public boolean isVisible(String resourcePath) {
        if (this.visibilityMap == null) {
            return false;
        }
        Boolean visibility = (Boolean)this.visibilityMap.get(resourcePath);
        if (visibility == null && resourcePath.startsWith("/")) {
            visibility = (Boolean)this.visibilityMap.get(resourcePath.substring(1));
        }
        return visibility != null && !visibility.equals(Boolean.FALSE);
    }

    public void setVisibility(String resoucePath, boolean visible) {
        if (this.visibilityMap == null) {
            this.visibilityMap = new HashMap();
        }
        this.visibilityMap.put(resoucePath, visible ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public char[] getDataRoles() {
        return this.dataroles;
    }

    public void setDataRoles(char[] roles) {
        this.dataroles = roles;
    }

    public void renameModelInfo(String modelName, String newModelName) {
        BasicModelInfo bmi;
        if (modelName == null || modelName.length() == 0) {
            return;
        }
        if (this.modelInfos != null && (bmi = (BasicModelInfo)this.modelInfos.remove(modelName)) != null) {
            bmi.setName(newModelName);
            this.addModelInfo(bmi);
        }
    }

    @Override
    public Properties getHeaderProperties() {
        return this.headerProperties;
    }

    public void setHeaderProperties(Properties props) {
        this.headerProperties = props;
    }
}

