/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.vdb.runtime;

import com.metamatrix.common.vdb.api.ModelInfo;
import com.metamatrix.common.vdb.api.VDBInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class BasicVDBInfo
implements VDBInfo,
Serializable {
    private String fileName;
    private String name;
    private String uuid;
    private String desc;
    private Date created;
    private String createdBy;
    protected Map modelInfos = Collections.synchronizedMap(new HashMap());
    private boolean WSDLDefined = false;
    private String version;

    public BasicVDBInfo(String vdbName) {
        this.name = vdbName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getUUID() {
        return this.uuid;
    }

    public String getVersion() {
        return this.version;
    }

    @Override
    public String getDescription() {
        return this.desc;
    }

    @Override
    public Date getDateCreated() {
        return this.created;
    }

    @Override
    public String getCreatedBy() {
        return this.createdBy;
    }

    @Override
    public Collection getModels() {
        if (this.modelInfos == null || this.modelInfos.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList models = new ArrayList(this.modelInfos.size());
        models.addAll(this.modelInfos.values());
        return models;
    }

    @Override
    public ModelInfo getModel(String name) {
        return (ModelInfo)this.modelInfos.get(name);
    }

    @Override
    public boolean hasWSDLDefined() {
        return this.WSDLDefined;
    }

    public void setDateCreated(Date date) {
        this.created = date;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public void setDescription(String description) {
        this.desc = description;
    }

    public void setModelInfos(Collection models) {
        this.modelInfos.clear();
        for (ModelInfo mi : models) {
            this.modelInfos.put(mi.getName(), mi);
        }
    }

    public void addModelInfo(ModelInfo model) {
        if (model == null) {
            return;
        }
        this.removeModelInfo(model.getName());
        this.modelInfos.put(model.getName(), model);
    }

    public ModelInfo removeModelInfo(String modelName) {
        if (modelName == null || modelName.length() == 0) {
            return null;
        }
        if (this.modelInfos != null) {
            return (ModelInfo)this.modelInfos.remove(modelName);
        }
        return null;
    }

    public void setUUID(String objectID) {
        this.uuid = objectID;
    }

    public void setHasWSDLDefined(boolean defined) {
        this.WSDLDefined = defined;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("\nDefn for VDB " + this.getName() + " and # models " + (this.modelInfos == null ? 0 : this.modelInfos.size()));
        return sb.toString();
    }
}

