/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.vdb.runtime;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.vdb.runtime.URIModelResource;
import com.metamatrix.vdb.runtime.URIResourceReader;
import java.util.Map;

public final class URIResource {
    private static Map resources = null;

    public boolean isXMLDocument(String uri) {
        URIModelResource r = this.getURIModelResource(uri);
        if (r != null) {
            return r.isXMLDocType();
        }
        return false;
    }

    public String getAuthorizationLevel(String uri) {
        URIModelResource r = this.getURIModelResource(uri);
        if (r != null) {
            return r.getAuthLevel();
        }
        return "all";
    }

    public boolean isPhysicalBindingAllowed(String uri) {
        URIModelResource r = this.getURIModelResource(uri);
        if (r != null) {
            return r.isPhysicalBindingAllowed();
        }
        return false;
    }

    private URIModelResource getURIModelResource(String uri) {
        if (resources.containsKey(uri)) {
            return (URIModelResource)resources.get(uri);
        }
        return null;
    }

    static {
        try {
            URIResourceReader reader = new URIResourceReader();
            resources = reader.getURIResources();
        }
        catch (Exception e) {
            String msg = CommonPlugin.Util.getString("URIResource.Resource_not_found", new Object[]{"uriprimarymodeltypes.xml"});
            throw new MetaMatrixRuntimeException((Throwable)e, msg);
        }
    }
}

