/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.vdb.runtime;

import com.metamatrix.common.xml.XMLReaderWriter;
import com.metamatrix.common.xml.XMLReaderWriterImpl;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.vdb.runtime.BasicURIModelResource;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;

public class URIResourceReader {
    private Map resources = new HashMap();
    private static final String FALSE = Boolean.FALSE.toString();
    public static final String RESOURCE_NAME = "uriprimarymodeltypes.xml";

    public Map getURIResources() throws Exception {
        InputStream in = this.loadAsResource(RESOURCE_NAME);
        ArgCheck.isNotNull((Object)in);
        Document doc = null;
        try {
            doc = this.getXMLReaderWriter().readDocument(in);
        }
        catch (JDOMException e) {
            try {
                in.close();
            }
            catch (Exception ce) {
                // empty catch block
            }
            throw new Exception(e.getMessage());
        }
        Element root = doc.getRootElement();
        List uriElements = root.getChildren("uri");
        for (Element uriElement : uriElements) {
            String name = null;
            String authlevel = "all";
            String isxmldoctype = FALSE;
            String isphysicalbinding = FALSE;
            List attrs = uriElement.getAttributes();
            for (Attribute a : attrs) {
                String n = a.getName();
                if (n.equalsIgnoreCase("name")) {
                    name = a.getValue();
                    continue;
                }
                if (n.equalsIgnoreCase("authlevel")) {
                    authlevel = a.getValue();
                    continue;
                }
                if (n.equalsIgnoreCase("xmldoctype")) {
                    isxmldoctype = a.getValue();
                    continue;
                }
                if (!n.equalsIgnoreCase("physicalbindingallowed")) continue;
                isphysicalbinding = a.getValue();
            }
            ArgCheck.isNotNull(name, (String)"The attribute name was not defined");
            BasicURIModelResource resource = new BasicURIModelResource(name);
            resource.setAuthLevel(authlevel);
            resource.setIsXMLDocType(new Boolean(isxmldoctype));
            resource.setIsPhysicalBindingAllowed(new Boolean(isphysicalbinding));
            this.resources.put(name, resource);
        }
        if (in != null) {
            try {
                in.close();
            }
            catch (Exception ce) {
                // empty catch block
            }
        }
        return this.resources;
    }

    private InputStream loadAsResource(String resourceName) throws Exception {
        InputStream is = null;
        is = URIResourceReader.class.getResourceAsStream(resourceName);
        ArgCheck.isNotNull((Object)is);
        return is;
    }

    private XMLReaderWriter getXMLReaderWriter() {
        return new XMLReaderWriterImpl();
    }

    public static class Constants {
        public static final String URI_RESOURCES = "urimodeltypes";

        public static class URI {
            public static final String ELEMENT = "uri";

            public static class Attribute {
                public static final String NAME = "name";
                public static final String AUTHLEVEL = "authlevel";
                public static final String ISXMLDOCTYPE = "xmldoctype";
                public static final String PHYSICAL_BINDING = "physicalbindingallowed";
            }
        }
    }
}

