/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.connector.basic;

import com.metamatrix.common.util.PropertiesUtils;
import java.io.Serializable;
import java.util.Properties;
import org.teiid.connector.DataPlugin;
import org.teiid.connector.api.Connector;
import org.teiid.connector.api.ConnectorEnvironment;
import org.teiid.connector.api.ConnectorException;
import org.teiid.connector.api.ConnectorIdentity;
import org.teiid.connector.api.CredentialMap;
import org.teiid.connector.api.ExecutionContext;
import org.teiid.connector.api.MappedUserIdentity;
import org.teiid.connector.api.SingleIdentity;

public abstract class BasicConnector
implements Connector {
    private boolean useCredentialMap;
    private boolean adminConnectionsAllowed = true;
    private String connectorName;

    @Override
    public void start(ConnectorEnvironment environment) throws ConnectorException {
        this.connectorName = environment.getConnectorName();
        this.adminConnectionsAllowed = PropertiesUtils.getBooleanProperty((Properties)environment.getProperties(), (String)"AdminConnectionsAllowed", (boolean)true);
        this.useCredentialMap = PropertiesUtils.getBooleanProperty((Properties)environment.getProperties(), (String)"UseCredentialMap", (boolean)false);
    }

    @Override
    public ConnectorIdentity createIdentity(ExecutionContext context) throws ConnectorException {
        if (context == null) {
            if (this.adminConnectionsAllowed) {
                return new SingleIdentity();
            }
            throw new ConnectorException(DataPlugin.Util.getString("UserIdentityFactory.single_identity_not_supported"));
        }
        Serializable payload = context.getTrustedPayload();
        if (!(payload instanceof CredentialMap)) {
            if (this.useCredentialMap) {
                throw new ConnectorException(DataPlugin.Util.getString("UserIdentityFactory.extraction_error"));
            }
            return new SingleIdentity();
        }
        CredentialMap credMap = (CredentialMap)payload;
        String user = credMap.getUser(this.connectorName);
        String password = credMap.getPassword(this.connectorName);
        if (user == null || password == null) {
            throw new ConnectorException(DataPlugin.Util.getString("UserIdentityFactory.missing_credentials", new Object[]{this.connectorName}));
        }
        return new MappedUserIdentity(context.getUser(), user, password);
    }

    public String getConnectorName() {
        return this.connectorName;
    }

    public void setConnectorName(String connectorName) {
        this.connectorName = connectorName;
    }

    public boolean useCredentialMap() {
        return this.useCredentialMap;
    }

    public void setUseCredentialMap(boolean useCredentialMap) {
        this.useCredentialMap = useCredentialMap;
    }

    public boolean areAdminConnectionsAllowed() {
        return this.adminConnectionsAllowed;
    }

    public void setAdminConnectionsAllowed(boolean adminConnectionsAllowed) {
        this.adminConnectionsAllowed = adminConnectionsAllowed;
    }
}

