/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.connector.language;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.teiid.connector.language.ICompoundCriteria;
import org.teiid.connector.language.ICriteria;
import org.teiid.connector.language.ILanguageFactory;

public final class LanguageUtil {
    private LanguageUtil() {
    }

    public static final List separateCriteriaByAnd(ICriteria criteria) {
        if (criteria == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList parts = new ArrayList();
        LanguageUtil.separateCriteria(criteria, parts);
        return parts;
    }

    private static void separateCriteria(ICriteria crit, List parts) {
        if (crit instanceof ICompoundCriteria) {
            ICompoundCriteria compCrit = (ICompoundCriteria)crit;
            if (compCrit.getOperator() == ICompoundCriteria.Operator.AND) {
                List<ICriteria> subCrits = compCrit.getCriteria();
                Iterator<ICriteria> iter = subCrits.iterator();
                while (iter.hasNext()) {
                    LanguageUtil.separateCriteria(iter.next(), parts);
                }
            } else {
                parts.add(crit);
            }
        } else {
            parts.add(crit);
        }
    }

    public static ICriteria combineCriteria(ICriteria primaryCrit, ICriteria additionalCrit, ILanguageFactory languageFactory) {
        if (primaryCrit == null) {
            return additionalCrit;
        }
        if (additionalCrit == null) {
            return primaryCrit;
        }
        if (primaryCrit instanceof ICompoundCriteria && ((ICompoundCriteria)primaryCrit).getOperator() == ICompoundCriteria.Operator.AND) {
            ICompoundCriteria primaryCompound = (ICompoundCriteria)primaryCrit;
            primaryCompound.getCriteria().add(additionalCrit);
            return primaryCrit;
        }
        ArrayList<ICriteria> crits = new ArrayList<ICriteria>(2);
        crits.add(primaryCrit);
        crits.add(additionalCrit);
        ICompoundCriteria compCrit = languageFactory.createCompoundCriteria(ICompoundCriteria.Operator.AND, crits);
        return compCrit;
    }
}

