/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.connector.visitor.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.teiid.connector.language.IAggregate;
import org.teiid.connector.language.IBatchedUpdates;
import org.teiid.connector.language.IBulkInsert;
import org.teiid.connector.language.ICompareCriteria;
import org.teiid.connector.language.ICompoundCriteria;
import org.teiid.connector.language.IDelete;
import org.teiid.connector.language.IElement;
import org.teiid.connector.language.IExistsCriteria;
import org.teiid.connector.language.IFrom;
import org.teiid.connector.language.IFunction;
import org.teiid.connector.language.IGroup;
import org.teiid.connector.language.IGroupBy;
import org.teiid.connector.language.IInCriteria;
import org.teiid.connector.language.IInlineView;
import org.teiid.connector.language.IInsert;
import org.teiid.connector.language.IIsNullCriteria;
import org.teiid.connector.language.IJoin;
import org.teiid.connector.language.ILanguageObject;
import org.teiid.connector.language.ILikeCriteria;
import org.teiid.connector.language.ILimit;
import org.teiid.connector.language.ILiteral;
import org.teiid.connector.language.INotCriteria;
import org.teiid.connector.language.IOrderBy;
import org.teiid.connector.language.IOrderByItem;
import org.teiid.connector.language.IParameter;
import org.teiid.connector.language.IProcedure;
import org.teiid.connector.language.IQuery;
import org.teiid.connector.language.IScalarSubquery;
import org.teiid.connector.language.ISearchedCaseExpression;
import org.teiid.connector.language.ISelect;
import org.teiid.connector.language.ISelectSymbol;
import org.teiid.connector.language.ISetClause;
import org.teiid.connector.language.ISetClauseList;
import org.teiid.connector.language.ISetQuery;
import org.teiid.connector.language.ISubqueryCompareCriteria;
import org.teiid.connector.language.ISubqueryInCriteria;
import org.teiid.connector.language.IUpdate;
import org.teiid.connector.visitor.framework.DelegatingHierarchyVisitor;
import org.teiid.connector.visitor.framework.LanguageObjectVisitor;

public class CollectorVisitor<T>
implements LanguageObjectVisitor {
    private Class<T> type;
    private Collection<T> objects = new ArrayList<T>();

    public CollectorVisitor(Class<T> type) {
        this.type = type;
    }

    private void checkInstance(ILanguageObject obj) {
        if (this.type.isInstance(obj)) {
            this.objects.add(obj);
        }
    }

    public Collection<T> getCollectedObjects() {
        return this.objects;
    }

    @Override
    public void visit(IAggregate obj) {
        this.checkInstance(obj);
    }

    @Override
    public void visit(IBatchedUpdates obj) {
        this.checkInstance(obj);
    }

    @Override
    public void visit(ICompareCriteria obj) {
        this.checkInstance(obj);
    }

    @Override
    public void visit(ICompoundCriteria obj) {
        this.checkInstance(obj);
    }

    @Override
    public void visit(IDelete obj) {
        this.checkInstance(obj);
    }

    @Override
    public void visit(IElement obj) {
        this.checkInstance(obj);
    }

    @Override
    public void visit(IExistsCriteria obj) {
        this.checkInstance(obj);
    }

    @Override
    public void visit(IFrom obj) {
        this.checkInstance(obj);
    }

    @Override
    public void visit(IFunction obj) {
        this.checkInstance(obj);
    }

    @Override
    public void visit(IGroup obj) {
        this.checkInstance(obj);
    }

    @Override
    public void visit(IGroupBy obj) {
        this.checkInstance(obj);
    }

    @Override
    public void visit(IInCriteria obj) {
        this.checkInstance(obj);
    }

    @Override
    public void visit(IInlineView obj) {
        this.checkInstance(obj);
    }

    @Override
    public void visit(IInsert obj) {
        this.checkInstance(obj);
    }

    @Override
    public void visit(IBulkInsert obj) {
        this.checkInstance(obj);
    }

    @Override
    public void visit(IIsNullCriteria obj) {
        this.checkInstance(obj);
    }

    @Override
    public void visit(IJoin obj) {
        this.checkInstance(obj);
    }

    @Override
    public void visit(ILikeCriteria obj) {
        this.checkInstance(obj);
    }

    @Override
    public void visit(ILimit obj) {
        this.checkInstance(obj);
    }

    @Override
    public void visit(ILiteral obj) {
        this.checkInstance(obj);
    }

    @Override
    public void visit(INotCriteria obj) {
        this.checkInstance(obj);
    }

    @Override
    public void visit(IOrderBy obj) {
        this.checkInstance(obj);
    }

    @Override
    public void visit(IOrderByItem obj) {
        this.checkInstance(obj);
    }

    @Override
    public void visit(IParameter obj) {
        this.checkInstance(obj);
    }

    @Override
    public void visit(IProcedure obj) {
        this.checkInstance(obj);
    }

    @Override
    public void visit(IQuery obj) {
        this.checkInstance(obj);
    }

    @Override
    public void visit(IScalarSubquery obj) {
        this.checkInstance(obj);
    }

    @Override
    public void visit(ISearchedCaseExpression obj) {
        this.checkInstance(obj);
    }

    @Override
    public void visit(ISelect obj) {
        this.checkInstance(obj);
    }

    @Override
    public void visit(ISelectSymbol obj) {
        this.checkInstance(obj);
    }

    @Override
    public void visit(ISubqueryCompareCriteria obj) {
        this.checkInstance(obj);
    }

    @Override
    public void visit(ISubqueryInCriteria obj) {
        this.checkInstance(obj);
    }

    @Override
    public void visit(IUpdate obj) {
        this.checkInstance(obj);
    }

    @Override
    public void visit(ISetQuery obj) {
        this.checkInstance(obj);
    }

    @Override
    public void visit(ISetClauseList obj) {
        this.checkInstance(obj);
    }

    @Override
    public void visit(ISetClause obj) {
        this.checkInstance(obj);
    }

    public static <T> Collection<T> collectObjects(Class<T> type, ILanguageObject object) {
        CollectorVisitor<T> visitor = new CollectorVisitor<T>(type);
        DelegatingHierarchyVisitor hierarchyVisitor = new DelegatingHierarchyVisitor(visitor, null);
        object.acceptVisitor(hierarchyVisitor);
        return visitor.getCollectedObjects();
    }

    public static Collection<IElement> collectElements(ILanguageObject object) {
        return CollectorVisitor.collectObjects(IElement.class, object);
    }

    public static Collection<IGroup> collectGroups(ILanguageObject object) {
        return CollectorVisitor.collectObjects(IGroup.class, object);
    }

    public static Set<IGroup> collectGroupsUsedByElements(ILanguageObject object) {
        HashSet<IGroup> groups = new HashSet<IGroup>();
        for (IElement element : CollectorVisitor.collectElements(object)) {
            if (element.getGroup() == null) continue;
            groups.add(element.getGroup());
        }
        return groups;
    }
}

