/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.connector.visitor.util;

import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.core.util.StringUtil;
import java.util.Iterator;
import java.util.List;
import org.teiid.connector.api.ConnectorException;
import org.teiid.connector.language.IAggregate;
import org.teiid.connector.language.IBulkInsert;
import org.teiid.connector.language.ICommand;
import org.teiid.connector.language.ICompareCriteria;
import org.teiid.connector.language.ICompoundCriteria;
import org.teiid.connector.language.ICriteria;
import org.teiid.connector.language.IDelete;
import org.teiid.connector.language.IElement;
import org.teiid.connector.language.IExistsCriteria;
import org.teiid.connector.language.IExpression;
import org.teiid.connector.language.IFrom;
import org.teiid.connector.language.IFromItem;
import org.teiid.connector.language.IFunction;
import org.teiid.connector.language.IGroup;
import org.teiid.connector.language.IGroupBy;
import org.teiid.connector.language.IInCriteria;
import org.teiid.connector.language.IInlineView;
import org.teiid.connector.language.IInsert;
import org.teiid.connector.language.IIsNullCriteria;
import org.teiid.connector.language.IJoin;
import org.teiid.connector.language.ILanguageObject;
import org.teiid.connector.language.ILikeCriteria;
import org.teiid.connector.language.ILimit;
import org.teiid.connector.language.ILiteral;
import org.teiid.connector.language.INotCriteria;
import org.teiid.connector.language.IOrderBy;
import org.teiid.connector.language.IOrderByItem;
import org.teiid.connector.language.IParameter;
import org.teiid.connector.language.IPredicateCriteria;
import org.teiid.connector.language.IProcedure;
import org.teiid.connector.language.IQuery;
import org.teiid.connector.language.IQueryCommand;
import org.teiid.connector.language.IScalarSubquery;
import org.teiid.connector.language.ISearchedCaseExpression;
import org.teiid.connector.language.ISelect;
import org.teiid.connector.language.ISelectSymbol;
import org.teiid.connector.language.ISetClause;
import org.teiid.connector.language.ISetClauseList;
import org.teiid.connector.language.ISetQuery;
import org.teiid.connector.language.ISubqueryCompareCriteria;
import org.teiid.connector.language.ISubqueryInCriteria;
import org.teiid.connector.language.IUpdate;
import org.teiid.connector.metadata.runtime.MetadataObject;
import org.teiid.connector.visitor.framework.AbstractLanguageVisitor;
import org.teiid.connector.visitor.util.SQLReservedWords;

public class SQLStringVisitor
extends AbstractLanguageVisitor
implements SQLReservedWords {
    private static final String ESCAPED_QUOTE = "''";
    protected static final String UNDEFINED = "<undefined>";
    protected static final String UNDEFINED_PARAM = "?";
    protected StringBuffer buffer = new StringBuffer();

    protected String getName(MetadataObject object) {
        try {
            String nameInSource = object.getNameInSource();
            if (nameInSource != null && nameInSource.length() > 0) {
                return nameInSource;
            }
            return object.getName();
        }
        catch (ConnectorException e) {
            return object.getName();
        }
    }

    public void append(ILanguageObject obj) {
        if (obj == null) {
            this.buffer.append(UNDEFINED);
        } else {
            this.visitNode(obj);
        }
    }

    protected void append(List<? extends ILanguageObject> items) {
        if (items != null && items.size() != 0) {
            this.append(items.get(0));
            for (int i = 1; i < items.size(); ++i) {
                this.buffer.append(",").append(" ");
                this.append(items.get(i));
            }
        }
    }

    protected void append(ILanguageObject[] items) {
        if (items != null && items.length != 0) {
            this.append(items[0]);
            for (int i = 1; i < items.length; ++i) {
                this.buffer.append(",").append(" ");
                this.append(items[i]);
            }
        }
    }

    protected String escapeString(String str) {
        return StringUtil.replaceAll((String)str, (String)"'", (String)ESCAPED_QUOTE);
    }

    public String toString() {
        return this.buffer.toString();
    }

    @Override
    public void visit(IAggregate obj) {
        this.buffer.append(obj.getName()).append("(");
        if (obj.isDistinct()) {
            this.buffer.append("DISTINCT").append(" ");
        }
        if (obj.getExpression() == null) {
            this.buffer.append("*");
        } else {
            this.append(obj.getExpression());
        }
        this.buffer.append(")");
    }

    @Override
    public void visit(ICompareCriteria obj) {
        this.append(obj.getLeftExpression());
        this.buffer.append(" ");
        switch (obj.getOperator()) {
            case EQ: {
                this.buffer.append("=");
                break;
            }
            case GE: {
                this.buffer.append(">=");
                break;
            }
            case GT: {
                this.buffer.append(">");
                break;
            }
            case LE: {
                this.buffer.append("<=");
                break;
            }
            case LT: {
                this.buffer.append("<");
                break;
            }
            case NE: {
                this.buffer.append("<>");
                break;
            }
            default: {
                this.buffer.append(UNDEFINED);
            }
        }
        this.buffer.append(" ");
        this.append(obj.getRightExpression());
    }

    @Override
    public void visit(ICompoundCriteria obj) {
        String opString = null;
        switch (obj.getOperator()) {
            case AND: {
                opString = "AND";
                break;
            }
            case OR: {
                opString = "OR";
                break;
            }
            default: {
                opString = UNDEFINED;
            }
        }
        List<ICriteria> criteria = obj.getCriteria();
        if (criteria == null || criteria.size() == 0) {
            this.buffer.append(UNDEFINED);
        } else if (criteria.size() == 1) {
            this.append(criteria.get(0));
        } else {
            this.buffer.append("(");
            this.append(criteria.get(0));
            this.buffer.append(")");
            for (int i = 1; i < criteria.size(); ++i) {
                this.buffer.append(" ").append(opString).append(" ").append("(");
                this.append(criteria.get(i));
                this.buffer.append(")");
            }
        }
    }

    @Override
    public void visit(IDelete obj) {
        this.buffer.append("DELETE").append(" ");
        this.buffer.append(this.getSourceComment(obj));
        this.buffer.append("FROM").append(" ");
        this.append(obj.getGroup());
        if (obj.getCriteria() != null) {
            this.buffer.append(" ").append("WHERE").append(" ");
            this.append(obj.getCriteria());
        }
    }

    protected String replaceElementName(String group, String element) {
        return null;
    }

    @Override
    public void visit(IElement obj) {
        this.buffer.append(this.getElementName(obj, true));
    }

    private String getElementName(IElement obj, boolean qualify) {
        String groupName = null;
        IGroup group = obj.getGroup();
        if (group != null && qualify) {
            Object groupID;
            groupName = group.getDefinition() != null ? group.getContext() : ((groupID = group.getMetadataObject()) != null ? this.getName((MetadataObject)groupID) : group.getContext());
        }
        String elemShortName = null;
        Object elementID = obj.getMetadataObject();
        if (elementID != null) {
            elemShortName = this.getName((MetadataObject)elementID);
        } else {
            String elementName = obj.getName();
            elemShortName = SQLStringVisitor.getShortName(elementName);
        }
        String replacementElement = this.replaceElementName(groupName, elemShortName);
        if (replacementElement != null) {
            return replacementElement;
        }
        StringBuffer elementName = new StringBuffer(elemShortName.length());
        if (groupName != null) {
            elementName.append(groupName);
            elementName.append(".");
        }
        elementName.append(elemShortName);
        return elementName.toString();
    }

    public static String getShortName(String elementName) {
        int lastDot = elementName.lastIndexOf(".");
        if (lastDot >= 0) {
            elementName = elementName.substring(lastDot + 1);
        }
        return elementName;
    }

    @Override
    public void visit(IProcedure obj) {
        this.buffer.append("EXEC").append(" ");
        if (obj.getMetadataObject() != null) {
            this.buffer.append(this.getName((MetadataObject)obj.getMetadataObject()));
        } else {
            this.buffer.append(obj.getProcedureName());
        }
        this.buffer.append("(");
        List<IParameter> params = obj.getParameters();
        if (params != null && params.size() != 0) {
            IParameter param = null;
            for (int i = 0; i < params.size(); ++i) {
                param = params.get(i);
                if (param.getDirection() != IParameter.Direction.IN && param.getDirection() != IParameter.Direction.INOUT) continue;
                if (i != 0) {
                    this.buffer.append(",").append(" ");
                }
                if (param.getValue() != null) {
                    this.buffer.append(param.getValue().toString());
                    continue;
                }
                this.buffer.append(UNDEFINED_PARAM);
            }
        }
        this.buffer.append(")");
    }

    @Override
    public void visit(IExistsCriteria obj) {
        this.buffer.append("EXISTS").append(" ").append("(");
        this.append(obj.getQuery());
        this.buffer.append(")");
    }

    @Override
    public void visit(IFrom obj) {
        this.buffer.append("FROM").append(" ");
        this.append(obj.getItems());
    }

    @Override
    public void visit(IFunction obj) {
        String name = obj.getName();
        List<IExpression> args = obj.getParameters();
        if (name.equalsIgnoreCase("CONVERT") || name.equalsIgnoreCase("CAST")) {
            Object typeValue = ((ILiteral)args.get(1)).getValue();
            this.buffer.append(name);
            this.buffer.append("(");
            this.append(args.get(0));
            if (name.equalsIgnoreCase("CONVERT")) {
                this.buffer.append(",");
                this.buffer.append(" ");
            } else {
                this.buffer.append(" ");
                this.buffer.append("AS");
                this.buffer.append(" ");
            }
            this.buffer.append(typeValue);
            this.buffer.append(")");
        } else if (name.equals("%") || name.equals("+") || name.equals("-") || name.equals("*") || name.equals("/") || name.equals("||")) {
            this.buffer.append("(");
            if (args != null) {
                for (int i = 0; i < args.size(); ++i) {
                    this.append(args.get(i));
                    if (i >= args.size() - 1) continue;
                    this.buffer.append(" ");
                    this.buffer.append(name);
                    this.buffer.append(" ");
                }
            }
            this.buffer.append(")");
        } else if (name.equalsIgnoreCase("TIMESTAMPADD") || name.equalsIgnoreCase("TIMESTAMPDIFF")) {
            this.buffer.append(name);
            this.buffer.append("(");
            if (args != null && args.size() > 0) {
                this.buffer.append(((ILiteral)args.get(0)).getValue());
                for (int i = 1; i < args.size(); ++i) {
                    this.buffer.append(",");
                    this.buffer.append(" ");
                    this.append(args.get(i));
                }
            }
            this.buffer.append(")");
        } else {
            this.buffer.append(obj.getName()).append("(");
            this.append(obj.getParameters());
            this.buffer.append(")");
        }
    }

    @Override
    public void visit(IGroup obj) {
        Object groupID = obj.getMetadataObject();
        if (groupID != null) {
            this.buffer.append(this.getName((MetadataObject)groupID));
        } else if (obj.getDefinition() == null) {
            this.buffer.append(obj.getContext());
        } else {
            this.buffer.append(obj.getDefinition());
        }
        if (obj.getDefinition() != null) {
            this.buffer.append(" ");
            if (this.useAsInGroupAlias()) {
                this.buffer.append("AS").append(" ");
            }
            this.buffer.append(obj.getContext());
        }
    }

    protected boolean useAsInGroupAlias() {
        return true;
    }

    @Override
    public void visit(IGroupBy obj) {
        this.buffer.append("GROUP").append(" ").append("BY").append(" ");
        this.append(obj.getElements());
    }

    @Override
    public void visit(IInCriteria obj) {
        this.append(obj.getLeftExpression());
        if (obj.isNegated()) {
            this.buffer.append(" ").append("NOT");
        }
        this.buffer.append(" ").append("IN").append(" ").append("(");
        this.append(obj.getRightExpressions());
        this.buffer.append(")");
    }

    @Override
    public void visit(IInlineView obj) {
        this.buffer.append("(");
        if (obj.getOutput() != null) {
            this.buffer.append(obj.getOutput());
        } else {
            this.append(obj.getQuery());
        }
        this.buffer.append(")");
        this.buffer.append(" ");
        if (this.useAsInGroupAlias()) {
            this.buffer.append("AS");
            this.buffer.append(" ");
        }
        this.buffer.append(obj.getContext());
    }

    @Override
    public void visit(IInsert obj) {
        this.formatBasicInsert(obj);
        this.buffer.append(" ").append("VALUES").append(" ").append("(");
        this.append(obj.getValues());
        this.buffer.append(")");
    }

    private void formatBasicInsert(IInsert obj) {
        this.buffer.append("INSERT").append(" ");
        this.buffer.append(this.getSourceComment(obj));
        this.buffer.append("INTO").append(" ");
        this.append(obj.getGroup());
        if (obj.getElements() != null && obj.getElements().size() != 0) {
            this.buffer.append(" ").append("(");
            int elementCount = obj.getElements().size();
            for (int i = 0; i < elementCount; ++i) {
                this.buffer.append(this.getElementName(obj.getElements().get(i), false));
                if (i >= elementCount - 1) continue;
                this.buffer.append(",");
                this.buffer.append(" ");
            }
            this.buffer.append(")");
        }
    }

    @Override
    public void visit(IBulkInsert obj) {
        this.formatBasicInsert(obj);
        this.buffer.append(" ").append("VALUES").append(" ").append("(");
        int elementCount = obj.getElements().size();
        for (int i = 0; i < elementCount; ++i) {
            this.buffer.append(UNDEFINED_PARAM);
            if (i >= elementCount - 1) continue;
            this.buffer.append(",");
        }
        this.buffer.append(")");
    }

    @Override
    public void visit(IIsNullCriteria obj) {
        this.append(obj.getExpression());
        this.buffer.append(" ").append("IS").append(" ");
        if (obj.isNegated()) {
            this.buffer.append("NOT").append(" ");
        }
        this.buffer.append("NULL");
    }

    @Override
    public void visit(IJoin obj) {
        IFromItem leftItem = obj.getLeftItem();
        if (leftItem instanceof IJoin) {
            this.buffer.append("(");
            this.append(leftItem);
            this.buffer.append(")");
        } else {
            this.append(leftItem);
        }
        this.buffer.append(" ");
        switch (obj.getJoinType()) {
            case CROSS_JOIN: {
                this.buffer.append("CROSS");
                break;
            }
            case FULL_OUTER_JOIN: {
                this.buffer.append("FULL").append(" ").append("OUTER");
                break;
            }
            case INNER_JOIN: {
                this.buffer.append("INNER");
                break;
            }
            case LEFT_OUTER_JOIN: {
                this.buffer.append("LEFT").append(" ").append("OUTER");
                break;
            }
            case RIGHT_OUTER_JOIN: {
                this.buffer.append("RIGHT").append(" ").append("OUTER");
                break;
            }
            default: {
                this.buffer.append(UNDEFINED);
            }
        }
        this.buffer.append(" ").append("JOIN").append(" ");
        IFromItem rightItem = obj.getRightItem();
        if (rightItem instanceof IJoin) {
            this.buffer.append("(");
            this.append(rightItem);
            this.buffer.append(")");
        } else {
            this.append(rightItem);
        }
        List<ICriteria> criteria = obj.getCriteria();
        if (criteria != null && criteria.size() != 0) {
            this.buffer.append(" ").append("ON").append(" ");
            Iterator<ICriteria> critIter = criteria.iterator();
            while (critIter.hasNext()) {
                ICriteria crit = critIter.next();
                if (crit instanceof IPredicateCriteria) {
                    this.append(crit);
                } else {
                    this.buffer.append("(");
                    this.append(crit);
                    this.buffer.append(")");
                }
                if (!critIter.hasNext()) continue;
                this.buffer.append(" ").append("AND").append(" ");
            }
        }
    }

    @Override
    public void visit(ILikeCriteria obj) {
        this.append(obj.getLeftExpression());
        if (obj.isNegated()) {
            this.buffer.append(" ").append("NOT");
        }
        this.buffer.append(" ").append("LIKE").append(" ");
        this.append(obj.getRightExpression());
        if (obj.getEscapeCharacter() != null) {
            this.buffer.append(" ").append("ESCAPE").append(" ").append("'").append(obj.getEscapeCharacter().toString()).append("'");
        }
    }

    @Override
    public void visit(ILimit obj) {
        this.buffer.append("LIMIT").append(" ");
        if (obj.getRowOffset() > 0) {
            this.buffer.append(obj.getRowOffset()).append(",").append(" ");
        }
        this.buffer.append(obj.getRowLimit());
    }

    @Override
    public void visit(ILiteral obj) {
        if (obj.getValue() == null) {
            this.buffer.append("NULL");
        } else {
            Class type = obj.getType();
            String val = obj.getValue().toString();
            if (Number.class.isAssignableFrom(type)) {
                this.buffer.append(val);
            } else if (type.equals(DataTypeManager.DefaultDataClasses.BOOLEAN)) {
                this.buffer.append("{b'").append(val).append("'}");
            } else if (type.equals(DataTypeManager.DefaultDataClasses.TIMESTAMP)) {
                this.buffer.append("{ts'").append(val).append("'}");
            } else if (type.equals(DataTypeManager.DefaultDataClasses.TIME)) {
                this.buffer.append("{t'").append(val).append("'}");
            } else if (type.equals(DataTypeManager.DefaultDataClasses.DATE)) {
                this.buffer.append("{d'").append(val).append("'}");
            } else {
                this.buffer.append("'").append(this.escapeString(val)).append("'");
            }
        }
    }

    @Override
    public void visit(INotCriteria obj) {
        this.buffer.append("NOT").append(" ").append("(");
        this.append(obj.getCriteria());
        this.buffer.append(")");
    }

    @Override
    public void visit(IOrderBy obj) {
        this.buffer.append("ORDER").append(" ").append("BY").append(" ");
        this.append(obj.getItems());
    }

    @Override
    public void visit(IOrderByItem obj) {
        if (obj.getName() != null) {
            String name = SQLStringVisitor.getShortName(obj.getName());
            this.buffer.append(name);
        } else if (obj.getElement() != null) {
            this.append(obj.getElement());
        } else {
            this.buffer.append(UNDEFINED);
        }
        if (!obj.getDirection()) {
            this.buffer.append(" ").append("DESC");
        }
    }

    @Override
    public void visit(IParameter obj) {
        if (obj.getValue() == null) {
            this.buffer.append(UNDEFINED_PARAM);
        } else if (obj.getValue() == null) {
            this.buffer.append("NULL");
        } else {
            this.buffer.append(obj.getValue().toString());
        }
    }

    @Override
    public void visit(IQuery obj) {
        this.visitSelect(obj.getSelect(), obj);
        if (obj.getFrom() != null) {
            this.buffer.append(" ");
            this.append(obj.getFrom());
        }
        if (obj.getWhere() != null) {
            this.buffer.append(" ").append("WHERE").append(" ");
            this.append(obj.getWhere());
        }
        if (obj.getGroupBy() != null) {
            this.buffer.append(" ");
            this.append(obj.getGroupBy());
        }
        if (obj.getHaving() != null) {
            this.buffer.append(" ").append("HAVING").append(" ");
            this.append(obj.getHaving());
        }
        if (obj.getOrderBy() != null) {
            this.buffer.append(" ");
            this.append(obj.getOrderBy());
        }
        if (obj.getLimit() != null) {
            this.buffer.append(" ");
            this.append(obj.getLimit());
        }
    }

    @Override
    public void visit(ISearchedCaseExpression obj) {
        this.buffer.append("CASE");
        int whenCount = obj.getWhenCount();
        for (int i = 0; i < whenCount; ++i) {
            this.buffer.append(" ").append("WHEN").append(" ");
            this.append(obj.getWhenCriteria(i));
            this.buffer.append(" ").append("THEN").append(" ");
            this.append(obj.getThenExpression(i));
        }
        if (obj.getElseExpression() != null) {
            this.buffer.append(" ").append("ELSE").append(" ");
            this.append(obj.getElseExpression());
        }
        this.buffer.append(" ").append("END");
    }

    @Override
    public void visit(ISelect obj) {
        this.visitSelect(obj, null);
    }

    private void visitSelect(ISelect obj, ICommand command) {
        this.buffer.append("SELECT").append(" ");
        this.buffer.append(this.getSourceComment(command));
        if (obj.isDistinct()) {
            this.buffer.append("DISTINCT").append(" ");
        }
        this.append(obj.getSelectSymbols());
    }

    protected String getSourceComment(ICommand command) {
        return "";
    }

    @Override
    public void visit(IScalarSubquery obj) {
        this.buffer.append("(");
        this.append(obj.getQuery());
        this.buffer.append(")");
    }

    @Override
    public void visit(ISelectSymbol obj) {
        this.append(obj.getExpression());
        if (obj.hasAlias()) {
            this.buffer.append(" ").append("AS").append(" ").append(obj.getOutputName());
        }
    }

    @Override
    public void visit(ISubqueryCompareCriteria obj) {
        this.append(obj.getLeftExpression());
        this.buffer.append(" ");
        switch (obj.getOperator()) {
            case EQ: {
                this.buffer.append("=");
                break;
            }
            case GE: {
                this.buffer.append(">=");
                break;
            }
            case GT: {
                this.buffer.append(">");
                break;
            }
            case LE: {
                this.buffer.append("<=");
                break;
            }
            case LT: {
                this.buffer.append("<");
                break;
            }
            case NE: {
                this.buffer.append("<>");
                break;
            }
            default: {
                this.buffer.append(UNDEFINED);
            }
        }
        this.buffer.append(" ");
        switch (obj.getQuantifier()) {
            case ALL: {
                this.buffer.append("ALL");
                break;
            }
            case SOME: {
                this.buffer.append("SOME");
                break;
            }
            default: {
                this.buffer.append(UNDEFINED);
            }
        }
        this.buffer.append(" ");
        this.buffer.append("(");
        this.append(obj.getQuery());
        this.buffer.append(")");
    }

    @Override
    public void visit(ISubqueryInCriteria obj) {
        this.append(obj.getLeftExpression());
        if (obj.isNegated()) {
            this.buffer.append(" ").append("NOT");
        }
        this.buffer.append(" ").append("IN").append(" ").append("(");
        this.append(obj.getQuery());
        this.buffer.append(")");
    }

    @Override
    public void visit(IUpdate obj) {
        this.buffer.append("UPDATE").append(" ");
        this.buffer.append(this.getSourceComment(obj));
        this.append(obj.getGroup());
        this.buffer.append(" ").append("SET").append(" ");
        this.append(obj.getChanges());
        if (obj.getCriteria() != null) {
            this.buffer.append(" ").append("WHERE").append(" ");
            this.append(obj.getCriteria());
        }
    }

    @Override
    public void visit(ISetClauseList obj) {
        this.append(obj.getClauses());
    }

    @Override
    public void visit(ISetClause clause) {
        this.buffer.append(this.getElementName(clause.getSymbol(), false));
        this.buffer.append(" ").append("=").append(" ");
        this.append(clause.getValue());
    }

    @Override
    public void visit(ISetQuery obj) {
        ILimit limit;
        this.appendSetQuery(obj.getLeftQuery());
        this.buffer.append(" ");
        this.appendSetOperation(obj.getOperation());
        if (obj.isAll()) {
            this.buffer.append(" ");
            this.buffer.append("ALL");
        }
        this.buffer.append(" ");
        this.appendSetQuery(obj.getRightQuery());
        IOrderBy orderBy = obj.getOrderBy();
        if (orderBy != null) {
            this.buffer.append(" ");
            this.append(orderBy);
        }
        if ((limit = obj.getLimit()) != null) {
            this.buffer.append(" ");
            this.append(limit);
        }
    }

    protected void appendSetOperation(ISetQuery.Operation operation) {
        this.buffer.append((Object)operation);
    }

    protected boolean useParensForSetQueries() {
        return false;
    }

    protected void appendSetQuery(IQueryCommand obj) {
        if (obj instanceof ISetQuery || this.useParensForSetQueries()) {
            this.buffer.append("(");
            this.append(obj);
            this.buffer.append(")");
        } else {
            this.append(obj);
        }
    }

    public static String getSQLString(ILanguageObject obj) {
        SQLStringVisitor visitor = new SQLStringVisitor();
        visitor.append(obj);
        return visitor.toString();
    }
}

