/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.callback;

import com.metamatrix.core.util.Assertion;
import com.metamatrix.toolbox.ToolboxPlugin;

public class CallbackChoices {
    public static final int UNSPECIFIED_OPTION = -1;
    public static final int YES_NO_OPTION = 0;
    public static final int YES_NO_CANCEL_OPTION = 1;
    public static final int OK_CANCEL_OPTION = 2;
    private static final int STRING_ARRAY_OPTIONS = 3;
    public static final int DISMISSED = -1;
    public static final int YES = 0;
    public static final int NO = 1;
    public static final int CANCEL = 2;
    public static final int OK = 0;
    public static final int UNSPECIFIED_MESSAGE = -1;
    public static final int ERROR_MESSAGE = 0;
    public static final int INFORMATION_MESSAGE = 1;
    public static final int WARNING_MESSAGE = 2;
    public static final int QUESTION_MESSAGE = 3;
    private String prompt;
    private int optionType;
    private int messageType;
    private int defaultOption;
    private String[] options;
    private int selection;

    public CallbackChoices(String prompt, int messageType, int optionType, int defaultOption) {
        boolean toAssert;
        boolean bl = toAssert = messageType == 1 || messageType == 2 || messageType == 0 || messageType == 3;
        if (!toAssert) {
            Assertion.assertTrue((boolean)toAssert, (String)ToolboxPlugin.Util.getString("ERR.003.009.0001"));
        }
        if (prompt == null) {
            Assertion.isNotNull((Object)prompt, (String)ToolboxPlugin.Util.getString("ERR.003.009.0002"));
        }
        if (prompt.length() == 0) {
            Assertion.isNotZeroLength((String)prompt, (String)ToolboxPlugin.Util.getString("ERR.003.009.0003"));
        }
        boolean bl2 = toAssert = optionType == 0 || optionType == 1 || optionType == 2 || optionType == -1;
        if (!toAssert) {
            Assertion.assertTrue((boolean)toAssert, (String)ToolboxPlugin.Util.getString("ERR.003.009.0004"));
        }
        boolean bl3 = toAssert = defaultOption == 0 || defaultOption == 1 || defaultOption == 2 || defaultOption == 0;
        if (!toAssert) {
            Assertion.assertTrue((boolean)toAssert, (String)ToolboxPlugin.Util.getString("ERR.003.009.0005"));
        }
        this.prompt = prompt;
        this.messageType = messageType;
        this.optionType = optionType;
        this.options = null;
        this.defaultOption = defaultOption;
    }

    public CallbackChoices(String prompt, int messageType, String[] options, int defaultOption) {
        boolean toAssert;
        boolean bl = toAssert = messageType == 1 || messageType == 2 || messageType == 0 || messageType == 3;
        if (!toAssert) {
            Assertion.assertTrue((boolean)toAssert, (String)ToolboxPlugin.Util.getString("ERR.003.009.0001"));
        }
        if (prompt == null) {
            Assertion.isNotNull((Object)prompt, (String)ToolboxPlugin.Util.getString("ERR.003.009.0002"));
        }
        if (prompt.length() == 0) {
            Assertion.isNotZeroLength((String)prompt, (String)ToolboxPlugin.Util.getString("ERR.003.009.0003"));
        }
        if (options == null) {
            Assertion.isNotNull((Object)options, (String)ToolboxPlugin.Util.getString("ERR.003.009.0006"));
        }
        if (options.length == 0) {
            Assertion.assertTrue((options.length != 0 ? 1 : 0) != 0, (String)ToolboxPlugin.Util.getString("ERR.003.009.0007"));
        }
        for (int i = 0; i != options.length; ++i) {
            String option = options[i];
            Assertion.isNotNull((Object)option, (String)ToolboxPlugin.Util.getString("ERR.003.009.0008", new Object[]{String.valueOf(i)}));
            Assertion.isNotZeroLength((String)option, (String)ToolboxPlugin.Util.getString("ERR.003.009.0009", new Object[]{String.valueOf(i)}));
        }
        this.prompt = prompt;
        this.messageType = messageType;
        this.options = options;
        this.optionType = 3;
        this.defaultOption = defaultOption;
        if (this.isOutOfBounds(defaultOption)) {
            Assertion.assertTrue((!this.isOutOfBounds(defaultOption) ? 1 : 0) != 0, (String)ToolboxPlugin.Util.getString("ERR.003.009.0010", new Object[]{String.valueOf(defaultOption), String.valueOf(options.length)}));
        }
    }

    public String getPrompt() {
        return this.prompt;
    }

    public int getMessageType() {
        return this.messageType;
    }

    public int getOptionType() {
        return this.optionType;
    }

    public String[] getOptions() {
        return this.options;
    }

    public int getDefaultOption() {
        return this.defaultOption;
    }

    public void setSelectedIndex(int selection) {
        if (this.optionType == 3) {
            if (this.isOutOfBounds(selection)) {
                Assertion.assertTrue((!this.isOutOfBounds(selection) ? 1 : 0) != 0, (String)ToolboxPlugin.Util.getString("ERR.003.009.0011", new Object[]{String.valueOf(selection), String.valueOf(this.options.length)}));
            }
        } else if (this.isOutOfBounds(selection)) {
            Assertion.assertTrue((!this.isOutOfBounds(selection) ? 1 : 0) != 0, (String)ToolboxPlugin.Util.getString("ERR.003.009.0012", new Object[]{selection}));
        }
        this.selection = selection;
        if (selection == -1 && this.optionType != 3) {
            if (this.optionType == 1 || this.optionType == 2) {
                this.selection = 2;
            } else if (this.optionType == 0) {
                this.selection = 1;
            }
        }
    }

    public int getSelectedIndex() {
        return this.selection;
    }

    protected boolean isOutOfBounds(int choice) {
        if (this.optionType == 3) {
            return choice < 0 || choice >= this.options.length || choice == -1;
        }
        if (this.optionType == 0 && (choice == 0 || choice == 1 || choice == -1)) {
            return false;
        }
        if (this.optionType == 1 && (choice == 0 || choice == 1 || choice == 2 || choice == -1)) {
            return false;
        }
        if (this.optionType == 2 && (choice == 0 || choice == 2 || choice == -1)) {
            return false;
        }
        return this.optionType != -1;
    }
}

