/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.callback;

import com.metamatrix.common.callback.Callback;
import com.metamatrix.common.callback.CallbackChoices;
import com.metamatrix.common.object.ObjectDefinitionImpl;
import com.metamatrix.common.object.PropertiedObject;
import com.metamatrix.common.object.PropertiedObjectEditor;
import com.metamatrix.common.object.PropertyDefinitionGroup;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.toolbox.ToolboxPlugin;
import java.util.List;
import java.util.ListIterator;

public class CallbackImpl
extends ObjectDefinitionImpl
implements Callback {
    private CallbackChoices choices;
    private int response;
    private PropertiedObject propertiedObject;
    private PropertiedObjectEditor propertiedObjectEditor;
    private List propertyDefinitionGroups;
    private ListIterator groupIterator = null;
    boolean sequential = false;

    public CallbackImpl(String name, String displayName, CallbackChoices choices) {
        this(name, displayName, choices, null, null, null, false);
    }

    public CallbackImpl(String name, String displayName, CallbackChoices choices, PropertiedObject propertiedObject, PropertiedObjectEditor propertiedObjectEditor) {
        this(name, displayName, choices, propertiedObject, propertiedObjectEditor, null, false);
    }

    public CallbackImpl(String name, String displayName, CallbackChoices choices, PropertiedObject propertiedObject, PropertiedObjectEditor propertiedObjectEditor, List propertyDefinitionGroups, boolean isSequential) {
        super(name, displayName);
        this.choices = choices;
        this.propertiedObject = propertiedObject;
        this.propertiedObjectEditor = propertiedObjectEditor;
        this.propertyDefinitionGroups = propertyDefinitionGroups;
        this.response = choices.getDefaultOption();
    }

    public int getResponse() {
        return this.response;
    }

    @Override
    public CallbackChoices getChoices() {
        return this.choices;
    }

    @Override
    public void setResponse(int responseIndex) {
        this.response = responseIndex;
    }

    @Override
    public boolean hasPropertiedObject() {
        return this.propertiedObject != null;
    }

    @Override
    public boolean hasPropertyDefinitionGroups() {
        boolean result = false;
        if (this.propertyDefinitionGroups != null && !this.propertyDefinitionGroups.isEmpty()) {
            result = true;
        }
        return result;
    }

    @Override
    public boolean isSequential() {
        return this.sequential;
    }

    @Override
    public PropertiedObjectEditor getEditor() {
        return this.propertiedObjectEditor;
    }

    @Override
    public PropertiedObject getPropertiedObject() {
        return this.propertiedObject;
    }

    @Override
    public List getPropertyDefinitionGroups() {
        return this.propertyDefinitionGroups;
    }

    @Override
    public boolean hasNextGroup() {
        boolean result = false;
        if (this.getGroupIterator() != null) {
            result = this.getGroupIterator().hasNext();
        }
        return result;
    }

    @Override
    public boolean hasPreviousGroup() {
        boolean result = false;
        if (this.getGroupIterator() != null) {
            result = this.getGroupIterator().hasPrevious();
        }
        return result;
    }

    @Override
    public PropertyDefinitionGroup getNextGroup() {
        PropertyDefinitionGroup result = null;
        if (this.hasNextGroup()) {
            Object o = this.getGroupIterator().next();
            Assertion.assertTrue((boolean)(o instanceof PropertyDefinitionGroup), (String)ToolboxPlugin.Util.getString("ERR.003.009.0013", new Object[]{o.getClass().getName()}));
            result = (PropertyDefinitionGroup)o;
        }
        return result;
    }

    @Override
    public PropertyDefinitionGroup getPreviousGroup() {
        PropertyDefinitionGroup result = null;
        if (this.hasNextGroup()) {
            Object o = this.getGroupIterator().previous();
            Assertion.assertTrue((boolean)(o instanceof PropertyDefinitionGroup), (String)ToolboxPlugin.Util.getString("ERR.003.009.0013", new Object[]{o.getClass().getName()}));
            result = (PropertyDefinitionGroup)o;
        }
        return result;
    }

    private ListIterator getGroupIterator() {
        if (this.groupIterator == null && this.propertyDefinitionGroups != null) {
            this.groupIterator = this.propertyDefinitionGroups.listIterator();
        }
        return this.groupIterator;
    }
}

