/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.properties;

import bsh.EvalError;
import bsh.Interpreter;
import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.properties.TextManager;
import com.metamatrix.core.util.Assertion;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;

public class ObjectPropertyManager
extends TextManager {
    private static final String VALUE_PHRASE = "propertyValuePhrase";
    private static final String REGISTERED_NAME_SPACES_LIST_PHRASE = "propertyRegisteredNamespaceListPhrase";
    private static final String KEYED_VALUE_NOT_FOUND_MESSAGE = "keyedValueNotFoundMessage";
    private static Interpreter interpreter = new Interpreter();

    protected static void assertClass(String key, Object value, Class expectedClass) {
        Assertion.isInstanceOf((Object)value, (Class)expectedClass, (String)CommonPlugin.Util.getString(VALUE_PHRASE, new Object[]{key}));
    }

    protected static void throwRuntimeException(Exception error) {
        if (error instanceof RuntimeException) {
            throw (RuntimeException)error;
        }
        throw new RuntimeException(error.getMessage());
    }

    public ObjectPropertyManager() {
        this.constructObjectPropertyManager(null, null);
    }

    public ObjectPropertyManager(String namespace) {
        this(namespace, null);
    }

    public ObjectPropertyManager(String[] namespaces) {
        this(Arrays.asList(namespaces));
    }

    public ObjectPropertyManager(List namespaces) {
        super(namespaces);
        this.constructObjectPropertyManager(namespaces, null);
    }

    public ObjectPropertyManager(String namespace, Map propertyMap) {
        super(namespace, propertyMap);
        if (namespace == null) {
            Assertion.isNotNull((Object)namespace, (String)"Namespace");
        }
        this.constructObjectPropertyManager(Arrays.asList(namespace), propertyMap);
    }

    protected void constructObjectPropertyManager(List namespaces, Map propertyMap) {
        try {
            interpreter.set("mgr", (Object)this);
        }
        catch (Exception err) {
            ObjectPropertyManager.throwRuntimeException(err);
        }
    }

    private boolean convertValueToBoolean(String key, Object value) {
        ObjectPropertyManager.assertClass(key, value, Boolean.class);
        return (Boolean)value;
    }

    private byte convertValueToByte(String key, Object value) {
        ObjectPropertyManager.assertClass(key, value, Number.class);
        return ((Number)value).byteValue();
    }

    private char convertValueToChar(String key, Object value) {
        ObjectPropertyManager.assertClass(key, value, Character.class);
        return ((Character)value).charValue();
    }

    private double convertValueToDouble(String key, Object value) {
        ObjectPropertyManager.assertClass(key, value, Number.class);
        return ((Number)value).doubleValue();
    }

    private float convertValueToFloat(String key, Object value) {
        ObjectPropertyManager.assertClass(key, value, Number.class);
        return ((Number)value).floatValue();
    }

    private int convertValueToInt(String key, Object value) {
        ObjectPropertyManager.assertClass(key, value, Number.class);
        return ((Number)value).intValue();
    }

    private long convertValueToLong(String key, Object value) {
        ObjectPropertyManager.assertClass(key, value, Number.class);
        return ((Number)value).longValue();
    }

    private short convertValueToShort(String key, Object value) {
        ObjectPropertyManager.assertClass(key, value, Number.class);
        return ((Number)value).shortValue();
    }

    private String convertValueToString(String key, Object value) {
        ObjectPropertyManager.assertClass(key, value, String.class);
        return (String)value;
    }

    @Override
    protected Object evaluateValue(String key, String value) {
        try {
            return interpreter.eval(value);
        }
        catch (EvalError err) {
            throw new RuntimeException(CommonPlugin.Util.getString(VALUE_PHRASE, new Object[]{key}) + ": " + err.getMessage());
        }
    }

    public boolean getBoolean(String key) {
        return this.convertValueToBoolean(key, this.getNonNullObject(key));
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        Object val = this.get(key);
        if (val == null) {
            return defaultValue;
        }
        return this.convertValueToBoolean(key, val);
    }

    public byte getByte(String key) {
        return this.convertValueToByte(key, this.getNonNullObject(key));
    }

    public byte getByte(String key, byte defaultValue) {
        Object val = this.get(key);
        if (val == null) {
            return defaultValue;
        }
        return this.convertValueToByte(key, val);
    }

    public char getChar(String key) {
        return this.convertValueToChar(key, this.getNonNullObject(key));
    }

    public char getChar(String key, char defaultValue) {
        Object val = this.get(key);
        if (val == null) {
            return defaultValue;
        }
        return this.convertValueToChar(key, val);
    }

    public double getDouble(String key) {
        return this.convertValueToDouble(key, this.getNonNullObject(key));
    }

    public double getDouble(String key, double defaultValue) {
        Object val = this.get(key);
        if (val == null) {
            return defaultValue;
        }
        return this.convertValueToDouble(key, val);
    }

    public float getFloat(String key) {
        return this.convertValueToFloat(key, this.getNonNullObject(key));
    }

    public float getFloat(String key, float defaultValue) {
        Object val = this.get(key);
        if (val == null) {
            return defaultValue;
        }
        return this.convertValueToFloat(key, val);
    }

    public int getInt(String key) {
        return this.convertValueToInt(key, this.getNonNullObject(key));
    }

    public int getInt(String key, int defaultValue) {
        Object val = this.get(key);
        if (val == null) {
            return defaultValue;
        }
        return this.convertValueToInt(key, val);
    }

    public Interpreter getInterpreter() {
        return interpreter;
    }

    public long getLong(String key) {
        return this.convertValueToLong(key, this.getNonNullObject(key));
    }

    public long getLong(String key, long defaultValue) {
        Object val = this.get(key);
        if (val == null) {
            return defaultValue;
        }
        return this.convertValueToLong(key, val);
    }

    protected Object getNonNullObject(String key) {
        Object val = this.get(key);
        if (val == null) {
            String msg = CommonPlugin.Util.getString(KEYED_VALUE_NOT_FOUND_MESSAGE, new Object[]{key, REGISTERED_NAME_SPACES_LIST_PHRASE});
            throw new MissingResourceException(msg, REGISTERED_NAME_SPACES_LIST_PHRASE, key);
        }
        return val;
    }

    public short getShort(String key) {
        return this.convertValueToShort(key, this.getNonNullObject(key));
    }

    public short getShort(String key, short defaultValue) {
        Object val = this.get(key);
        if (val == null) {
            return defaultValue;
        }
        return this.convertValueToShort(key, val);
    }

    public String getString(String key) {
        return this.convertValueToString(key, this.get(key));
    }

    public String getString(String key, String defaultValue) {
        Object val = this.get(key);
        if (val == null) {
            return defaultValue;
        }
        return this.convertValueToString(key, val);
    }
}

