/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.connections;

import com.metamatrix.common.log.LogManager;
import com.metamatrix.console.connections.ConnectionCloser;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.connections.RemoveConnectionDialog;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.console.security.UserCapabilities;
import com.metamatrix.console.ui.dialog.ConsoleLogin;
import com.metamatrix.console.ui.layout.ConsoleMainFrame;
import com.metamatrix.console.ui.layout.ConsoleMenuBar;
import com.metamatrix.console.ui.layout.PanelsTree;
import com.metamatrix.console.ui.layout.TreeAndControllerCoordinator;
import com.metamatrix.console.ui.layout.Workspace;
import com.metamatrix.console.ui.layout.WorkspaceController;
import com.metamatrix.console.ui.layout.WorkspacePanel;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.console.util.StaticProperties;
import com.metamatrix.console.util.StaticUtilities;
import java.util.ArrayList;

public class ConnectionProcessor {
    private static ConnectionProcessor theInstance = null;

    public static ConnectionProcessor getInstance() {
        if (theInstance == null) {
            theInstance = new ConnectionProcessor();
        }
        return theInstance;
    }

    public static ConnectionInfo getCurrentConnection() {
        ConnectionInfo currentConnection = null;
        Workspace workspace = Workspace.getInstance();
        WorkspacePanel currentPanel = workspace.getCurrentPanel();
        if (currentPanel != null) {
            currentConnection = currentPanel.getConnection();
        }
        return currentConnection;
    }

    private ConnectionProcessor() {
    }

    public void handleAddConnectionRequest() {
        boolean continuing;
        ArrayList urlNames = StaticProperties.getURLsCopy();
        if (urlNames == null) {
            urlNames = new ArrayList(0);
        }
        boolean tryableCombinationEntered = false;
        int result = -1;
        ConsoleLogin consoleLogin = null;
        ConnectionInfo[] existingConnections = ModelManager.getConnections();
        String initialPassword = null;
        while (!tryableCombinationEntered) {
            consoleLogin = new ConsoleLogin(urlNames, false, existingConnections, initialPassword);
            result = consoleLogin.showDialog();
            tryableCombinationEntered = !consoleLogin.isExistingConnectionURLAndUserEntered();
            if (tryableCombinationEntered) continue;
            initialPassword = consoleLogin.getPassword();
        }
        switch (result) {
            case 1: {
                continuing = true;
                break;
            }
            case 2: {
                continuing = false;
                break;
            }
            default: {
                LogManager.logCritical((String)"GENERAL", (String)"ConsoleLogin returned unknown status.  Not continuing.");
                continuing = false;
            }
        }
        if (continuing) {
            try {
                StaticUtilities.startWait();
                ConnectionInfo connection = consoleLogin.getConnectionInfo();
                boolean selectConnection = consoleLogin.selectNewConnection();
                this.addConnection(connection, selectConnection);
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            finally {
                StaticUtilities.endWait();
            }
        }
    }

    public void handleRemoveConnectionRequest() {
        ConnectionInfo[] connections = ModelManager.getConnections();
        ConnectionInfo currentConnection = ConnectionProcessor.getCurrentConnection();
        RemoveConnectionDialog dialog = new RemoveConnectionDialog(connections, currentConnection);
        dialog.show();
        ConnectionInfo selection = dialog.getSelectedURL();
        if (selection != null) {
            int matchLoc = -1;
            int i = 0;
            while (matchLoc < 0) {
                if (connections[i].equals(selection)) {
                    matchLoc = i;
                    continue;
                }
                ++i;
            }
            ConnectionInfo conn = connections[matchLoc];
            boolean continuing = true;
            WorkspaceController wc = WorkspaceController.getInstance();
            if (wc.havePendingChanges(conn)) {
                continuing = wc.finishUp(conn);
            }
            if (continuing) {
                this.removeConnection(conn);
            }
        }
    }

    private void addConnection(ConnectionInfo connection, boolean selectConnection) {
        String msg;
        boolean continuing = true;
        boolean initialized = false;
        try {
            ModelManager.init(connection);
        }
        catch (Exception ex) {
            msg = "Error processing new connection";
            LogManager.logError((String)"INITIALIZATION", (Throwable)ex, (String)msg);
            ExceptionUtility.showMessage(msg, ex);
            continuing = false;
        }
        if (continuing) {
            try {
                UserCapabilities.getInstance().init(connection);
            }
            catch (Exception ex) {
                msg = "Error initializing user capabilities";
                LogManager.logError((String)"INITIALIZATION", (Throwable)ex, (String)msg);
                ExceptionUtility.showMessage(msg, ex);
                continuing = false;
            }
            if (continuing) {
                initialized = ModelManager.initViews(connection, false);
                if (initialized) {
                    PanelsTree tree = PanelsTree.createInstance(connection);
                    WorkspaceController controller = WorkspaceController.getInstance();
                    TreeAndControllerCoordinator.createInstance(tree, controller, connection);
                    ConsoleMainFrame.getInstance().addConnection(connection, tree);
                    ConsoleMenuBar.getInstance().setRemoveConnectionEnabled(true);
                    ConsoleMainFrame.getInstance().setConnectionsPanelVisible(true);
                    ConnectionInfo prevConnection = ConnectionProcessor.getCurrentConnection();
                    ConsoleMainFrame.getInstance().selectConnection(connection);
                    if (!selectConnection) {
                        ConsoleMainFrame.getInstance().selectConnection(prevConnection);
                    }
                } else {
                    ModelManager.removeConnection(connection);
                }
            }
        }
        if (!initialized) {
            connection.close();
        }
    }

    public void removeConnection(ConnectionInfo connection) {
        UserCapabilities.getInstance().remove(connection);
        ModelManager.removeConnection(connection);
        WorkspaceController.getInstance().deletePanelsForConnection(connection);
        ConsoleMainFrame.getInstance().removeConnection(connection);
        int connectionCount = ModelManager.getConnections().length;
        if (connectionCount <= 1) {
            ConsoleMenuBar.getInstance().setRemoveConnectionEnabled(false);
            ConsoleMainFrame.getInstance().setConnectionsPanelVisible(false);
        }
        if (connection != null) {
            ConnectionCloser closer = new ConnectionCloser(connection);
            new Thread(closer).start();
        }
    }
}

