/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.connections;

import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.ui.ViewManager;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class RemoveConnectionDialog
extends JDialog {
    private AbstractButton okButton;
    private AbstractButton cancelButton;
    private ConnectionInfo[] connections;
    private boolean cancelled = false;
    private JComboBox urlsBox = null;
    private ConnectionInfo currentConnection;

    public RemoveConnectionDialog(ConnectionInfo[] conns, ConnectionInfo currentConn) {
        super((Frame)ViewManager.getMainFrame(), "Remove Server Connection");
        this.setModal(true);
        this.connections = conns;
        this.currentConnection = currentConn;
        this.createComponent();
    }

    private void createComponent() {
        this.okButton = new ButtonWidget("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                RemoveConnectionDialog.this.okPressed();
            }
        });
        this.okButton.setEnabled(false);
        this.cancelButton = new ButtonWidget("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                RemoveConnectionDialog.this.cancelPressed();
            }
        });
        JPanel buttonsPanel = new JPanel(new GridLayout(1, 2, 10, 0));
        buttonsPanel.add(this.okButton);
        buttonsPanel.add(this.cancelButton);
        JPanel selectionPanel = new JPanel();
        int indexToSelect = -1;
        Object[] items = new Object[this.connections.length + 1];
        items[0] = "(select a connection)";
        for (int i = 0; i < this.connections.length; ++i) {
            items[i + 1] = this.connections[i];
            if (!this.currentConnection.equals(items[i + 1])) continue;
            indexToSelect = i + 1;
        }
        this.urlsBox = new JComboBox<Object>(items);
        this.urlsBox.setEditable(false);
        this.urlsBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ev) {
                RemoveConnectionDialog.this.comboBoxSelectionChanged();
            }
        });
        if (indexToSelect >= 0) {
            this.urlsBox.setSelectedIndex(indexToSelect);
            this.okButton.setEnabled(true);
        }
        GridBagLayout sl = new GridBagLayout();
        selectionPanel.setLayout(sl);
        LabelWidget selectionLabel = new LabelWidget("Remove connection:");
        selectionPanel.add(selectionLabel);
        sl.setConstraints(selectionLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(4, 4, 4, 2), 0, 0));
        selectionPanel.add(this.urlsBox);
        sl.setConstraints(this.urlsBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(4, 2, 4, 4), 0, 0));
        GridBagLayout layout = new GridBagLayout();
        this.getContentPane().setLayout(layout);
        this.getContentPane().add(selectionPanel);
        this.getContentPane().add(buttonsPanel);
        layout.setConstraints(selectionPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        layout.setConstraints(buttonsPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent ev) {
                RemoveConnectionDialog.this.cancelPressed();
            }
        });
        this.pack();
        int height = this.getSize().height;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int screenHeight = screenSize.height;
        int newHeight = Math.max(height, (int)((double)screenHeight * 0.2));
        this.setSize(new Dimension(this.getSize().width, newHeight));
        this.setLocation(StaticUtilities.centerFrame(this.getSize()));
    }

    public ConnectionInfo getSelectedURL() {
        ConnectionInfo ci = null;
        if (!this.cancelled) {
            ci = this.connections.length == 1 ? this.connections[0] : (ConnectionInfo)this.urlsBox.getSelectedItem();
        }
        return ci;
    }

    private void okPressed() {
        this.dispose();
    }

    private void cancelPressed() {
        this.cancelled = true;
        this.dispose();
    }

    private void comboBoxSelectionChanged() {
        int index = this.urlsBox.getSelectedIndex();
        this.okButton.setEnabled(index > 0);
    }
}

