/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.main;

import com.metamatrix.common.log.LogManager;
import com.metamatrix.console.ConsolePlugin;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.console.security.UserCapabilities;
import com.metamatrix.console.ui.dialog.ConsoleLogin;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.console.util.ExternalException;
import com.metamatrix.console.util.StaticProperties;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.core.log.FileLogWriter;
import com.metamatrix.core.log.LogListener;
import com.metamatrix.internal.core.log.PlatformLog;
import com.metamatrix.toolbox.ui.widget.SplashWindow;
import com.metamatrix.toolbox.ui.widget.util.IconFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;

public final class AdminConsoleMain {
    public static final String DEFAULT_LOG_FILE = "../log/console_%VM_NAME%.log";
    public static final String VM_STRING = "%VM_NAME%";
    public static final int VM_STRING_LEN = "%VM_NAME%".length();
    public static final String DEFAULT_ICON = "console.ico";

    public static final void main(String[] args) {
        try {
            AdminConsoleMain a = new AdminConsoleMain();
            a.init();
        }
        catch (Throwable theThrowable) {
            String MSG = "Exception running the Console. Please notify the help desk.";
            if (theThrowable instanceof Exception) {
                ExceptionUtility.showMessage("Exception running the Console. Please notify the help desk.", theThrowable);
                LogManager.logCritical((String)"GENERAL", (Throwable)theThrowable, (String)"Exception running the Console. Please notify the help desk.");
            } else {
                LogManager.logCritical((String)"GENERAL", (String)("Throwable exception in main:" + theThrowable));
            }
            theThrowable.printStackTrace();
            System.exit(-1);
        }
    }

    private void init() throws ExternalException, Exception {
        this.setUpLogging();
        LogManager.logCritical((String)"GENERAL", (String)"Initializing the application");
        try {
            StaticProperties.loadBootStrap();
        }
        catch (Exception e) {
            LogManager.logError((String)"GENERAL", (Throwable)e, (String)"Error loading bootstrap properties");
            ExceptionUtility.showCannotInitializeMessage("Error loading bootstrap.", e);
            throw new RuntimeException(e.getMessage());
        }
        List urls = this.getURLNames();
        ConsoleLogin logon = new ConsoleLogin(urls, true, null);
        int result = logon.showDialog();
        boolean continuing = true;
        JWindow splash = null;
        switch (result) {
            case 1: {
                splash = this.showSplashWindow(splash);
                break;
            }
            case 2: {
                continuing = false;
                break;
            }
            default: {
                LogManager.logCritical((String)"GENERAL", (String)"ConsoleLogin returned unknown status.  Not continuing.");
                continuing = false;
            }
        }
        if (continuing) {
            ConnectionInfo connection = logon.getConnectionInfo();
            this.initModels(connection);
            UserCapabilities uc = UserCapabilities.createInstance();
            uc.init(connection);
            StaticProperties.setUserName(logon.getLoginPanel().getUserNameField().getText());
            StaticProperties.setCurrentURL(connection.getURL());
            try {
                StaticProperties.saveProperties();
            }
            catch (ExternalException err) {
                ExceptionUtility.showMessage("Error saving properties", (Throwable)((Object)err));
            }
            continuing = ModelManager.initViews(connection, true);
            splash.dispose();
        }
        if (!continuing) {
            System.exit(0);
        }
    }

    private JWindow showSplashWindow(JWindow splash) {
        String alternateSplash = ConsolePlugin.Util.getString("Console.alternateSplash");
        ImageIcon altSplashIcon = null;
        if (alternateSplash != null && alternateSplash.trim().length() > 0) {
            altSplashIcon = IconFactory.getIconForImageFile(alternateSplash);
        }
        JPanel panel = null;
        if (altSplashIcon != null) {
            panel = new JPanel();
            panel.add(new JLabel(altSplashIcon));
            splash = new JWindow();
            splash.getContentPane().add(panel);
            splash.pack();
        } else {
            splash = new SplashWindow();
        }
        splash.setLocation(StaticUtilities.centerFrame(splash.getSize()));
        splash.show();
        return splash;
    }

    private List getURLNames() {
        ArrayList urlNames = StaticProperties.getURLsCopy();
        if (urlNames == null) {
            urlNames = new ArrayList(0);
        }
        return urlNames;
    }

    private void initModels(ConnectionInfo connection) throws Exception {
        ModelManager.init(connection);
    }

    private void setUpLogging() {
        String captureSystemOutProp = "metamatrix.log.captureSystemOut";
        String captureSystemErrProp = "metamatrix.log.captureSystemErr";
        String captureSystemOutVal = System.getProperty(captureSystemOutProp, "false");
        boolean captureSystemOut = captureSystemOutVal.equalsIgnoreCase("true");
        String captureSystemErrVal = System.getProperty(captureSystemErrProp, "false");
        boolean captureSystemErr = captureSystemErrVal.equalsIgnoreCase("true");
        String logFileProp = "metamatrix.log.file";
        String logFile = System.getProperty(logFileProp);
        File tmpFile = null;
        if (logFile == null) {
            logFile = this.substituteVMName(DEFAULT_LOG_FILE);
        } else {
            try {
                tmpFile = new File(this.substituteVMName(logFile));
            }
            catch (Exception ex) {
                logFile = DEFAULT_LOG_FILE;
            }
        }
        if (tmpFile == null) {
            tmpFile = new File(logFile);
        }
        if (tmpFile.exists()) {
            int index = logFile.lastIndexOf(46);
            String logFileBegin = logFile.substring(0, index);
            String logFileEnd = logFile.substring(index);
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd_HH-mm");
            String logFileDate = formatter.format(new Date()).toString();
            tmpFile.renameTo(new File(logFileBegin + logFileDate + logFileEnd));
        }
        try {
            FileOutputStream fos = new FileOutputStream(tmpFile);
            PrintStream log = new PrintStream(fos);
            if (captureSystemOut) {
                System.setOut(log);
            }
            if (captureSystemErr) {
                System.setErr(log);
            }
            FileLogWriter flw = new FileLogWriter(tmpFile);
            PlatformLog logger = new PlatformLog();
            logger.addListener((LogListener)flw);
            LogManager.setLogListener((LogListener)logger);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        StaticProperties.setLogDirectory(tmpFile.getParentFile());
    }

    private String substituteVMName(String str) {
        String outputStr;
        int index = str.indexOf(VM_STRING);
        if (index >= 0) {
            String theVM = "MMProcess";
            outputStr = str.substring(0, index) + theVM + str.substring(index + VM_STRING_LEN);
        } else {
            outputStr = str;
        }
        return outputStr;
    }

    static {
        IconFactory.setDefaultJarPath("/com/metamatrix/console/images/");
        IconFactory.setDefaultRelativePath("../images/");
    }
}

