/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.models;

import com.metamatrix.common.actions.ModificationActionQueue;
import com.metamatrix.common.config.api.AuthenticationProvider;
import com.metamatrix.common.config.api.ComponentDefn;
import com.metamatrix.common.config.api.ComponentObject;
import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.common.config.api.ComponentTypeID;
import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ConfigurationObjectEditor;
import com.metamatrix.common.config.api.ServiceComponentDefn;
import com.metamatrix.common.object.PropertiedObject;
import com.metamatrix.common.object.PropertiedObjectEditor;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.ConfigurationManager;
import com.metamatrix.console.models.ConfigurationPropertiedObjectEditor;
import com.metamatrix.console.models.Manager;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.console.ui.views.authorization.ProvidersChangedEvent;
import com.metamatrix.console.ui.views.authorization.ProvidersChangedListener;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.platform.admin.api.ConfigurationAdminAPI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class AuthenticationProviderManager
extends Manager {
    private List allProviders = null;
    private HashMap providerNameMap = null;
    private final HashSet providersChangedListeners = new HashSet();

    public AuthenticationProviderManager(ConnectionInfo connection) {
        super(connection);
    }

    public ConfigurationAdminAPI getConfigurationAdminAPI() {
        return ModelManager.getConfigurationAPI(this.getConnection());
    }

    public void deleteProvider(ComponentDefn provider) throws Exception {
        ConfigurationObjectEditor coeEditorForDelete = this.getAuthenticationProviderEditor();
        coeEditorForDelete.delete((ComponentObject)provider, this.getNextStartupConfig());
        List lstActions = null;
        try {
            lstActions = coeEditorForDelete.getDestination().getActions();
        }
        catch (Exception e) {
            ExceptionUtility.showMessage("Failed to get actions from the editor", e);
        }
        try {
            this.getConfigurationAdminAPI().executeTransaction(lstActions);
            ModelManager.getConfigurationManager(this.getConnection()).setRefreshNeeded();
        }
        catch (Exception e) {
            ExceptionUtility.showMessage("Failed trying to save the configuration on the server", e);
        }
    }

    public void addProvidersChangeListener(ProvidersChangedListener listener) {
        if (listener != null) {
            this.providersChangedListeners.add(listener);
        }
    }

    public void removeProvidersChangeListener(ProvidersChangedListener listener) {
        if (listener != null) {
            this.providersChangedListeners.remove(listener);
        }
    }

    private void fireProvidersChangedEvent(int type, Object changedObject) {
        ProvidersChangedEvent pce = new ProvidersChangedEvent(type, changedObject);
        for (ProvidersChangedListener next : this.providersChangedListeners) {
            next.providersChanged(pce);
        }
    }

    public void deleteProviders(Collection providers) throws Exception {
        ConfigurationObjectEditor coeEditorForDelete = this.getAuthenticationProviderEditor();
        Configuration ns = this.getNextStartupConfig();
        for (AuthenticationProvider provider : providers) {
            coeEditorForDelete.delete((ComponentObject)provider, ns, true);
        }
        List lstActions = null;
        try {
            lstActions = coeEditorForDelete.getDestination().getActions();
        }
        catch (Exception e) {
            ExceptionUtility.showMessage("Failed to get actions from the editor", e);
        }
        try {
            this.getConfigurationAdminAPI().executeTransaction(lstActions);
            ModelManager.getConfigurationManager(this.getConnection()).setRefreshNeeded();
        }
        catch (Exception e) {
            ExceptionUtility.showMessage("Failed trying to save the configuration on the server", e);
        }
        for (AuthenticationProvider provider : providers) {
            this.fireProvidersChangedEvent(1, provider);
        }
    }

    public Collection getAllProviders() throws Exception {
        return this.getNextStartupConfig().getAuthenticationProviders();
    }

    public List getAllProviderTypes() {
        return this.getAllProviderTypes(false);
    }

    public List getAllProviderTypes(boolean bForceRefresh) {
        if (bForceRefresh) {
            this.allProviders = null;
            this.providerNameMap = null;
        }
        if (this.allProviders == null) {
            ConfigurationAdminAPI configAPI = this.getConfigurationAdminAPI();
            boolean includeDeprecated = false;
            Collection allTypes = null;
            try {
                allTypes = configAPI.getAllComponentTypes(includeDeprecated);
            }
            catch (Exception e) {
                ExceptionUtility.showMessage("Failed trying to retrieve All Types", e);
            }
            this.allProviders = new ArrayList(allTypes.size());
            ArrayList<String> sortProviders = new ArrayList<String>(allTypes.size());
            this.providerNameMap = new HashMap(allTypes.size());
            Iterator iter = allTypes.iterator();
            ComponentType aType = null;
            while (iter.hasNext()) {
                aType = (ComponentType)iter.next();
                if (aType.getComponentTypeCode() != 11) continue;
                sortProviders.add(aType.getID().getName());
                this.providerNameMap.put(aType.getName(), aType);
            }
            Collections.sort(sortProviders, Collections.reverseOrder());
            for (Object e : sortProviders) {
                this.allProviders.add(this.providerNameMap.get(e));
            }
        }
        return this.allProviders;
    }

    public Configuration getNextStartupConfig() throws Exception {
        Configuration cfg = ModelManager.getConfigurationAPI(this.getConnection()).getNextStartupConfiguration();
        return cfg;
    }

    public boolean providerTypeNameAlreadyExists(String sName) throws Exception {
        boolean bNameExists = false;
        return bNameExists;
    }

    public ComponentType getAuthProvider(ServiceComponentDefn serviceDefn) {
        ComponentType ctAuthProvider = null;
        ComponentTypeID authProviderID = serviceDefn.getComponentTypeID();
        try {
            ctAuthProvider = this.getConfigurationAdminAPI().getComponentType(authProviderID);
        }
        catch (Exception e) {
            ExceptionUtility.showMessage("Failed to get Membership Domain Provider from ID", e);
        }
        return ctAuthProvider;
    }

    public ConfigurationObjectEditor getAuthenticationProviderEditor() throws Exception {
        ConfigurationAdminAPI configAPI = this.getConfigurationAdminAPI();
        ConfigurationObjectEditor authenticationProviderEditor = null;
        authenticationProviderEditor = configAPI.createEditor();
        return authenticationProviderEditor;
    }

    public AuthenticationProvider getTentativeAuthenticationProvider(ComponentType ctProvider, ConfigurationObjectEditor coe, String sProviderName) throws Exception {
        AuthenticationProvider provider = coe.createAuthenticationProviderComponent(Configuration.NEXT_STARTUP_ID, (ComponentTypeID)ctProvider.getID(), sProviderName);
        Properties defaultProps = ModelManager.getConfigurationManager(this.getConnection()).getConfigModel(Configuration.NEXT_STARTUP_ID).getDefaultPropertyValues((ComponentTypeID)ctProvider.getID());
        provider = (AuthenticationProvider)coe.modifyProperties((ComponentObject)provider, defaultProps, 0);
        return provider;
    }

    public AuthenticationProvider copyAuthenticationProvider(AuthenticationProvider original, ConfigurationObjectEditor coe, String sProviderName) throws Exception {
        AuthenticationProvider provider = coe.createAuthenticationProviderComponent(Configuration.NEXT_STARTUP_ID, original, sProviderName);
        return provider;
    }

    public PropertiedObject getPropertiedObject(ComponentDefn cdAuthProvider) throws Exception {
        ConfigurationManager configurationManager = ModelManager.getConfigurationManager(this.getConnection());
        PropertiedObject connectorBindingPO = configurationManager.getPropertiedObjectForComponentObject((ComponentObject)cdAuthProvider);
        return connectorBindingPO;
    }

    public void saveProvider(ModificationActionQueue maqActionQForProvider) throws Exception {
        ConfigurationAdminAPI configAPI = this.getConfigurationAdminAPI();
        configAPI.executeTransaction(maqActionQForProvider.popActions());
        ModelManager.getConfigurationManager(this.getConnection()).setRefreshNeeded();
    }

    public PropertiedObjectEditor getPropertiedObjectEditor(ModificationActionQueue maqActionQForBinding) throws Exception {
        ConfigurationPropertiedObjectEditor propertiedObjectEditor = new ConfigurationPropertiedObjectEditor(this.getConnection(), maqActionQForBinding);
        return propertiedObjectEditor;
    }

    public PropertiedObjectEditor getPropertiedObjectEditor() throws Exception {
        ConfigurationPropertiedObjectEditor propertiedObjectEditor = new ConfigurationPropertiedObjectEditor(this.getConnection());
        return propertiedObjectEditor;
    }

    public void createAuthenticationProvider(AuthenticationProvider provider, ConfigurationObjectEditor coe) throws Exception {
        Configuration config = this.getNextStartupConfig();
        coe.addAuthenticationProvider(config, provider);
        this.getConfigurationAdminAPI().executeTransaction(coe.getDestination().popActions());
        ModelManager.getConfigurationManager(this.getConnection()).setRefreshNeeded();
        this.fireProvidersChangedEvent(4, provider);
    }
}

