/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.models;

import com.metamatrix.admin.AdminPlugin;
import com.metamatrix.admin.api.exception.security.InvalidSessionException;
import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.security.AuthorizationException;
import com.metamatrix.common.actions.ModificationActionQueue;
import com.metamatrix.common.config.api.ComponentDefnID;
import com.metamatrix.common.config.api.ComponentObject;
import com.metamatrix.common.config.api.ComponentTypeDefn;
import com.metamatrix.common.config.api.ComponentTypeID;
import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ConfigurationID;
import com.metamatrix.common.config.api.ConfigurationModelContainer;
import com.metamatrix.common.config.api.ConfigurationObjectEditor;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.config.api.DeployedComponent;
import com.metamatrix.common.config.api.DeployedComponentID;
import com.metamatrix.common.config.api.Host;
import com.metamatrix.common.config.api.HostID;
import com.metamatrix.common.config.api.ProductServiceConfig;
import com.metamatrix.common.config.api.ProductServiceConfigID;
import com.metamatrix.common.config.api.ProductType;
import com.metamatrix.common.config.api.ProductTypeID;
import com.metamatrix.common.config.api.ResourceDescriptor;
import com.metamatrix.common.config.api.ServiceComponentDefn;
import com.metamatrix.common.config.api.ServiceComponentDefnID;
import com.metamatrix.common.config.api.VMComponentDefn;
import com.metamatrix.common.config.api.VMComponentDefnID;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.common.config.model.BasicConfigurationObjectEditor;
import com.metamatrix.common.config.xml.XMLConfigurationImportExportUtility;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.namedobject.BaseID;
import com.metamatrix.common.object.PropertiedObject;
import com.metamatrix.common.object.PropertyDefinition;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.ConfigurationPropertiedObjectEditor;
import com.metamatrix.console.models.Manager;
import com.metamatrix.console.models.ManagerListener;
import com.metamatrix.console.models.ModelChangedEvent;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.console.ui.views.deploy.event.ConfigurationChangeEvent;
import com.metamatrix.console.ui.views.deploy.event.ConfigurationChangeListener;
import com.metamatrix.console.util.ExternalException;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.platform.admin.api.ConfigurationAdminAPI;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public final class ConfigurationManager
extends Manager
implements ManagerListener {
    private ConfigurationObjectEditor configEditor;
    private HashMap configs = new HashMap();
    private HashMap hostDeployments = new HashMap();
    private HashMap deployedPscs = new HashMap();
    private HashMap deployedServices = new HashMap();
    private HashMap prodPscDefs = new HashMap();
    private HashMap serviceDefnMap = new HashMap();
    private ConfigurationID nextStartUpId = Configuration.NEXT_STARTUP_ID;
    private ConfigurationID startUpId = Configuration.STARTUP_ID;
    private ArrayList listeners = new ArrayList();
    private boolean refreshNeeded = false;
    private Map typeIDtoAllTypeDefns = new HashMap();

    public ConfigurationManager(ConnectionInfo connection) throws ExternalException {
        super(connection);
        this.init();
        this.refreshImpl();
    }

    @Override
    public void modelChanged(ModelChangedEvent e) {
        if (e.getMessage().equals("Managed model changed.")) {
            try {
                this.refreshConfigs();
            }
            catch (ExternalException ee) {
                LogManager.logCritical((String)"CONFIGURATION", (String)"ConfigurationManager.refreshConfigs:Error refreshing configuration.");
            }
        }
    }

    public void addConfigurationChangeListener(ConfigurationChangeListener theListener) {
        this.listeners.add(theListener);
    }

    private void notifyHostChangeToConfigs(Host theHost, int eventType) {
        for (ConfigurationModelContainer config : this.configs.values()) {
            this.fireConfigurationChange(new ConfigurationChangeEvent(eventType, theHost, config.getConfiguration(), new Object[]{config.getConfiguration()}));
        }
    }

    public void changeDeployedPsc(ProductServiceConfig theOldPsc, ProductServiceConfig theNewPsc, VMComponentDefn theProcess, Host theHost, ConfigurationID theConfigId) throws ExternalException {
        this.deleteDeployedPsc(theOldPsc, theProcess, theHost, theConfigId);
        this.deployPsc(theNewPsc, theProcess, theHost, theConfigId);
    }

    public void commitImportedObjects(Collection theImportedObjects) throws ExternalException {
        try {
            ConfigurationObjectEditor importEditor = this.getAPI().createEditor();
            importEditor.delete(this.nextStartUpId);
            importEditor.createConfiguration(this.nextStartUpId, theImportedObjects);
            this.getAPI().executeTransaction(importEditor.getDestination().getActions());
        }
        catch (Exception theException) {
            theException.printStackTrace();
            throw new ExternalException(this.formatErrorMsg("commitImportedObjects", theException), theException);
        }
    }

    public Host createHost(String theHostName) throws ExternalException {
        Host host = null;
        Host testHost = this.getHost(theHostName, Configuration.NEXT_STARTUP_ID);
        if (testHost != null) {
            return testHost;
        }
        ConfigurationObjectEditor editor = null;
        try {
            Configuration config = this.getConfig(Configuration.NEXT_STARTUP_ID);
            editor = this.getEditor();
            host = editor.createHost(config, theHostName);
            Properties defaultProps = this.getConfigModel(Configuration.NEXT_STARTUP_ID).getDefaultPropertyValues(host.getComponentTypeID());
            host = (Host)editor.modifyProperties((ComponentObject)host, defaultProps, 0);
            this.getAPI().executeTransaction(editor.getDestination().popActions());
            this.notifyHostChangeToConfigs(host, 4);
        }
        catch (Exception theException) {
            if (editor != null) {
                editor.getDestination().popActions();
            }
            theException.printStackTrace();
            throw new ExternalException(this.formatErrorMsg("createHost", "host=" + theHostName, theException), theException);
        }
        return host;
    }

    public VMComponentDefn createProcess(String theProcessName, String portNumber, Host theHost, ConfigurationID theConfigId) throws ExternalException {
        ConfigurationObjectEditor editor = null;
        try {
            ArrayList<BaseID> procs;
            Configuration config = this.getConfig(theConfigId);
            editor = this.getEditor();
            VMComponentDefn processDefn = editor.createVMComponentDefn(config, (HostID)theHost.getID(), VMComponentDefn.VM_COMPONENT_TYPE_ID, theProcessName);
            ConfigurationModelContainer cmc = this.getConfigModel(theConfigId);
            Properties defaultProps = cmc.getDefaultPropertyValues(processDefn.getComponentTypeID());
            defaultProps.putAll((Map<?, ?>)processDefn.getProperties());
            String min = cmc.getConfiguration().getProperty("vm.starter.minHeapSize");
            String max = cmc.getConfiguration().getProperty("vm.starter.maxHeapSize");
            if (min != null && min.length() > 0) {
                defaultProps.setProperty("vm.starter.minHeapSize", min);
            }
            if (max != null && max.length() > 0) {
                defaultProps.setProperty("vm.starter.maxHeapSize", max);
            }
            if (portNumber != null && portNumber.length() > 0) {
                defaultProps.setProperty("vm.socketPort", portNumber);
            }
            processDefn = (VMComponentDefn)editor.modifyProperties((ComponentObject)processDefn, defaultProps, 0);
            this.getAPI().executeTransaction(editor.getDestination().popActions());
            HashMap<ConfigurationID, ArrayList<BaseID>> map = (HashMap<ConfigurationID, ArrayList<BaseID>>)this.hostDeployments.get(theHost.getID());
            if (map == null) {
                map = new HashMap<ConfigurationID, ArrayList<BaseID>>();
                this.hostDeployments.put(theHost.getID(), map);
            }
            if ((procs = (ArrayList<BaseID>)map.get(theConfigId)) == null) {
                procs = new ArrayList<BaseID>(1);
                map.put(theConfigId, procs);
            }
            procs.add(processDefn.getID());
            this.fireConfigurationChange(new ConfigurationChangeEvent(4, processDefn, config, new Object[]{theHost, config}));
            return processDefn;
        }
        catch (Exception theException) {
            if (editor != null) {
                editor.getDestination().popActions();
            }
            theException.printStackTrace();
            throw new ExternalException(this.formatErrorMsg("createProcess", "process=" + theProcessName + ", host=" + theHost + ", config=" + theConfigId, theException), theException);
        }
    }

    public ProductServiceConfig copyPscDef(String thePscDefName, ProductServiceConfig thePscBeingCopied, ConfigurationID theConfigId) throws ExternalException {
        ConfigurationObjectEditor editor = null;
        String attemptedAction = "";
        try {
            Configuration config = this.getConfig(theConfigId);
            editor = this.getEditor();
            attemptedAction = "createProductServiceConfig()";
            ProductServiceConfig pscDef = editor.createProductServiceConfig(config, thePscBeingCopied, thePscDefName);
            attemptedAction = "executeTransaction()";
            this.getAPI().executeTransaction(editor.getDestination().popActions());
            ProductType product = this.getProduct(thePscBeingCopied);
            Map map = (Map)this.prodPscDefs.get(product.getID());
            attemptedAction = "map.get()";
            ArrayList<BaseID> pscDefs = (ArrayList<BaseID>)map.get(theConfigId);
            if (pscDefs == null) {
                pscDefs = new ArrayList<BaseID>();
            }
            attemptedAction = "pscDefs.add()";
            pscDefs.add(pscDef.getID());
            attemptedAction = "fireConfigurationChange()";
            this.fireConfigurationChange(new ConfigurationChangeEvent(4, pscDef, config, new Object[]{this.getProduct(pscDef), config}));
            attemptedAction = "getServiceDefinitions()";
            this.getServiceDefinitions(pscDef, config);
            return pscDef;
        }
        catch (Exception theException) {
            if (editor != null) {
                editor.getDestination().popActions();
            }
            theException.printStackTrace();
            throw new ExternalException(this.formatErrorMsg("createPscDef", "psc name=" + thePscDefName + ", source PSC=" + thePscBeingCopied + ", config=" + theConfigId + ", attempted action = " + attemptedAction, theException), theException);
        }
    }

    public ProductServiceConfig updatePscDef(ProductServiceConfig thePscDef, Collection theServiceIds) throws ExternalException {
        ConfigurationObjectEditor editor = null;
        String attemptedAction = "";
        try {
            Configuration config = this.getConfig(Configuration.NEXT_STARTUP_ID);
            editor = this.getEditor();
            attemptedAction = "updateProductServiceConfig()";
            thePscDef = editor.updateProductServiceConfig(config, thePscDef, theServiceIds);
            attemptedAction = "executeTransaction()";
            this.getAPI().executeTransaction(editor.getDestination().popActions());
            ProductType product = this.getProduct(thePscDef);
            Map map = (Map)this.prodPscDefs.get(product.getID());
            attemptedAction = "map.get()";
            ArrayList<BaseID> pscDefs = (ArrayList<BaseID>)map.get(config.getID());
            if (pscDefs == null) {
                pscDefs = new ArrayList<BaseID>();
            }
            attemptedAction = "pscDefs.updated()";
            pscDefs.add(thePscDef.getID());
            attemptedAction = "fireConfigurationChange()";
            this.fireConfigurationChange(new ConfigurationChangeEvent(2, thePscDef, config, new Object[]{this.getProduct(thePscDef), config}));
            attemptedAction = "getServiceDefinitions()";
            this.getServiceDefinitions(thePscDef, config);
            return thePscDef;
        }
        catch (Exception theException) {
            if (editor != null) {
                editor.getDestination().popActions();
            }
            theException.printStackTrace();
            throw new ExternalException(this.formatErrorMsg("updatePscDef", "psc name=" + thePscDef.getName() + ", prodType=" + thePscDef.getComponentTypeID() + ", config=" + Configuration.NEXT_STARTUP_ID + ", attempted action = " + attemptedAction, theException), theException);
        }
    }

    public ProductServiceConfig createPscDef(String thePscDefName, ProductTypeID thePscProdTypeID, Collection theServiceIds, ConfigurationID theConfigId) throws ExternalException {
        ConfigurationObjectEditor editor = null;
        String attemptedAction = "";
        try {
            Configuration config = this.getConfig(theConfigId);
            editor = this.getEditor();
            attemptedAction = "createProductServiceConfig()";
            ProductServiceConfig pscDef = editor.createProductServiceConfig(config, thePscProdTypeID, thePscDefName);
            for (ServiceComponentDefnID id : theServiceIds) {
                editor.addServiceComponentDefn(pscDef, id);
            }
            attemptedAction = "executeTransaction()";
            this.getAPI().executeTransaction(editor.getDestination().popActions());
            ProductType product = this.getProduct(pscDef);
            Map map = (Map)this.prodPscDefs.get(product.getID());
            attemptedAction = "map.get()";
            ArrayList<BaseID> pscDefs = (ArrayList<BaseID>)map.get(theConfigId);
            if (pscDefs == null) {
                pscDefs = new ArrayList<BaseID>();
            }
            attemptedAction = "pscDefs.add()";
            pscDefs.add(pscDef.getID());
            attemptedAction = "fireConfigurationChange()";
            this.fireConfigurationChange(new ConfigurationChangeEvent(4, pscDef, config, new Object[]{this.getProduct(pscDef), config}));
            attemptedAction = "getServiceDefinitions()";
            this.getServiceDefinitions(pscDef, config);
            return pscDef;
        }
        catch (Exception theException) {
            if (editor != null) {
                editor.getDestination().popActions();
            }
            theException.printStackTrace();
            throw new ExternalException(this.formatErrorMsg("createPscDef", "psc name=" + thePscDefName + ", prodType=" + thePscProdTypeID + ", config=" + theConfigId + ", attempted action = " + attemptedAction, theException), theException);
        }
    }

    private void delete(ComponentObject theObject, ConfigurationID theConfigId, boolean theDeleteDependenciesFlag) throws Exception {
        ConfigurationObjectEditor editor = null;
        try {
            editor = this.getEditor();
            editor.delete(theObject, this.getConfig(theConfigId), theDeleteDependenciesFlag);
            if (editor.getDestination().getActionCount() != 0) {
                this.getAPI().executeTransaction(editor.getDestination().popActions());
            }
        }
        catch (Exception theException) {
            if (editor != null) {
                editor.getDestination().popActions();
            }
            throw theException;
        }
    }

    public void deleteDeployedPsc(ProductServiceConfig thePsc, VMComponentDefn theProcess, Host theHost, ConfigurationID theConfigId) throws ExternalException {
        ConfigurationObjectEditor editor = null;
        try {
            Configuration config = this.getConfig(theConfigId);
            Collection services = config.getDeployedServices(theProcess, thePsc);
            if (services != null) {
                editor = this.getEditor();
                for (ComponentObject service : services) {
                    editor.delete(service, config, true);
                }
                this.getAPI().executeTransaction(editor.getDestination().popActions());
                Collection pscs = (Collection)this.deployedPscs.get(theProcess.getID());
                pscs.remove(thePsc.getID());
                HashMap map = (HashMap)this.deployedServices.get(thePsc.getID());
                map.remove(theProcess.getID());
                this.fireConfigurationChange(new ConfigurationChangeEvent(1, thePsc, config, new Object[]{theProcess, theHost, config}));
            }
        }
        catch (Exception theException) {
            if (editor != null) {
                editor.getDestination().popActions();
            }
            theException.printStackTrace();
            throw new ExternalException(this.formatErrorMsg("deleteDeployedPsc", "PSC=" + thePsc + ", process=" + theProcess + ", host=" + theHost + ", config=" + theConfigId, theException), theException);
        }
    }

    public void deleteHost(Host theHost, ConfigurationID theConfigId) throws ExternalException {
        try {
            ConfigurationObjectEditor editor = this.getEditor();
            editor.delete(theHost);
            this.getAPI().executeTransaction(editor.getDestination().popActions());
            this.deleteHostFromConfigs(theHost);
            LogManager.logDetail((String)"PSC-DEPLOYMENT", (Object[])new Object[]{"ConfigurationManager.deleteHost:" + theHost});
        }
        catch (Exception theException) {
            theException.printStackTrace();
            throw new ExternalException(this.formatErrorMsg("deleteHost", "host=" + theHost + ", config=" + theConfigId, theException), theException);
        }
    }

    private void deleteHostFromConfigs(Host theHost) {
        for (ConfigurationModelContainer config : this.configs.values()) {
            this.fireConfigurationChange(new ConfigurationChangeEvent(1, theHost, config.getConfiguration(), new Object[]{config.getConfiguration()}));
        }
    }

    public void deleteProcess(VMComponentDefn theProcess, ConfigurationID theConfigId) throws ExternalException {
        try {
            Configuration config = this.getConfig(theConfigId);
            HostID hostId = theProcess.getHostID();
            this.delete((ComponentObject)theProcess, theConfigId, false);
            BaseID processID = theProcess.getID();
            ArrayList pscs = (ArrayList)this.deployedPscs.get(processID);
            if (pscs != null) {
                pscs = new ArrayList();
                this.deployedPscs.remove(processID);
            }
            for (Map pscToSvcMap : this.deployedServices.values()) {
                pscToSvcMap.remove(processID);
            }
            HashMap map = (HashMap)this.hostDeployments.get(hostId);
            Collection procs = (Collection)map.get(theConfigId);
            if (procs != null) {
                procs.remove(processID);
            }
            Host host = config.getHost(hostId.getFullName());
            this.fireConfigurationChange(new ConfigurationChangeEvent(1, theProcess, config, new Object[]{host, config}));
        }
        catch (Exception theException) {
            theException.printStackTrace();
            throw new ExternalException(this.formatErrorMsg("deleteProcess", "process=" + theProcess + ", config=" + theConfigId, theException), theException);
        }
    }

    public void deletePscDefinition(ProductServiceConfig thePsc, ProductType theProduct, ConfigurationID theConfigId) throws ExternalException {
        try {
            this.delete((ComponentObject)thePsc, theConfigId, false);
            Map map = (Map)this.prodPscDefs.get(theProduct.getID());
            Collection pscDefs = (Collection)map.get(theConfigId);
            if (pscDefs != null) {
                pscDefs.remove(thePsc.getID());
            }
            this.fireConfigurationChange(new ConfigurationChangeEvent(1, thePsc, this.getConfig(theConfigId), new Object[]{theProduct, this.getConfig(theConfigId)}));
        }
        catch (Exception theException) {
            theException.printStackTrace();
            throw new ExternalException(this.formatErrorMsg("deletePscDefinition", "PSC=" + thePsc + ", product=" + theProduct + ", config=" + theConfigId, theException), theException);
        }
    }

    public void deployPsc(ProductServiceConfig thePsc, VMComponentDefn theProcess, Host theHost, ConfigurationID theConfigId) throws ExternalException {
        ConfigurationObjectEditor editor = null;
        try {
            editor = this.getEditor();
            Configuration config = this.getConfig(theConfigId);
            Collection result = editor.deployProductServiceConfig(config, thePsc, (HostID)theHost.getID(), (VMComponentDefnID)theProcess.getID());
            this.getAPI().executeTransaction(editor.getDestination().popActions());
            ArrayList<BaseID> pscs = (ArrayList<BaseID>)this.deployedPscs.get(theProcess.getID());
            if (pscs == null) {
                pscs = new ArrayList<BaseID>();
                this.deployedPscs.put(theProcess.getID(), pscs);
            }
            pscs.add(thePsc.getID());
            HashMap map = new HashMap();
            ArrayList<BaseID> ids = new ArrayList<BaseID>(result.size());
            for (DeployedComponent dc : result) {
                ids.add(dc.getID());
            }
            map.put(theProcess.getID(), ids);
            this.deployedServices.put(thePsc.getID(), map);
            this.fireConfigurationChange(new ConfigurationChangeEvent(4, thePsc, config, new Object[]{theProcess, theHost, config}));
            if (result != null) {
                for (DeployedComponent service : result) {
                    this.fireConfigurationChange(new ConfigurationChangeEvent(4, service, config, new Object[]{thePsc, theProcess, theHost, config}));
                }
            }
        }
        catch (Exception theException) {
            if (editor != null) {
                editor.getDestination().popActions();
            }
            theException.printStackTrace();
            throw new ExternalException(this.formatErrorMsg("deployPsc", "PSC=" + thePsc + ", process=" + theProcess + ", host=" + theHost + ", config=" + theConfigId, theException), theException);
        }
    }

    private void fireConfigurationChange(ConfigurationChangeEvent theEvent) {
        LogManager.logDetail((String)"PSC-DEPLOYMENT", (Object[])new Object[]{"ConfigurationChangeEvent=" + theEvent.paramString()});
        int size = this.listeners.size();
        for (int i = 0; i < size; ++i) {
            ConfigurationChangeListener l = (ConfigurationChangeListener)this.listeners.get(i);
            l.configurationChanged(theEvent);
        }
    }

    private String formatErrorMsg(String theMethodName, Exception theException) {
        return this.formatErrorMsg(theMethodName, null, theException);
    }

    private String formatErrorMsg(String theMethodName, String theDetails, Exception theException) {
        return theException.getMessage() + " < ConfigurationManager." + theMethodName + (theDetails == null ? "" : ":" + theDetails) + " >";
    }

    public Configuration getConfig(ConfigurationID theId) {
        ConfigurationModelContainer model = this.getConfigModel(theId);
        return model.getConfiguration();
    }

    public ConfigurationModelContainer getConfigModel(ConfigurationID theId) {
        return (ConfigurationModelContainer)this.configs.get(theId);
    }

    public Collection getConfigObjects(ConfigurationID theConfigId) throws ExternalException {
        try {
            return this.getAPI().getConfigurationAndDependents(theConfigId);
        }
        catch (Exception theException) {
            theException.printStackTrace();
            throw new ExternalException(this.formatErrorMsg("getConfigObjects", "config=" + theConfigId, theException), theException);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Collection getDeployedPscs(VMComponentDefn theProcess) throws ExternalException {
        ComponentDefnID procId = (ComponentDefnID)theProcess.getID();
        Configuration config = this.getConfig(theProcess.getConfigurationID());
        ArrayList<ProductServiceConfig> result = (ArrayList<ProductServiceConfig>)this.deployedPscs.get(procId);
        if (result == null) {
            if (config != null) {
                try {
                    result = config.getPSCsForVM(theProcess);
                    ArrayList<BaseID> ids = new ArrayList<BaseID>(result.size());
                    for (ProductServiceConfig productServiceConfig : result) {
                        ids.add(productServiceConfig.getID());
                    }
                    this.deployedPscs.put(theProcess.getID(), ids);
                    if (result == null) return result;
                    Host host = this.getHost(theProcess);
                    Iterator iterator = result.iterator();
                    while (iterator.hasNext()) {
                        ProductServiceConfig psc = (ProductServiceConfig)iterator.next();
                        this.fireConfigurationChange(new ConfigurationChangeEvent(4, psc, config, new Object[]{theProcess, host, config}));
                        this.getDeployedServices(psc, theProcess);
                    }
                    return result;
                }
                catch (Exception theException) {
                    theException.printStackTrace();
                    throw new ExternalException(this.formatErrorMsg("getDeployedPscs", "process=" + theProcess, theException), theException);
                }
            }
        } else {
            ArrayList<ProductServiceConfig> r = new ArrayList<ProductServiceConfig>(result.size());
            Iterator it = result.iterator();
            while (it.hasNext()) {
                ProductServiceConfigID productServiceConfigID = (ProductServiceConfigID)it.next();
                r.add(config.getPSC((ComponentDefnID)productServiceConfigID));
            }
            return r;
        }
        LogManager.logCritical((String)"PSC-DEPLOYMENT", (String)("ConfigurationManager.getDeployedPscs:Configuration for process " + theProcess + " not found."));
        return result;
    }

    public Collection getDeployedServices(ProductServiceConfig thePsc, VMComponentDefn theProcess) throws ExternalException {
        ProductServiceConfigID pscId = (ProductServiceConfigID)thePsc.getID();
        Configuration config = this.getConfig(thePsc.getConfigurationID());
        HashMap map = (HashMap)this.deployedServices.get(pscId);
        if (map == null) {
            map = new HashMap();
        }
        ArrayList<BaseID> ids = null;
        ArrayList<DeployedComponent> result = (ArrayList<DeployedComponent>)map.get(theProcess.getID());
        if (result == null && !map.containsKey(theProcess.getID())) {
            try {
                Collection serviceComps = config.getDeployedServices(theProcess, thePsc);
                if (serviceComps != null) {
                    result = new ArrayList(serviceComps.size());
                    ids = new ArrayList<BaseID>(serviceComps.size());
                    for (DeployedComponent deployedComponent : serviceComps) {
                        result.add(deployedComponent);
                        ids.add(deployedComponent.getID());
                        this.fireConfigurationChange(new ConfigurationChangeEvent(4, deployedComponent, config, new Object[]{thePsc, theProcess, this.getHost(theProcess), config}));
                    }
                }
                if (map == null) {
                    map = new HashMap();
                }
                map.put(theProcess.getID(), ids);
                this.deployedServices.put(pscId, map);
            }
            catch (Exception theException) {
                theException.printStackTrace();
                throw new ExternalException(this.formatErrorMsg("getDeployedServices", "PSC=" + thePsc + ", process=" + theProcess + ", config=" + config, theException), theException);
            }
        } else {
            ArrayList<DeployedComponent> r = new ArrayList<DeployedComponent>(result.size());
            for (DeployedComponentID deployedComponentID : result) {
                r.add(config.getDeployedComponent(deployedComponentID));
            }
            result = r;
        }
        return result;
    }

    public ConfigurationObjectEditor getEditor() throws ExternalException {
        try {
            if (this.configEditor == null) {
                this.configEditor = this.getAPI().createEditor();
            }
            this.configEditor.getDestination().clear();
            return this.configEditor;
        }
        catch (Exception theException) {
            theException.printStackTrace();
            throw new ExternalException(this.formatErrorMsg("getEditor", theException), theException);
        }
    }

    public Collection getHosts(ConfigurationID configID) {
        ConfigurationModelContainer config = this.getConfigModel(configID);
        return config.getHosts();
    }

    public Host getHost(String hostFullName, ConfigurationID configID) {
        ConfigurationModelContainer config = this.getConfigModel(configID);
        return config.getHost(hostFullName);
    }

    public Host getHost(VMComponentDefn theProcess) {
        Configuration config = this.getConfig(theProcess.getConfigurationID());
        Host host = null;
        HostID hostId = theProcess.getHostID();
        host = config.getHost(hostId.getFullName());
        if (host == null) {
            throw new IllegalStateException("Host <" + hostId + "> not found containing process " + theProcess + " in configuration " + config.getFullName());
        }
        return host;
    }

    public Collection getHostProcesses(Host theHost, ConfigurationID theConfigId) throws ExternalException {
        try {
            List<VMComponentDefn> result = null;
            ArrayList<BaseID> ids = null;
            Configuration config = this.getConfig(theConfigId);
            if (config == null) {
                LogManager.logCritical((String)"PSC-DEPLOYMENT", (String)("ConfigurationManager.getHostProcesses:Configuration " + config + " not found."));
            } else {
                HashMap map = (HashMap)this.hostDeployments.get(theHost.getID());
                if (map == null) {
                    map = new HashMap();
                    this.hostDeployments.put(theHost.getID(), map);
                }
                if (map.containsKey(theConfigId)) {
                    ids = (ArrayList<BaseID>)map.get(theConfigId);
                    result = new ArrayList(ids.size());
                    for (VMComponentDefnID vMComponentDefnID : ids) {
                        result.add(config.getVMComponentDefn((ComponentDefnID)vMComponentDefnID));
                    }
                } else {
                    Collection hostProcesses = null;
                    hostProcesses = config.getVMsForHost(theHost.getName());
                    if (hostProcesses == null) {
                        map.put(theConfigId, null);
                        result = Collections.EMPTY_LIST;
                    } else {
                        result = new ArrayList(hostProcesses.size());
                        ids = new ArrayList<BaseID>(hostProcesses.size());
                        Iterator iterator = hostProcesses.iterator();
                        if (iterator.hasNext()) {
                            while (iterator.hasNext()) {
                                VMComponentDefn process = (VMComponentDefn)iterator.next();
                                result.add(process);
                                ids.add(process.getID());
                                this.fireConfigurationChange(new ConfigurationChangeEvent(4, process, config, new Object[]{theHost, config}));
                                this.getDeployedPscs(process);
                            }
                            map.put(theConfigId, ids);
                        }
                    }
                }
            }
            return result;
        }
        catch (Exception theException) {
            theException.printStackTrace();
            throw new ExternalException(this.formatErrorMsg("getHostProcesses", "host=" + theHost + ", config=" + theConfigId, theException), theException);
        }
    }

    public ProductType getProduct(ProductTypeID theId) {
        return this.getConfigModel(Configuration.NEXT_STARTUP_ID).getProductType(theId.getFullName());
    }

    public ProductType getProduct(ProductServiceConfig thePsc) {
        ProductTypeID prodId = (ProductTypeID)thePsc.getComponentTypeID();
        return this.getProduct(prodId);
    }

    public Map getAllProductPscs(ConfigurationID theConfigId) throws ExternalException {
        HashMap map = new HashMap();
        Collection prods = this.getProducts();
        if (prods != null) {
            Configuration config = this.getConfig(theConfigId);
            Iterator prodItr = prods.iterator();
            while (prodItr.hasNext()) {
                ArrayList pscs = new ArrayList();
                ProductType prod = (ProductType)prodItr.next();
                Collection temp = this.getPscDefinitions(prod, config);
                if (temp != null) {
                    pscs.addAll(temp);
                }
                map.put(prod, pscs);
            }
        }
        return map;
    }

    public Collection getProducts() {
        return this.getConfigModel(Configuration.NEXT_STARTUP_ID).getProductTypes();
    }

    public ConfigurationPropertiedObjectEditor getPropertiedObjectEditor() throws ExternalException {
        try {
            ConfigurationObjectEditor editor = this.getAPI().createEditor();
            ModificationActionQueue queue = editor.getDestination();
            ConfigurationPropertiedObjectEditor propEditor = new ConfigurationPropertiedObjectEditor(this.getConnection(), queue);
            return propEditor;
        }
        catch (Exception theException) {
            theException.printStackTrace();
            throw new ExternalException(this.formatErrorMsg("getPropertiedObjectEditor", theException), theException);
        }
    }

    public PropertiedObject getPropertiedObjectForComponentObject(ComponentObject componentObject) {
        if (componentObject == null) {
            Assertion.isNotNull((Object)componentObject, (String)AdminPlugin.Util.getString("ERR.014.001.0018", new Object[]{"ComponentObject"}));
        }
        if (!(componentObject instanceof PropertiedObject)) {
            Assertion.assertTrue((boolean)(componentObject instanceof PropertiedObject), (String)AdminPlugin.Util.getString("ERR.014.001.0019"));
        }
        return (PropertiedObject)componentObject;
    }

    public ResourceDescriptor updateResourcePropertyValue(ResourceDescriptor resourceDescriptor, String propertyKey, String propertyValue) throws ConfigurationException, InvalidSessionException, AuthorizationException, MetaMatrixComponentException {
        BasicConfigurationObjectEditor editor = new BasicConfigurationObjectEditor(false);
        ResourceDescriptor updatedRD = (ResourceDescriptor)editor.setProperty((ComponentObject)resourceDescriptor, propertyKey, propertyValue);
        return updatedRD;
    }

    private Collection getPscs(ServiceComponentDefn theService, Configuration theConfig) {
        Iterator itr = this.serviceDefnMap.keySet().iterator();
        ProductServiceConfigID pscId = null;
        ArrayList<ProductServiceConfig> result = new ArrayList<ProductServiceConfig>(20);
        while (itr.hasNext()) {
            ProductServiceConfig psConfig;
            Object key = itr.next();
            Collection serviceIDs = (Collection)this.serviceDefnMap.get(key);
            if (!serviceIDs.contains(theService.getID()) || (psConfig = theConfig.getPSC((ComponentDefnID)(pscId = (ProductServiceConfigID)key))) == null) continue;
            result.add(psConfig);
        }
        return result;
    }

    public Collection getPscDefinitions(ProductType theProduct, Configuration theConfiguration) throws ExternalException {
        ArrayList<ProductServiceConfig> result = null;
        ArrayList<ProductServiceConfigID> ids = null;
        ConfigurationID configId = (ConfigurationID)theConfiguration.getID();
        ProductTypeID prodId = (ProductTypeID)theProduct.getID();
        HashMap map = (HashMap)this.prodPscDefs.get(prodId);
        if (map == null && !this.prodPscDefs.containsKey(prodId)) {
            map = new HashMap();
            this.prodPscDefs.put(prodId, map);
        }
        if (map.containsKey(configId)) {
            ids = (ArrayList<ProductServiceConfigID>)map.get(configId);
            result = new ArrayList<ProductServiceConfig>(ids.size());
            for (ProductServiceConfigID pscID : ids) {
                result.add(theConfiguration.getPSC((ComponentDefnID)pscID));
            }
        } else {
            Collection pscIds = theConfiguration.getComponentDefnIDs((ComponentTypeID)prodId);
            if (pscIds != null) {
                result = new ArrayList(pscIds.size());
                ids = new ArrayList<ProductServiceConfigID>(pscIds.size());
                for (ProductServiceConfigID pscId : pscIds) {
                    ProductServiceConfig psc = theConfiguration.getPSC((ComponentDefnID)pscId);
                    result.add(psc);
                    ids.add(pscId);
                    this.fireConfigurationChange(new ConfigurationChangeEvent(4, psc, theConfiguration, new Object[]{theProduct, theConfiguration}));
                    this.getServiceDefinitions(psc, theConfiguration);
                }
                map.put(configId, ids);
            }
        }
        return result;
    }

    public Collection getServiceDefinitions(ProductServiceConfig thePsc, Configuration theConfiguration) throws ExternalException {
        ProductType product = this.getProduct(thePsc);
        ArrayList<ServiceComponentDefn> services = null;
        ProductServiceConfigID pscId = (ProductServiceConfigID)thePsc.getID();
        ArrayList<ServiceComponentDefnID> svcIDs = null;
        if (this.serviceDefnMap.containsKey(theConfiguration.getID())) {
            svcIDs = (ArrayList<ServiceComponentDefnID>)this.serviceDefnMap.get(theConfiguration.getID());
            services = new ArrayList(svcIDs.size());
            for (ServiceComponentDefnID id : svcIDs) {
                ServiceComponentDefn service = (ServiceComponentDefn)theConfiguration.getComponentDefn((ComponentDefnID)id);
                services.add(service);
            }
        } else {
            Collection sdfnIds = thePsc.getServiceComponentDefnIDs();
            if (sdfnIds != null) {
                services = new ArrayList<ServiceComponentDefn>(sdfnIds.size());
                svcIDs = new ArrayList<ServiceComponentDefnID>(sdfnIds.size());
                for (ServiceComponentDefnID id : sdfnIds) {
                    ServiceComponentDefn service = (ServiceComponentDefn)theConfiguration.getComponentDefn((ComponentDefnID)id);
                    services.add(service);
                    svcIDs.add(id);
                    this.fireConfigurationChange(new ConfigurationChangeEvent(4, service, theConfiguration, new Object[]{thePsc, product, theConfiguration}));
                }
            }
            this.serviceDefnMap.put(pscId, svcIDs);
        }
        return services;
    }

    public Collection importObjects(String theFileName) throws ExternalException {
        try {
            FileInputStream xmlStream = new FileInputStream(theFileName);
            XMLConfigurationImportExportUtility xmlUtil = new XMLConfigurationImportExportUtility();
            Collection configObjs = xmlUtil.importConfigurationObjects((InputStream)xmlStream, this.getAPI().createEditor(), "Next Startup");
            return configObjs;
        }
        catch (Exception theException) {
            theException.printStackTrace();
            throw new ExternalException(this.formatErrorMsg("importObjects", "file name=" + theFileName, theException), theException);
        }
    }

    private boolean isDeployed(Host theHost, ConfigurationID theConfigId) {
        ConfigurationModelContainer model = this.getConfigModel(theConfigId);
        return model.getConfiguration().getHost(theHost.getFullName()) != null;
    }

    public boolean isEditable(ConfigurationID theId) {
        return this.isNextStartUpConfig(theId);
    }

    public boolean isNextStartUpConfig(ConfigurationID theId) {
        return this.nextStartUpId.equals((Object)theId);
    }

    public boolean isRefreshNeeded() {
        return this.refreshNeeded;
    }

    public boolean isStartUpConfig(ConfigurationID theId) {
        if (theId == null) {
            return false;
        }
        return this.startUpId.equals((Object)theId);
    }

    private Object modify(ComponentObject theObject, Properties theProperties) throws Exception {
        ConfigurationObjectEditor editor = null;
        try {
            editor = this.getEditor();
            ComponentObject obj = editor.modifyProperties(theObject, theProperties, 0);
            this.getAPI().executeTransaction(editor.getDestination().popActions());
            return obj;
        }
        catch (Exception theException) {
            if (editor != null) {
                editor.getDestination().popActions();
            }
            throw theException;
        }
    }

    public Host modifyHost(Host theHost, Properties theProperties) throws ExternalException {
        try {
            Host host = (Host)this.modify((ComponentObject)theHost, theProperties);
            for (ConfigurationModelContainer config : this.configs.values()) {
                if (!this.isDeployed(theHost, config.getConfigurationID())) continue;
                this.fireConfigurationChange(new ConfigurationChangeEvent(2, host, config.getConfiguration(), new Object[]{config.getConfiguration()}));
            }
            return host;
        }
        catch (Exception theException) {
            theException.printStackTrace();
            throw new ExternalException(this.formatErrorMsg("modifyHost", "host=" + theHost, theException), theException);
        }
    }

    public VMComponentDefn modifyProcess(VMComponentDefn theProcess, Properties theProperties) throws ExternalException {
        try {
            VMComponentDefn process = (VMComponentDefn)this.modify((ComponentObject)theProcess, theProperties);
            Configuration config = this.getConfig(theProcess.getConfigurationID());
            Host host = this.getHost(process);
            this.fireConfigurationChange(new ConfigurationChangeEvent(2, process, config, new Object[]{host, config}));
            return process;
        }
        catch (Exception theException) {
            theException.printStackTrace();
            throw new ExternalException(this.formatErrorMsg("modifyProcess", "process=" + theProcess, theException), theException);
        }
    }

    public void modifyPropertiedObject(ConfigurationPropertiedObjectEditor editor) throws ExternalException {
        try {
            ModificationActionQueue queue = editor.getQueue();
            this.getAPI().executeTransaction(queue.popActions());
        }
        catch (Exception theException) {
            theException.printStackTrace();
            throw new ExternalException(this.formatErrorMsg("modifyPropertiedObject", theException), theException);
        }
    }

    public ProductServiceConfig modifyPsc(ProductServiceConfig thePscDef, Properties theProperties) throws ExternalException {
        try {
            ProductServiceConfig pscDef = (ProductServiceConfig)this.modify((ComponentObject)thePscDef, theProperties);
            Configuration config = this.getConfig(pscDef.getConfigurationID());
            ProductType product = this.getProduct(thePscDef);
            this.fireConfigurationChange(new ConfigurationChangeEvent(2, pscDef, config, new Object[]{product, config}));
            return pscDef;
        }
        catch (Exception theException) {
            theException.printStackTrace();
            throw new ExternalException(this.formatErrorMsg("modifyPsc", "PSC=" + thePscDef, theException), theException);
        }
    }

    public ServiceComponentDefn modifyService(ServiceComponentDefn theService, Properties theProperties) throws ExternalException {
        try {
            ServiceComponentDefn service = (ServiceComponentDefn)this.modify((ComponentObject)theService, theProperties);
            Configuration config = this.getConfig(service.getConfigurationID());
            Collection pscs = this.getPscs(service, config);
            for (ProductServiceConfig psc : pscs) {
                ProductType product = this.getProduct(psc);
                this.fireConfigurationChange(new ConfigurationChangeEvent(2, service, config, new Object[]{psc, product, config}));
            }
            return service;
        }
        catch (Exception theException) {
            theException.printStackTrace();
            throw new ExternalException(this.formatErrorMsg("modifyService", "service=" + theService, theException), theException);
        }
    }

    private void addConfig(ConfigurationModelContainer theConfig) {
        this.configs.put(theConfig.getConfigurationID(), theConfig);
        this.fireConfigurationChange(new ConfigurationChangeEvent(4, theConfig.getConfiguration(), theConfig.getConfiguration(), null));
        for (ProductType product : this.getProducts()) {
            this.fireConfigurationChange(new ConfigurationChangeEvent(4, product, theConfig.getConfiguration(), new Object[]{theConfig.getConfiguration()}));
        }
    }

    @Override
    public void refresh() {
        super.refresh();
        this.setRefreshNeeded();
        try {
            this.refreshImpl();
        }
        catch (ExternalException e) {
            LogManager.logCritical((String)"CONFIGURATION", (String)"ConfigurationManager.refreshConfigs:Error refreshing configuration.");
        }
    }

    private void refreshConfigs() throws ExternalException {
        this.fireConfigurationChange(new ConfigurationChangeEvent(8, this));
        this.configs.clear();
        try {
            ConfigurationModelContainer nextStartUp = this.getAPI().getConfigurationModel("Next Startup");
            if (nextStartUp == null) {
                LogManager.logCritical((String)"CONFIGURATION", (String)"ConfigurationManager.refreshConfigs:Next Startup Configuration is null.");
            } else {
                this.addConfig(nextStartUp);
            }
            ConfigurationModelContainer startup = this.getAPI().getConfigurationModel("Startup");
            if (startup == null) {
                LogManager.logCritical((String)"CONFIGURATION", (String)"ConfigurationManager.refreshConfigs:Startup Configuration is null.");
            } else {
                this.addConfig(startup);
            }
            this.fireConfigurationChange(new ConfigurationChangeEvent(16, this));
            this.refreshNeeded = false;
        }
        catch (Exception theException) {
            theException.printStackTrace();
            throw new ExternalException(this.formatErrorMsg("refreshConfigs", theException), theException);
        }
    }

    private void refreshDeployedHosts() throws ExternalException {
        this.hostDeployments.clear();
        this.deployedPscs.clear();
        this.deployedServices.clear();
        for (ConfigurationModelContainer config : this.configs.values()) {
            for (Host host : config.getHosts()) {
                this.getHostProcesses(host, config.getConfigurationID());
            }
        }
    }

    private void refreshHosts() throws ExternalException {
        try {
            Collection hostCollection = this.getConfigModel(Configuration.NEXT_STARTUP_ID).getHosts();
            if (hostCollection == null || hostCollection.isEmpty()) {
                LogManager.logCritical((String)"CONFIGURATION", (String)"ConfigurationManager.refreshHosts:No hosts found or is null.");
            } else {
                for (Host host : hostCollection) {
                    LogManager.logDetail((String)"CONFIGURATION", (Object[])new Object[]{"ConfigurationManager.refreshHosts:Adding Host:" + host});
                    this.notifyHostChangeToConfigs(host, 4);
                }
            }
        }
        catch (Exception theException) {
            theException.printStackTrace();
            throw new ExternalException(this.formatErrorMsg("refreshHosts", theException), theException);
        }
    }

    public void refreshImpl() throws ExternalException {
        this.fireConfigurationChange(new ConfigurationChangeEvent(8, this));
        this.refreshConfigs();
        this.refreshHosts();
        this.refreshDeployedHosts();
        this.refreshPscDefinitions();
        this.fireConfigurationChange(new ConfigurationChangeEvent(16, this));
        this.refreshNeeded = false;
    }

    private void refreshPscDefinitions() throws ExternalException {
        this.prodPscDefs.clear();
        this.serviceDefnMap.clear();
        for (ConfigurationModelContainer config : this.configs.values()) {
            for (ProductType product : this.getProducts()) {
                this.getPscDefinitions(product, config.getConfiguration());
            }
        }
    }

    public void removeConfigurationChangeListener(ConfigurationChangeListener theListener) {
        this.listeners.remove(theListener);
    }

    public void setEnabled(ServiceComponentDefn theService, ProductServiceConfig psc, boolean theEnableFlag, Configuration theConfig) throws ExternalException {
        ConfigurationObjectEditor editor = null;
        try {
            editor = this.getEditor();
            Collection deletedServComps = editor.setEnabled(theConfig, theService, psc, theEnableFlag, true);
            this.getAPI().executeTransaction(editor.getDestination().popActions());
            if (!deletedServComps.isEmpty()) {
                for (DeployedComponent dc : deletedServComps) {
                    ProductServiceConfigID pscId = dc.getProductServiceConfigID();
                    VMComponentDefnID vmId = dc.getVMComponentDefnID();
                    Map map = (Map)this.deployedServices.get(pscId);
                    ArrayList<BaseID> services = (ArrayList<BaseID>)map.get(vmId);
                    if (theEnableFlag) {
                        if (services == null) {
                            services = new ArrayList<BaseID>();
                        }
                        services.add(dc.getID());
                        continue;
                    }
                    services.remove(dc.getID());
                }
            }
        }
        catch (Exception theException) {
            if (editor != null) {
                editor.getDestination().popActions();
            }
            theException.printStackTrace();
            throw new ExternalException(this.formatErrorMsg("setEnabled", "service=" + theService + ", enable=" + theEnableFlag + ", config=" + theConfig, theException), theException);
        }
    }

    private ConfigurationAdminAPI getAPI() {
        return ModelManager.getConfigurationAPI(this.getConnection());
    }

    public void setRefreshNeeded() {
        this.refreshNeeded = true;
    }

    public ArrayList getListeners() {
        return this.listeners;
    }

    public boolean checkDecryptable(List bindings) throws ConfigurationException, AuthorizationException, InvalidSessionException, MetaMatrixComponentException {
        List results = this.getAPI().checkPropertiesDecryptable(bindings);
        if (!results.contains(new Boolean(false))) {
            return true;
        }
        String header = "Warning: Unable to decrypt connector binding passwords";
        StringBuffer messageBuffer = new StringBuffer();
        messageBuffer.append("Warning: The following connector bindings were added, but the passwords could not be decrypted: \n");
        Iterator iter = bindings.iterator();
        Iterator iter2 = results.iterator();
        while (iter.hasNext() && iter2.hasNext()) {
            ConnectorBinding binding = (ConnectorBinding)iter.next();
            boolean decryptable = (Boolean)iter2.next();
            if (decryptable) continue;
            messageBuffer.append("  ");
            messageBuffer.append(binding.getName());
            messageBuffer.append("\n");
        }
        messageBuffer.append("\n\nSynchronization was not performed.");
        messageBuffer.append("\nThese bindings may have been exported from a system with a different keystore.");
        messageBuffer.append("\nYou must manually re-enter the passwords via the Properties tab, or convert the file with the 'convertpasswords' utility and re-import.");
        StaticUtilities.displayModalDialogWithOK(header, messageBuffer.toString());
        return false;
    }

    public Collection getAllCachedComponentTypeDefinitions(ComponentTypeID componentTypeID) throws ConfigurationException, InvalidSessionException, AuthorizationException, MetaMatrixComponentException {
        Collection result = null;
        result = (Collection)this.typeIDtoAllTypeDefns.get(componentTypeID);
        if (result == null) {
            result = this.getAPI().getAllComponentTypeDefinitions(componentTypeID);
        }
        return result;
    }

    public ComponentTypeDefn getComponentTypeDefn(PropertyDefinition propertyDefinition, ComponentObject componentObject) throws ConfigurationException, InvalidSessionException, AuthorizationException, MetaMatrixComponentException {
        Collection typedefns = this.getAllCachedComponentTypeDefinitions(componentObject.getComponentTypeID());
        Iterator iter = typedefns.iterator();
        ComponentTypeDefn result = null;
        ComponentTypeDefn typeDefn = null;
        while (iter.hasNext()) {
            typeDefn = (ComponentTypeDefn)iter.next();
            if (!typeDefn.getPropertyDefinition().getName().equals(propertyDefinition.getName())) continue;
            result = typeDefn;
            break;
        }
        return result;
    }
}

