/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.models;

import com.metamatrix.admin.AdminPlugin;
import com.metamatrix.admin.api.exception.security.InvalidSessionException;
import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.security.AuthorizationException;
import com.metamatrix.common.actions.ModificationActionQueue;
import com.metamatrix.common.actions.ModificationException;
import com.metamatrix.common.config.api.ComponentDefn;
import com.metamatrix.common.config.api.ComponentObject;
import com.metamatrix.common.config.api.ComponentTypeDefn;
import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ConfigurationID;
import com.metamatrix.common.config.api.ConfigurationObjectEditor;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.config.api.DeployedComponent;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.common.config.model.BasicConfigurationObjectEditor;
import com.metamatrix.common.config.model.PropertyValidations;
import com.metamatrix.common.object.ConfigurationPropertyObjDisplayComparator;
import com.metamatrix.common.object.PropertiedObject;
import com.metamatrix.common.object.PropertiedObjectEditor;
import com.metamatrix.common.object.PropertyAccessPolicy;
import com.metamatrix.common.object.PropertyAccessPolicyImpl;
import com.metamatrix.common.object.PropertyDefinition;
import com.metamatrix.common.object.PropertyDefinitionImpl;
import com.metamatrix.common.object.PropertyType;
import com.metamatrix.common.transaction.TransactionException;
import com.metamatrix.common.transaction.TransactionNotSupportedException;
import com.metamatrix.common.transaction.UserTransaction;
import com.metamatrix.common.transaction.manager.SimpleUserTransaction;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.ConfigurationManager;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.platform.admin.api.ConfigurationAdminAPI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ConfigurationPropertiedObjectEditor
implements PropertiedObjectEditor,
StringUtil.Constants,
UserTransaction {
    private ConnectionInfo connectionInfo;
    private ConfigurationObjectEditor editor;
    private ModificationActionQueue queue;
    private PropertyAccessPolicy policy;
    private Object source;
    private boolean automaticTransaction = false;
    private ConfigurationPropertyObjDisplayComparator comp = new ConfigurationPropertyObjDisplayComparator();
    private PropertyValidations validations = new PropertyValidations();

    ConfigurationPropertiedObjectEditor(ConnectionInfo connectionInfo) {
        this.connectionInfo = connectionInfo;
        this.policy = new PropertyAccessPolicyImpl();
        this.automaticTransaction = true;
    }

    ConfigurationPropertiedObjectEditor(ConnectionInfo connectionInfo, ModificationActionQueue queue) {
        this.connectionInfo = connectionInfo;
        this.policy = new PropertyAccessPolicyImpl();
        this.editor = new BasicConfigurationObjectEditor(true);
        this.editor.setDestination(queue);
        this.queue = queue;
        this.automaticTransaction = false;
    }

    ModificationActionQueue getQueue() {
        return this.queue;
    }

    public List getPropertyDefinitions(PropertiedObject obj) {
        ComponentObject componentObject = this.assertComponentObject(obj);
        Collection result = null;
        try {
            result = this.getConfigurationManager().getAllCachedComponentTypeDefinitions(componentObject.getComponentTypeID());
        }
        catch (ConfigurationException e) {
            throw new MetaMatrixRuntimeException((Throwable)e, "ERR.014.001.0022", AdminPlugin.Util.getString("ERR.014.001.0022"));
        }
        catch (InvalidSessionException e) {
            throw new MetaMatrixRuntimeException((Throwable)e, "ERR.014.001.0023", AdminPlugin.Util.getString("ERR.014.001.0023"));
        }
        catch (AuthorizationException e) {
            throw new MetaMatrixRuntimeException((Throwable)e, "ERR.014.001.0024", AdminPlugin.Util.getString("ERR.014.001.0024"));
        }
        catch (MetaMatrixComponentException e) {
            throw new MetaMatrixRuntimeException((Throwable)e, "ERR.014.001.0025", AdminPlugin.Util.getString("ERR.014.001.0025"));
        }
        if (result != null) {
            List r = null;
            if (componentObject instanceof ConnectorBinding) {
                r = this.setIsModifiable(result, Configuration.NEXT_STARTUP_ID);
            } else if (componentObject instanceof ComponentDefn) {
                r = this.setIsModifiable(result, ((ComponentDefn)componentObject).getConfigurationID());
            } else if (componentObject instanceof Configuration) {
                r = this.setIsModifiable(result, (ConfigurationID)((Configuration)componentObject).getID());
            } else if (componentObject instanceof DeployedComponent) {
                r = this.setIsModifiable(result, ((DeployedComponent)componentObject).getConfigurationID());
            }
            Collections.sort(r, this.comp);
            return r;
        }
        return new ArrayList(result);
    }

    public List getAllowedValues(PropertiedObject obj, PropertyDefinition def) {
        if (def == null) {
            Assertion.isNotNull((Object)def, (String)AdminPlugin.Util.getString("ERR.014.001.0018", new Object[]{"PropertyDefinition"}));
        }
        return def.getAllowedValues();
    }

    public boolean isReadOnly(PropertiedObject obj) {
        if (obj == null) {
            Assertion.isNotNull((Object)obj, (String)AdminPlugin.Util.getString("ERR.014.001.0018", new Object[]{"PropertiedObject"}));
        }
        return this.policy.isReadOnly(obj);
    }

    public Object getValue(PropertiedObject obj, PropertyDefinition def) {
        ComponentObject componentObject = this.assertComponentObject(obj);
        if (def == null) {
            Assertion.isNotNull((Object)def, (String)AdminPlugin.Util.getString("ERR.014.001.0018", new Object[]{"PropertyDefinition"}));
        }
        String value = componentObject.getProperties().getProperty(def.getName());
        Object result = value;
        if (PropertyType.BOOLEAN.equals((Object)def.getPropertyType()) && value instanceof String) {
            result = Boolean.TRUE.toString().equalsIgnoreCase(value) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (def.getDefaultValue() != null && def.getDefaultValue().equals(result)) {
            return null;
        }
        return result;
    }

    public boolean isValidValue(PropertiedObject obj, PropertyDefinition def, Object value) {
        this.assertComponentObject(obj);
        if (def == null) {
            Assertion.isNotNull((Object)def, (String)AdminPlugin.Util.getString("ERR.014.001.0018", new Object[]{"PropertyDefinition"}));
        }
        if (value == null) {
            return def.getMultiplicity().getMinimum() == 0;
        }
        boolean isValid = false;
        isValid = def.getPropertyType().isValidValue(value);
        if (isValid && value instanceof String) {
            try {
                this.validations.isPropertyValid(def.getName(), (String)value);
            }
            catch (Exception e) {
                return false;
            }
            String stringValue = (String)value;
            isValid = stringValue.lastIndexOf(CARRIAGE_RETURN) == -1;
            isValid = stringValue.lastIndexOf(NEW_LINE) == -1;
        }
        return isValid;
    }

    public void setValue(PropertiedObject obj, PropertyDefinition def, Object value) {
        ComponentObject componentObject = this.assertComponentObject(obj);
        if (def == null) {
            Assertion.isNotNull((Object)def, (String)AdminPlugin.Util.getString("ERR.014.001.0018", new Object[]{"PropertyDefinition"}));
        }
        try {
            ComponentTypeDefn typeDefn = this.getConfigurationManager().getComponentTypeDefn(def, componentObject);
            if (!typeDefn.getComponentTypeID().equals((Object)componentObject.getComponentTypeID())) {
                this.getEditor().createComponentTypeDefn(componentObject.getComponentTypeID(), def, typeDefn.isEffectiveImmediately());
            }
            if (value == null) {
                if (def.getDefaultValue() == null) {
                    this.getEditor().removeProperty(componentObject, def.getName());
                } else {
                    this.getEditor().setProperty(componentObject, def.getName(), def.getDefaultValue().toString());
                }
            } else {
                String stringValue = null;
                if (value instanceof Boolean) {
                    Boolean bValue = (Boolean)value;
                    stringValue = Boolean.toString(bValue);
                    stringValue = stringValue.toLowerCase();
                } else {
                    stringValue = (String)value;
                }
                this.getEditor().setProperty(componentObject, def.getName(), stringValue);
            }
        }
        catch (ConfigurationException e) {
            throw new MetaMatrixRuntimeException((Throwable)e, "ERR.014.001.0026", AdminPlugin.Util.getString("ERR.014.001.0026"));
        }
        catch (InvalidSessionException e) {
            throw new MetaMatrixRuntimeException((Throwable)e, "ERR.014.001.0023", AdminPlugin.Util.getString("ERR.014.001.0023"));
        }
        catch (AuthorizationException e) {
            throw new MetaMatrixRuntimeException((Throwable)e, "ERR.014.001.0027", AdminPlugin.Util.getString("ERR.014.001.0027"));
        }
        catch (MetaMatrixComponentException e) {
            throw new MetaMatrixRuntimeException((Throwable)e, "ERR.014.001.0028", AdminPlugin.Util.getString("ERR.014.001.0028"));
        }
        catch (ClassCastException e) {
            throw new MetaMatrixRuntimeException((Throwable)e, "ERR.014.001.0029", AdminPlugin.Util.getString("ERR.014.001.0029"));
        }
    }

    public PropertyAccessPolicy getPolicy() {
        return this.policy;
    }

    public void setPolicy(PropertyAccessPolicy policy) {
        this.policy = policy;
    }

    public boolean isReadOnly(PropertiedObject obj, PropertyDefinition def) {
        if (obj == null) {
            Assertion.isNotNull((Object)obj, (String)AdminPlugin.Util.getString("ERR.014.001.0018", new Object[]{"PropertiedObject"}));
        }
        if (def == null) {
            Assertion.isNotNull((Object)def, (String)AdminPlugin.Util.getString("ERR.014.001.0018", new Object[]{"PropertyDefinition"}));
        }
        return this.policy.isReadOnly(obj, def);
    }

    public void setReadOnly(PropertiedObject obj, PropertyDefinition def, boolean readOnly) {
        if (obj == null) {
            Assertion.isNotNull((Object)obj, (String)AdminPlugin.Util.getString("ERR.014.001.0018", new Object[]{"PropertiedObject"}));
        }
        if (def == null) {
            Assertion.isNotNull((Object)def, (String)AdminPlugin.Util.getString("ERR.014.001.0018", new Object[]{"PropertyDefinition"}));
        }
        this.policy.setReadOnly(obj, def, readOnly);
    }

    public void setReadOnly(PropertiedObject obj, boolean readOnly) {
        if (obj == null) {
            Assertion.isNotNull((Object)obj, (String)AdminPlugin.Util.getString("ERR.014.001.0018", new Object[]{"PropertiedObject"}));
        }
        this.policy.setReadOnly(obj, readOnly);
    }

    public void reset(PropertiedObject obj) {
        this.assertComponentObject(obj);
        this.policy.reset(obj);
    }

    public UserTransaction createReadTransaction() {
        return new SimpleUserTransaction();
    }

    public UserTransaction createWriteTransaction() {
        return this;
    }

    public UserTransaction createWriteTransaction(Object source) {
        this.source = source;
        return this;
    }

    public int getStatus() throws TransactionException {
        if (this.automaticTransaction) {
            return 5;
        }
        return 6;
    }

    public void begin() throws TransactionException {
        if (this.automaticTransaction && this.queue != null && this.queue.hasActions()) {
            throw new TransactionNotSupportedException("ERR.014.001.0030", AdminPlugin.Util.getString("ERR.014.001.0030"));
        }
    }

    public void setTransactionTimeout(int seconds) throws TransactionException {
    }

    public void setRollbackOnly() throws TransactionException {
    }

    public void commit() throws TransactionException {
        if (this.automaticTransaction && this.queue != null) {
            try {
                this.getConfigurationAPI().executeTransaction(this.queue.popActions());
            }
            catch (ModificationException e) {
                throw new TransactionException((Exception)((Object)e), "ERR.014.001.0031", AdminPlugin.Util.getString("ERR.014.001.0031"));
            }
            catch (ConfigurationException e) {
                throw new TransactionException((Exception)((Object)e), "ERR.014.001.0031", AdminPlugin.Util.getString("ERR.014.001.0031"));
            }
            catch (InvalidSessionException e) {
                throw new TransactionException((Exception)((Object)e), "ERR.014.001.0031", AdminPlugin.Util.getString("ERR.014.001.0031"));
            }
            catch (AuthorizationException e) {
                throw new TransactionException((Exception)((Object)e), "ERR.014.001.0031", AdminPlugin.Util.getString("ERR.014.001.0031"));
            }
            catch (MetaMatrixComponentException e) {
                throw new TransactionException((Exception)((Object)e), "ERR.014.001.0031", AdminPlugin.Util.getString("ERR.014.001.0031"));
            }
        }
    }

    public void rollback() throws TransactionException {
        if (this.automaticTransaction && this.queue != null) {
            this.queue.clear();
        }
    }

    public Object getSource() throws TransactionException {
        return this.source;
    }

    protected boolean isAutomaticTransaction() {
        return this.automaticTransaction;
    }

    protected ComponentObject assertComponentObject(PropertiedObject obj) {
        if (obj == null) {
            Assertion.isNotNull((Object)obj, (String)AdminPlugin.Util.getString("ERR.014.001.0018", new Object[]{"PropertiedObject"}));
        }
        if (!(obj instanceof ComponentObject)) {
            Assertion.assertTrue((boolean)(obj instanceof ComponentObject), (String)AdminPlugin.Util.getString("ERR.014.001.0032"));
        }
        return (ComponentObject)obj;
    }

    protected ConfigurationObjectEditor getEditor() {
        if (this.editor == null) {
            this.editor = new BasicConfigurationObjectEditor(true);
        }
        return this.editor;
    }

    protected List setIsModifiable(Collection componentTypeDefns, ConfigurationID id) {
        ArrayList<Object> result = new ArrayList<Object>(componentTypeDefns.size());
        Iterator iterator = componentTypeDefns.iterator();
        ConfigurationID nextStartupID = Configuration.NEXT_STARTUP_ID;
        ConfigurationID startupID = Configuration.STARTUP_ID;
        while (iterator.hasNext()) {
            ComponentTypeDefn cDefn = (ComponentTypeDefn)iterator.next();
            PropertyDefinition propDefn = cDefn.getPropertyDefinition();
            if (propDefn.isModifiable()) {
                PropertyDefinitionImpl pDefn = new PropertyDefinitionImpl(propDefn);
                if (id.equals((Object)nextStartupID)) {
                    pDefn.setModifiable(true);
                } else if (id.equals((Object)startupID)) {
                    pDefn.setModifiable(false);
                } else {
                    pDefn.setModifiable(false);
                }
                result.add(pDefn);
                continue;
            }
            result.add(propDefn);
        }
        return result;
    }

    protected ConfigurationAdminAPI getConfigurationAPI() {
        return ModelManager.getConfigurationAPI(this.connectionInfo);
    }

    protected ConfigurationManager getConfigurationManager() {
        return ModelManager.getConfigurationManager(this.connectionInfo);
    }
}

