/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.models;

import com.metamatrix.common.actions.ModificationActionQueue;
import com.metamatrix.common.config.api.ComponentDefnID;
import com.metamatrix.common.config.api.ComponentObject;
import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.common.config.api.ComponentTypeDefn;
import com.metamatrix.common.config.api.ComponentTypeID;
import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ConfigurationObjectEditor;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.config.api.ConnectorBindingID;
import com.metamatrix.common.config.api.ProductServiceConfig;
import com.metamatrix.common.config.api.ProductServiceConfigID;
import com.metamatrix.common.config.api.ProductTypeID;
import com.metamatrix.common.config.api.ServiceComponentDefn;
import com.metamatrix.common.config.api.ServiceComponentDefnID;
import com.metamatrix.common.object.PropertiedObject;
import com.metamatrix.common.object.PropertiedObjectEditor;
import com.metamatrix.common.object.PropertyDefinition;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.ConfigurationManager;
import com.metamatrix.console.models.ConfigurationPropertiedObjectEditor;
import com.metamatrix.console.models.Manager;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.console.ui.views.connector.ConnectorBasicInfo;
import com.metamatrix.console.ui.views.connector.ConnectorDetailInfo;
import com.metamatrix.console.ui.views.connectorbinding.BindingBasics;
import com.metamatrix.console.ui.views.connectorbinding.BindingDataInterface;
import com.metamatrix.console.ui.views.connectorbinding.ConnectorAndBinding;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.platform.admin.api.ConfigurationAdminAPI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class ConnectorManager
extends Manager
implements BindingDataInterface {
    private ArrayList arylConnectors = null;
    private ArrayList arylConnectorBindings = null;
    private HashMap hmConnectorNameMap = null;
    private HashMap hmUUIDConnectorBindingsMap = null;

    public ConnectorManager(ConnectionInfo connection) {
        super(connection);
    }

    public ConfigurationAdminAPI getConfigurationAdminAPI() {
        return ModelManager.getConfigurationAPI(this.getConnection());
    }

    public ConnectorBasicInfo[] getConnectorBasics(boolean forceRefresh) throws Exception {
        ConnectorBasicInfo[] aryConnectorBasicInfo = null;
        try {
            this.getConnectors(forceRefresh);
            aryConnectorBasicInfo = new ConnectorBasicInfo[this.arylConnectors.size()];
        }
        catch (Exception e) {
            ExceptionUtility.showMessage("Failed trying to retrieve Connectors", e);
            return null;
        }
        ComponentType ctypeTemp2 = null;
        int iCounter = 0;
        for (ComponentType ctypeTemp2 : this.arylConnectors) {
            if (!ctypeTemp2.isDeployable()) continue;
            aryConnectorBasicInfo[iCounter] = this.getConnectorBasicInfo(ctypeTemp2);
            ++iCounter;
        }
        return aryConnectorBasicInfo;
    }

    public ConnectorDetailInfo getDetailForConnector(ComponentType ctConnector) throws Exception {
        String sName = ctConnector.getName();
        String sConnClass = "";
        String sChangedBy = ctConnector.getLastChangedBy();
        Date dChangedDate = ctConnector.getLastChangedDate();
        String sCreatedBy = ctConnector.getCreatedBy();
        Date dCreatedDate = ctConnector.getCreatedDate();
        String desc = ctConnector.getDescription() == null ? "" : ctConnector.getDescription();
        ConnectorDetailInfo cdiInfo = new ConnectorDetailInfo(sName, desc, sConnClass, dCreatedDate, sCreatedBy, dChangedDate, sChangedBy);
        return cdiInfo;
    }

    public void deleteConnector(String name) throws Exception {
        this.deleteConnector((ComponentType)this.hmConnectorNameMap.get(name));
    }

    public void deleteConnector(ComponentType ctConnector) throws Exception {
        String connectorName = ctConnector.getName();
        this.hmConnectorNameMap.remove(connectorName);
        this.arylConnectors.remove(ctConnector);
        ConfigurationObjectEditor coeEditorForDelete = this.getConnectorEditor();
        coeEditorForDelete.delete(ctConnector);
        List lstActions = null;
        try {
            lstActions = coeEditorForDelete.getDestination().getActions();
        }
        catch (Exception e) {
            ExceptionUtility.showMessage("Failed to get actions from the editor", e);
        }
        try {
            this.getConfigurationAdminAPI().executeTransaction(lstActions);
        }
        catch (Exception e) {
            ExceptionUtility.showMessage("Failed trying to delete the connector", e);
        }
    }

    private ConfigurationObjectEditor getConnectorEditor() throws Exception {
        ConfigurationObjectEditor newComponentEditor = this.getConfigurationAdminAPI().createEditor();
        return newComponentEditor;
    }

    @Override
    public BindingBasics[] getBindingBasics() throws Exception {
        ArrayList arylConnBindings = this.getConnectorBindings();
        ArrayList<BindingBasics> arylBindingBasics = new ArrayList<BindingBasics>();
        BindingBasics bbTemp = null;
        for (ConnectorAndBinding cAndB : arylConnBindings) {
            ServiceComponentDefn scdefnConnBind = cAndB.getBinding();
            ComponentType connector = cAndB.getConnector();
            bbTemp = new BindingBasics(scdefnConnBind.toString(), connector.getName(), null);
            arylBindingBasics.add(bbTemp);
        }
        BindingBasics[] aryBindingBasics = new BindingBasics[arylBindingBasics.size()];
        arylBindingBasics.toArray(aryBindingBasics);
        return aryBindingBasics;
    }

    public void deleteBinding(ServiceComponentDefn scdConnectorBinding) throws Exception {
        ConfigurationObjectEditor coeEditorForDelete = this.getConnectorBindingEditor();
        coeEditorForDelete.delete((ComponentObject)scdConnectorBinding, this.getNextStartupConfig(), true);
        List lstActions = null;
        try {
            lstActions = coeEditorForDelete.getDestination().getActions();
        }
        catch (Exception e) {
            ExceptionUtility.showMessage("Failed to get actions from the editor", e);
        }
        try {
            this.getConfigurationAdminAPI().executeTransaction(lstActions);
            ModelManager.getConfigurationManager(this.getConnection()).setRefreshNeeded();
        }
        catch (Exception e) {
            ExceptionUtility.showMessage("Failed trying to save the connector on the server", e);
        }
    }

    public void deleteBindings(Collection bindings) throws Exception {
        ConfigurationObjectEditor coeEditorForDelete = this.getConnectorBindingEditor();
        Configuration ns = this.getNextStartupConfig();
        for (ConnectorBinding cb : bindings) {
            coeEditorForDelete.delete((ComponentObject)cb, ns, true);
        }
        List lstActions = null;
        try {
            lstActions = coeEditorForDelete.getDestination().getActions();
        }
        catch (Exception e) {
            ExceptionUtility.showMessage("Failed to get actions from the editor", e);
        }
        try {
            this.getConfigurationAdminAPI().executeTransaction(lstActions);
            ModelManager.getConfigurationManager(this.getConnection()).setRefreshNeeded();
        }
        catch (Exception e) {
            ExceptionUtility.showMessage("Failed trying to save the connector on the server", e);
        }
    }

    public ArrayList getConnectors() {
        return this.getConnectors(false);
    }

    public ArrayList getConnectors(boolean bForceRefresh) {
        if (bForceRefresh) {
            this.arylConnectors = null;
            this.hmConnectorNameMap = null;
        }
        if (this.arylConnectors == null) {
            ConfigurationAdminAPI configAPI = this.getConfigurationAdminAPI();
            boolean includeDeprecated = false;
            Collection allTypes = null;
            try {
                allTypes = configAPI.getAllComponentTypes(includeDeprecated);
            }
            catch (Exception e) {
                ExceptionUtility.showMessage("Failed trying to retrieve All Types", e);
            }
            this.arylConnectors = new ArrayList(allTypes.size());
            ArrayList<String> sortConnectors = new ArrayList<String>(allTypes.size());
            this.hmConnectorNameMap = new HashMap(allTypes.size());
            Iterator iter = allTypes.iterator();
            ComponentType aType = null;
            while (iter.hasNext()) {
                aType = (ComponentType)iter.next();
                if (aType.getComponentTypeCode() != 2) continue;
                sortConnectors.add(aType.getID().getName());
                this.hmConnectorNameMap.put(aType.getName(), aType);
            }
            Collections.sort(sortConnectors);
            for (Object e : sortConnectors) {
                this.arylConnectors.add(this.hmConnectorNameMap.get(e));
            }
        }
        return this.arylConnectors;
    }

    public Configuration getNextStartupConfig() throws Exception {
        Configuration cfg = ModelManager.getConfigurationAPI(this.getConnection()).getNextStartupConfiguration();
        return cfg;
    }

    public ConnectorBasicInfo getConnectorBasicInfo(ComponentType ctypeConnector) throws Exception {
        Configuration nextStartupConfig = this.getNextStartupConfig();
        String sName = "";
        String sDesc = "";
        int iBindingsCount = 0;
        sName = ctypeConnector.getName();
        ComponentTypeID ctypeConnectorID = (ComponentTypeID)ctypeConnector.getID();
        Collection connectorBindingIDs = nextStartupConfig.getComponentDefnIDs(ctypeConnectorID);
        iBindingsCount = connectorBindingIDs == null ? 0 : connectorBindingIDs.size();
        ConnectorBasicInfo cbiInfo = new ConnectorBasicInfo(sName, iBindingsCount, sDesc);
        return cbiInfo;
    }

    public void reportConnectorDetails(ComponentType ctConnector) {
        this.hmConnectorNameMap.put(ctConnector.getName(), ctConnector);
        this.arylConnectors.add(ctConnector);
    }

    public String getValueForDefn(ComponentType ctCompType, String sDefnID) {
        String sResultValue = "";
        ComponentTypeDefn connectorTypeDefn = null;
        ComponentTypeDefn ctdCompTypeDefn = null;
        Iterator connectorTypeDefns = null;
        ComponentTypeID cTypeID = (ComponentTypeID)ctCompType.getID();
        try {
            connectorTypeDefns = this.getConfigurationAdminAPI().getComponentTypeDefinitions(cTypeID).iterator();
        }
        catch (Exception e) {
            ExceptionUtility.showMessage("Failed retrieving a value for a Defn: " + sDefnID, e);
        }
        while (connectorTypeDefns.hasNext()) {
            connectorTypeDefn = (ComponentTypeDefn)connectorTypeDefns.next();
            if (!connectorTypeDefn.getFullName().equals(sDefnID)) continue;
            ctdCompTypeDefn = connectorTypeDefn;
        }
        if (ctdCompTypeDefn != null) {
            PropertyDefinition propDef = null;
            Object defaultValue = null;
            try {
                propDef = ctdCompTypeDefn.getPropertyDefinition();
                defaultValue = propDef.getDefaultValue();
                sResultValue = defaultValue.toString();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return sResultValue;
    }

    public HashMap getUUIDConnectorBindingsMap(boolean bForceRefresh) throws Exception {
        ArrayList arylConnBinds = null;
        if (bForceRefresh) {
            this.hmUUIDConnectorBindingsMap = null;
        }
        if (this.hmUUIDConnectorBindingsMap == null) {
            this.hmUUIDConnectorBindingsMap = new HashMap();
            arylConnBinds = this.getConnectorBindings();
            Iterator itConnBinds = arylConnBinds.iterator();
            while (itConnBinds.hasNext()) {
                ServiceComponentDefn scdTemp = ((ConnectorAndBinding)itConnBinds.next()).getBinding();
                this.hmUUIDConnectorBindingsMap.put(scdTemp.getRoutingUUID(), scdTemp.toString());
            }
        }
        return this.hmUUIDConnectorBindingsMap;
    }

    public ArrayList getConnectorBindings() throws Exception {
        return this.getConnectorBindings(true);
    }

    public Collection getAllConnectorBindings() throws Exception {
        return this.getNextStartupConfig().getConnectorBindings();
    }

    public ArrayList getConnectorBindings(boolean bForceRefresh) throws Exception {
        if (bForceRefresh) {
            this.arylConnectorBindings = null;
        }
        if (this.arylConnectorBindings == null) {
            this.arylConnectorBindings = new ArrayList();
            Configuration cfgNextStartupCfg = this.getNextStartupConfig();
            ComponentType ctConnector = null;
            for (ConnectorBinding cb : cfgNextStartupCfg.getConnectorBindings()) {
                ctConnector = this.getConnectorForConnectorBinding((ServiceComponentDefn)cb);
                this.arylConnectorBindings.add(new ConnectorAndBinding(ctConnector, (ServiceComponentDefn)cb));
            }
        }
        return this.arylConnectorBindings;
    }

    public ConnectorBinding getConnectorBindingByName(String bindingName) throws Exception {
        ConnectorBinding theBinding = null;
        Configuration nextStartupCfg = this.getNextStartupConfig();
        Iterator it = nextStartupCfg.getConnectorBindings().iterator();
        while (it.hasNext() && theBinding == null) {
            ConnectorBinding cb = (ConnectorBinding)it.next();
            if (!cb.getName().equals(bindingName)) continue;
            theBinding = cb;
        }
        return theBinding;
    }

    public ConnectorBinding getConnectorBindingByUUID(String uuid) throws Exception {
        ConnectorBinding theBinding = null;
        Configuration nextStartupCfg = this.getNextStartupConfig();
        theBinding = nextStartupCfg.getConnectorBindingByRoutingID(uuid);
        return theBinding;
    }

    public ComponentType lookupConnector(String name) {
        ComponentType aConnector = null;
        aConnector = (ComponentType)this.hmConnectorNameMap.get(name);
        if (aConnector == null) {
            this.getConnectors(true);
            aConnector = (ComponentType)this.hmConnectorNameMap.get(name);
        }
        return aConnector;
    }

    public boolean connectorBindingNameAlreadyExists(String sName) throws Exception {
        boolean bNameExists = false;
        ArrayList colConnBinds = this.getConnectorBindings(true);
        ConnectorAndBinding scdCBTemp2 = null;
        for (ConnectorAndBinding scdCBTemp2 : colConnBinds) {
            String sThisCBName = scdCBTemp2.getBinding().toString();
            if (!sThisCBName.equals(sName)) continue;
            bNameExists = true;
            break;
        }
        return bNameExists;
    }

    public boolean connectorTypeNameAlreadyExists(String sName) throws Exception {
        boolean bNameExists = false;
        ArrayList colConnectorTypes = this.getConnectors(true);
        Iterator itCompTypes = colConnectorTypes.iterator();
        ComponentType ctConnectorType = null;
        while (itCompTypes.hasNext()) {
            ctConnectorType = (ComponentType)itCompTypes.next();
            String sThisConnectoryTypeName = ctConnectorType.getName();
            if (!sThisConnectoryTypeName.equals(sName)) continue;
            bNameExists = true;
            break;
        }
        return bNameExists;
    }

    public ComponentType getConnectorForConnectorBinding(ServiceComponentDefn scdBinding) {
        ComponentType ctConnector = null;
        ComponentTypeID connectorID = scdBinding.getComponentTypeID();
        try {
            ctConnector = this.getConfigurationAdminAPI().getComponentType(connectorID);
        }
        catch (Exception e) {
            ExceptionUtility.showMessage("Failed to get a Connector from a Connector ID", e);
        }
        return ctConnector;
    }

    public ConfigurationObjectEditor getConnectorBindingEditor() throws Exception {
        ConfigurationAdminAPI configAPI = this.getConfigurationAdminAPI();
        ConfigurationObjectEditor connectorBindingEditor = null;
        connectorBindingEditor = configAPI.createEditor();
        return connectorBindingEditor;
    }

    public ConnectorBinding getTentativeConnectorBinding(ComponentType ctConnector, ConfigurationObjectEditor coe, String sConnBindName) throws Exception {
        ConnectorBinding connectorBinding = coe.createConnectorComponent(Configuration.NEXT_STARTUP_ID, (ComponentTypeID)ctConnector.getID(), sConnBindName, null);
        Properties defaultProps = ModelManager.getConfigurationManager(this.getConnection()).getConfigModel(Configuration.NEXT_STARTUP_ID).getDefaultPropertyValues((ComponentTypeID)ctConnector.getID());
        connectorBinding = (ConnectorBinding)coe.modifyProperties((ComponentObject)connectorBinding, defaultProps, 0);
        return connectorBinding;
    }

    public ConnectorBinding copyConnectorBinding(ConnectorBinding original, ConfigurationObjectEditor coe, String sConnBindName) throws Exception {
        ConnectorBinding connectorBinding = coe.createConnectorComponent(Configuration.NEXT_STARTUP_ID, original, sConnBindName, null);
        return connectorBinding;
    }

    public PropertiedObject getPropertiedObject(ServiceComponentDefn scdConnectorBinding) throws Exception {
        ConfigurationManager configurationManager = ModelManager.getConfigurationManager(this.getConnection());
        PropertiedObject connectorBindingPO = configurationManager.getPropertiedObjectForComponentObject((ComponentObject)scdConnectorBinding);
        return connectorBindingPO;
    }

    public void saveConnectorBinding(ModificationActionQueue maqActionQForBinding) throws Exception {
        ConfigurationAdminAPI configAPI = this.getConfigurationAdminAPI();
        configAPI.executeTransaction(maqActionQForBinding.popActions());
        ModelManager.getConfigurationManager(this.getConnection()).setRefreshNeeded();
        this.getConnectorBindings(true);
    }

    public PropertiedObjectEditor getPropertiedObjectEditor(ModificationActionQueue maqActionQForBinding) throws Exception {
        ConfigurationPropertiedObjectEditor propertiedObjectEditor = new ConfigurationPropertiedObjectEditor(this.getConnection(), maqActionQForBinding);
        return propertiedObjectEditor;
    }

    public PropertiedObjectEditor getPropertiedObjectEditor() throws Exception {
        ConfigurationPropertiedObjectEditor propertiedObjectEditor = new ConfigurationPropertiedObjectEditor(this.getConnection());
        return propertiedObjectEditor;
    }

    public void setEnableForBindingInPSC(ServiceComponentDefn scdBinding, ProductServiceConfig psc, boolean bEnabled, ConfigurationObjectEditor coe) throws Exception {
        boolean bDeleteDeployedComponents = true;
        coe.setEnabled(this.getNextStartupConfig(), scdBinding, psc, bEnabled, bDeleteDeployedComponents);
    }

    public void setEnableForBindingInPSCByConfig(Configuration cfg, ServiceComponentDefn scdBinding, ProductServiceConfig psc, boolean bEnabled, ConfigurationObjectEditor coe) throws Exception {
        boolean bDeleteDeployedComponents = true;
        coe.setEnabled(cfg, scdBinding, psc, bEnabled, bDeleteDeployedComponents);
    }

    public void createConnectorBinding(ServiceComponentDefn binding, ConfigurationObjectEditor coe, ProductServiceConfig[] pscs) throws Exception {
        ServiceComponentDefnID bindingID = (ServiceComponentDefnID)binding.getID();
        Configuration nextStartupConfig = this.getNextStartupConfig();
        for (int i = 0; i < pscs.length; ++i) {
            coe.addServiceComponentDefn(pscs[i], bindingID);
            coe.deployServiceDefn(nextStartupConfig, binding, (ProductServiceConfigID)pscs[i].getID());
        }
        this.getConfigurationAdminAPI().executeTransaction(coe.getDestination().popActions());
        ModelManager.getConfigurationManager(this.getConnection()).setRefreshNeeded();
        this.getConnectorBindings(true);
    }

    public void createConnectorBinding(Collection bindings, ConfigurationObjectEditor coe, ProductServiceConfig[] pscs) throws Exception {
        Configuration nextStartupConfig = this.getNextStartupConfig();
        for (ConnectorBinding cb : bindings) {
            ConnectorBindingID cbID = (ConnectorBindingID)cb.getID();
            for (int i = 0; i < pscs.length; ++i) {
                coe.addServiceComponentDefn(pscs[i], (ServiceComponentDefnID)cbID);
                coe.deployServiceDefn(nextStartupConfig, (ServiceComponentDefn)cb, (ProductServiceConfigID)pscs[i].getID());
            }
        }
        this.getConfigurationAdminAPI().executeTransaction(coe.getDestination().popActions());
        ModelManager.getConfigurationManager(this.getConnection()).setRefreshNeeded();
        this.getConnectorBindings(true);
    }

    public ConnectorBinding createConnectorBinding(ConnectorBinding oldBinding, String newName, ConfigurationObjectEditor coe) throws Exception {
        ConnectorBinding newBinding = coe.createConnectorComponent(Configuration.NEXT_STARTUP_ID, oldBinding, newName, null);
        ConnectorBindingID newBindingID = (ConnectorBindingID)newBinding.getID();
        ConnectorBindingID oldBindingID = (ConnectorBindingID)oldBinding.getID();
        Configuration nextStartupConfig = this.getNextStartupConfig();
        Collection pscs = nextStartupConfig.getPSCsForServiceDefn((ServiceComponentDefnID)oldBindingID);
        for (ProductServiceConfig psc : pscs) {
            coe.addServiceComponentDefn(psc, (ServiceComponentDefnID)newBindingID);
            coe.deployServiceDefn(nextStartupConfig, (ServiceComponentDefn)newBinding, (ProductServiceConfigID)psc.getID());
        }
        this.getConfigurationAdminAPI().executeTransaction(coe.getDestination().popActions());
        ModelManager.getConfigurationManager(this.getConnection()).setRefreshNeeded();
        this.getConnectorBindings(true);
        return this.getConnectorBindingByName(newName);
    }

    public ServiceComponentDefn getBindingCopyFromPsc(ProductServiceConfig psc, ServiceComponentDefn scdBinding, ConnectionInfo connection) throws Exception {
        ServiceComponentDefn scdBindingCopy = this.getBindingFromPSC(this.getNextStartupConfig(), scdBinding.getRoutingUUID(), psc);
        return scdBindingCopy;
    }

    public ServiceComponentDefn getBindingCopyFromPscByConfig(Configuration cfg, ProductServiceConfig psc, ServiceComponentDefn scdBinding) throws Exception {
        ServiceComponentDefn scdBindingCopy = this.getBindingFromPSC(cfg, scdBinding.getRoutingUUID(), psc);
        return scdBindingCopy;
    }

    public Collection getAllConnectorsPSCs() throws Exception {
        return this.getAllConnectorsPSCsByConfig(this.getNextStartupConfig());
    }

    public Collection getAllConnectorsPSCsByConfig(Configuration cfg) throws Exception {
        ProductTypeID connectorProductTypeID = new ProductTypeID("Connectors");
        Iterator itAllConnectorPSCs = cfg.getComponentDefnIDs((ComponentTypeID)connectorProductTypeID).iterator();
        ProductServiceConfigID pscID = null;
        ProductServiceConfig psc = null;
        HashSet<ProductServiceConfig> colResult = new HashSet<ProductServiceConfig>();
        while (itAllConnectorPSCs.hasNext()) {
            pscID = (ProductServiceConfigID)itAllConnectorPSCs.next();
            psc = (ProductServiceConfig)cfg.getComponentDefn((ComponentDefnID)pscID);
            colResult.add(psc);
        }
        return colResult;
    }

    private ServiceComponentDefn getBindingFromPSC(Configuration config, String routingUUID, ProductServiceConfig psc) {
        Iterator iter = psc.getServiceComponentDefnIDs().iterator();
        ServiceComponentDefnID bindingID = null;
        ServiceComponentDefn binding = null;
        while (iter.hasNext()) {
            bindingID = (ServiceComponentDefnID)iter.next();
            binding = (ServiceComponentDefn)config.getComponentDefn((ComponentDefnID)bindingID);
            if (!binding.getRoutingUUID().equals(routingUUID)) continue;
            return binding;
        }
        return null;
    }
}

