/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.models;

import com.metamatrix.common.extensionmodule.ExtensionModuleDescriptor;
import com.metamatrix.common.extensionmodule.exception.DuplicateExtensionModuleException;
import com.metamatrix.common.extensionmodule.exception.ExtensionModuleNotFoundException;
import com.metamatrix.common.extensionmodule.exception.ExtensionModuleOrderingException;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.Manager;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.console.ui.views.extensionsource.ExtensionSourceDetailInfo;
import com.metamatrix.console.ui.views.extensionsource.NewExtensionSourceInfo;
import com.metamatrix.console.util.ExternalException;
import com.metamatrix.core.util.DateUtil;
import com.metamatrix.platform.admin.api.ExtensionSourceAdminAPI;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class ExtensionSourceManager
extends Manager {
    public ExtensionSourceManager(ConnectionInfo connection) {
        super(connection);
    }

    @Override
    public void init() {
        super.init();
    }

    public void deleteModule(String moduleName) throws ExternalException, ExtensionModuleNotFoundException {
        ExtensionSourceAdminAPI api = ModelManager.getExtensionSourceAPI(this.getConnection());
        try {
            api.removeSource(moduleName);
        }
        catch (ExtensionModuleNotFoundException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExternalException("Remove extension module " + moduleName, ex);
        }
    }

    public void modifyModule(String existingModuleName, String newModuleName, String newDescription, Boolean enabled, byte[] contents) throws ExtensionModuleNotFoundException, ExternalException {
        ExtensionSourceAdminAPI api = ModelManager.getExtensionSourceAPI(this.getConnection());
        String moduleName = existingModuleName;
        if (newModuleName != null && !newModuleName.equals(existingModuleName)) {
            try {
                api.setSourceName(existingModuleName, newModuleName);
            }
            catch (ExtensionModuleNotFoundException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new ExternalException("Attempt to rename an extension module", ex);
            }
            moduleName = newModuleName;
        }
        if (newDescription != null) {
            try {
                api.setSourceDescription(moduleName, newDescription);
            }
            catch (ExtensionModuleNotFoundException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new ExternalException("Attempt to change extension module description", ex);
            }
        }
        if (enabled != null) {
            try {
                ArrayList<String> moduleNames = new ArrayList<String>(1);
                moduleNames.add(moduleName);
                api.setEnabled(moduleNames, enabled.booleanValue());
            }
            catch (ExtensionModuleNotFoundException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new ExternalException("Attempt to change extension module enabled flag", ex);
            }
        }
        if (contents != null) {
            try {
                api.setSource(moduleName, contents);
            }
            catch (ExtensionModuleNotFoundException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new ExternalException("Attempt to change extension module contents", ex);
            }
        }
    }

    public void replaceModule(String moduleName, byte[] replacementContents) throws ExtensionModuleNotFoundException, ExternalException {
        this.modifyModule(moduleName, null, null, null, replacementContents);
    }

    public void exportToFile(String moduleName, File target) throws ExtensionModuleNotFoundException, ExternalException {
        ExtensionSourceAdminAPI api = ModelManager.getExtensionSourceAPI(this.getConnection());
        try {
            byte[] contents = api.getSource(moduleName);
            FileOutputStream stream = new FileOutputStream(target);
            stream.write(contents);
            stream.close();
        }
        catch (ExtensionModuleNotFoundException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExternalException("Error exporting extension module", ex);
        }
    }

    public void addModule(NewExtensionSourceInfo info) throws DuplicateExtensionModuleException, ExternalException {
        ExtensionSourceAdminAPI api = ModelManager.getExtensionSourceAPI(this.getConnection());
        try {
            api.addSource(info.getModuleType(), info.getModuleName(), info.getFileContents(), info.getDescription(), info.isEnabled());
        }
        catch (DuplicateExtensionModuleException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExternalException("Attempt to add extension module", ex);
        }
    }

    public ExtensionSourceDetailInfo getDetailForModule(String moduleName) throws ExtensionModuleNotFoundException, ExternalException {
        ExtensionSourceAdminAPI api = ModelManager.getExtensionSourceAPI(this.getConnection());
        try {
            ExtensionModuleDescriptor descriptor = api.getSourceDescriptor(moduleName);
            String creationDateAsString = descriptor.getCreationDate();
            Date creationDate = DateUtil.convertStringToDate((String)creationDateAsString);
            String lastUpdateDateAsString = descriptor.getLastUpdatedDate();
            Date lastUpdateDate = DateUtil.convertStringToDate((String)lastUpdateDateAsString);
            String createdBy = descriptor.getCreatedBy();
            String lastUpdatedBy = descriptor.getLastUpdatedBy();
            ExtensionSourceDetailInfo detail = new ExtensionSourceDetailInfo(descriptor.getName(), descriptor.getType(), descriptor.getDescription(), descriptor.isEnabled(), creationDate, createdBy, lastUpdateDate, lastUpdatedBy);
            return detail;
        }
        catch (ExtensionModuleNotFoundException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExternalException("Error retrieving detail for extension module", ex);
        }
    }

    public void reorderModules(List modules) throws ExtensionModuleOrderingException, ExternalException {
        ExtensionSourceAdminAPI api = ModelManager.getExtensionSourceAPI(this.getConnection());
        try {
            api.setSearchOrder(modules);
        }
        catch (ExtensionModuleOrderingException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExternalException("Error changing extension module search order", ex);
        }
    }

    public ExtensionSourceDetailInfo[] getModules() throws ExternalException {
        ExtensionSourceAdminAPI api = ModelManager.getExtensionSourceAPI(this.getConnection());
        ExtensionSourceDetailInfo[] details = null;
        List descriptors = null;
        try {
            descriptors = api.getSourceDescriptors();
            int numModules = descriptors.size();
            details = new ExtensionSourceDetailInfo[numModules];
            Iterator it = descriptors.iterator();
            int i = 0;
            while (it.hasNext()) {
                ExtensionModuleDescriptor descriptor = (ExtensionModuleDescriptor)it.next();
                Date creationDate = DateUtil.convertStringToDate((String)descriptor.getCreationDate());
                Date lastUpdateDate = DateUtil.convertStringToDate((String)descriptor.getLastUpdatedDate());
                details[i] = new ExtensionSourceDetailInfo(descriptor.getName(), descriptor.getType(), descriptor.getDescription(), descriptor.isEnabled(), creationDate, descriptor.getCreatedBy(), lastUpdateDate, descriptor.getLastUpdatedBy());
                ++i;
            }
        }
        catch (Exception ex) {
            throw new ExternalException("Retrieve extension modules", ex);
        }
        return details;
    }

    public String[] getModuleTypes() throws ExternalException {
        String[] result = null;
        ExtensionSourceAdminAPI api = ModelManager.getExtensionSourceAPI(this.getConnection());
        try {
            Collection types = api.getSourceTypes();
            result = new String[types.size()];
            Iterator it = types.iterator();
            int i = 0;
            while (it.hasNext()) {
                result[i] = (String)it.next();
                ++i;
            }
        }
        catch (Exception ex) {
            throw new ExternalException("Get extension module types", ex);
        }
        return result;
    }

    public boolean moduleExists(String moduleName) throws ExternalException {
        ExtensionSourceAdminAPI api = ModelManager.getExtensionSourceAPI(this.getConnection());
        boolean exists = false;
        try {
            exists = api.isSourceExists(moduleName);
        }
        catch (Exception ex) {
            throw new ExternalException("Error calling getSourceDescriptor()", ex);
        }
        return exists;
    }
}

