/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.models;

import com.metamatrix.admin.api.exception.security.MetaMatrixSecurityException;
import com.metamatrix.api.exception.ComponentNotFoundException;
import com.metamatrix.api.exception.security.AuthorizationException;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.Manager;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.console.ui.util.ConsoleConstants;
import com.metamatrix.console.ui.views.entitlements.PrincipalChangeListener;
import com.metamatrix.console.ui.views.users.RoleDisplay;
import com.metamatrix.console.util.ExternalException;
import com.metamatrix.platform.admin.api.AuthorizationAdminAPI;
import com.metamatrix.platform.security.api.MetaMatrixPrincipal;
import com.metamatrix.platform.security.api.MetaMatrixPrincipalName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GroupsManager
extends Manager {
    public static final String[][] PROPS_AND_DISPLAY_NAMES_FOR_METAMATRIX_GROUPS = new String[][]{{"description", "Description"}};
    private Map roles = null;
    private List principalChangeListeners = new ArrayList(1);

    public GroupsManager(ConnectionInfo connection) {
        super(connection);
    }

    @Override
    public void init() {
        super.init();
    }

    public Map getRoles() throws ExternalException, AuthorizationException {
        if (this.roles == null) {
            try {
                AuthorizationAdminAPI authAPI = ModelManager.getAuthorizationAPI(this.getConnection());
                this.roles = authAPI.getRoleDescriptions();
                for (Map.Entry entry : this.roles.entrySet()) {
                    String key = (String)entry.getKey();
                    String val = (String)entry.getValue();
                    boolean skipping = this.isSkippedRole(key);
                    if (!skipping) {
                        RoleDisplay roleDisplay = new RoleDisplay(key, val);
                        this.roles.put(key, roleDisplay);
                        continue;
                    }
                    this.roles.remove(key);
                }
            }
            catch (AuthorizationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ExternalException(e);
            }
        }
        return this.roles;
    }

    public RoleDisplay getRoleDisplay(String roleName) throws ExternalException, AuthorizationException {
        RoleDisplay rd = (RoleDisplay)this.roles.get(roleName);
        return rd;
    }

    public String getRoleDescription(String roleName) throws ExternalException, AuthorizationException {
        String desc = null;
        Map roles = this.getRoles();
        RoleDisplay rd = (RoleDisplay)roles.get(roleName);
        if (rd != null) {
            desc = rd.getDescription();
        }
        return desc;
    }

    public String getRoleDisplayName(String roleName) throws ExternalException, AuthorizationException {
        String displayName = null;
        Map roles = this.getRoles();
        RoleDisplay rd = (RoleDisplay)roles.get(roleName);
        if (rd != null) {
            displayName = rd.getDisplayName();
        }
        return displayName;
    }

    public Collection getPrincipalsForRole(String roleName) throws ComponentNotFoundException, AuthorizationException, ExternalException {
        Collection principals;
        try {
            principals = ModelManager.getAuthorizationAPI(this.getConnection()).getPrincipalsForRole(roleName);
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (ComponentNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExternalException(e);
        }
        return principals;
    }

    public RoleDisplay[] getRolesForPrincipal(MetaMatrixPrincipalName principalName) throws ComponentNotFoundException, AuthorizationException, ExternalException, MetaMatrixSecurityException {
        Collection roles;
        try {
            roles = ModelManager.getAuthorizationAPI(this.getConnection()).getRoleNamesForPrincipal(principalName);
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (ComponentNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExternalException(e);
        }
        ArrayList<RoleDisplay> rds = new ArrayList<RoleDisplay>();
        for (String roleName : roles) {
            RoleDisplay rd = (RoleDisplay)this.getRoles().get(roleName);
            rds.add(rd);
        }
        RoleDisplay[] rdArray = new RoleDisplay[rds.size()];
        Iterator it = rds.iterator();
        int i = 0;
        while (it.hasNext()) {
            rdArray[i] = (RoleDisplay)it.next();
            ++i;
        }
        return rdArray;
    }

    public RoleDisplay[] getRolesForPrincipal(MetaMatrixPrincipal principal, boolean includeImplicit) throws ComponentNotFoundException, AuthorizationException, ExternalException, MetaMatrixSecurityException {
        return this.getRolesForPrincipal(principal.getMetaMatrixPrincipalName());
    }

    public void addPrincipalsToRole(Collection principals, String role) throws ComponentNotFoundException, AuthorizationException, ExternalException {
        try {
            ModelManager.getAuthorizationAPI(this.getConnection()).addPrincipalsToRole(new HashSet(principals), role);
        }
        catch (ComponentNotFoundException e) {
            throw e;
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExternalException(e);
        }
    }

    public void removePrincipalsFromRole(Collection principals, String role) throws ComponentNotFoundException, AuthorizationException, ExternalException {
        try {
            ModelManager.getAuthorizationAPI(this.getConnection()).removePrincipalsFromRole(new HashSet(principals), role);
        }
        catch (ComponentNotFoundException e) {
            throw e;
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExternalException(e);
        }
    }

    public void removeRolesFromPrincipal(String[] roles, MetaMatrixPrincipalName principal) throws ComponentNotFoundException, AuthorizationException, ExternalException {
        ArrayList<MetaMatrixPrincipalName> princ = new ArrayList<MetaMatrixPrincipalName>();
        princ.add(principal);
        for (int i = 0; i < roles.length; ++i) {
            this.removePrincipalsFromRole(princ, roles[i]);
        }
    }

    public Collection getAllGroupNames() throws ExternalException, AuthorizationException, ComponentNotFoundException {
        return Collections.EMPTY_LIST;
    }

    public List getDomainNames() throws ExternalException, AuthorizationException, ComponentNotFoundException {
        List domainNames = Collections.EMPTY_LIST;
        try {
            domainNames = ModelManager.getMembershipAPI(this.getConnection()).getDomainNames();
        }
        catch (Exception e) {
            return domainNames;
        }
        return domainNames;
    }

    public void setDomainOrder(List domainNames) throws ExternalException, AuthorizationException, ComponentNotFoundException {
    }

    public void setEnableSecurity(boolean enabled) throws ExternalException, AuthorizationException, ComponentNotFoundException {
    }

    public void setAdminUsername(String username) throws ExternalException, AuthorizationException, ComponentNotFoundException {
    }

    public void setAdminPassword(String password) throws ExternalException, AuthorizationException, ComponentNotFoundException {
    }

    public Collection getGroupsForDomain(String theDomain) {
        Set groupNames = null;
        try {
            groupNames = ModelManager.getMembershipAPI(this.getConnection()).getGroupsForDomain(theDomain);
        }
        catch (Exception e) {
            return Collections.EMPTY_SET;
        }
        if (groupNames != null) {
            return groupNames;
        }
        return Collections.EMPTY_SET;
    }

    public Map getMetaMatrixPropNamesForGroups() {
        Hashtable<String, String> htPropNamesAndDisplayNames = new Hashtable<String, String>();
        for (String[] aryTemp : PROPS_AND_DISPLAY_NAMES_FOR_METAMATRIX_GROUPS) {
            htPropNamesAndDisplayNames.put(aryTemp[0], aryTemp[1]);
        }
        return htPropNamesAndDisplayNames;
    }

    public void addPrincipalChangeListener(PrincipalChangeListener listener) {
        int loc = this.principalChangeListeners.indexOf(listener);
        if (loc < 0) {
            this.principalChangeListeners.add(listener);
        }
    }

    public boolean isSkippedRole(String roleName) {
        boolean skipped = false;
        int i = 0;
        while (!skipped && i < ConsoleConstants.ROLES_NOT_DISPLAYED.length) {
            if (roleName.equals(ConsoleConstants.ROLES_NOT_DISPLAYED[i])) {
                skipped = true;
                continue;
            }
            ++i;
        }
        return skipped;
    }
}

