/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.models;

import com.metamatrix.common.util.crypto.Encryptor;
import com.metamatrix.common.util.crypto.NullCryptor;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.ManagerListener;
import com.metamatrix.console.models.ModelChangedEvent;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import javax.swing.event.EventListenerList;

public abstract class Manager {
    public static final String MODEL_CHANGED = "Managed model changed.";
    public static final String MODEL_STALE = "Managed model data stale.";
    private boolean isStale;
    private EventListenerList listeners;
    private ConnectionInfo connection;

    public Manager(ConnectionInfo connection) {
        this.connection = connection;
    }

    public ConnectionInfo getConnection(boolean reconnect) {
        this.connection.getServerConnection(reconnect);
        return this.connection;
    }

    public ConnectionInfo getConnection() {
        return this.getConnection(true);
    }

    public void init() {
        this.setListeners(new EventListenerList());
    }

    public void refresh() {
        this.setIsStale(true);
    }

    public void addManagerListener(ManagerListener listener) {
        this.getListeners().add(ManagerListener.class, listener);
    }

    public void removeManagerListener(ManagerListener listener) {
        this.getListeners().remove(ManagerListener.class, listener);
    }

    protected void fireModelChangedEvent(String message) {
        this.fireModelChangedEvent(message, "No arg");
    }

    protected void fireModelChangedEvent(String message, Object arg) {
        ModelChangedEvent e = new ModelChangedEvent(this, message, arg);
        Object[] listeners = this.getListeners().getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ManagerListener.class) continue;
            ((ManagerListener)listeners[i + 1]).modelChanged(e);
        }
    }

    public boolean getIsStale() {
        return this.isStale;
    }

    public void setIsStale(boolean isStale) {
        this.isStale = isStale;
        if (this.isStale) {
            this.fireModelChangedEvent(MODEL_STALE);
        }
    }

    private EventListenerList getListeners() {
        return this.listeners;
    }

    protected List getEventListeners() {
        EventListener[] listeners = this.getListeners().getListeners(ManagerListener.class);
        ArrayList<EventListener> list = new ArrayList<EventListener>();
        int count = listeners.length;
        for (int i = 0; i < count; ++i) {
            list.add(listeners[i]);
        }
        return list;
    }

    private void setListeners(EventListenerList aList) {
        this.listeners = aList;
    }

    public synchronized Encryptor getEncryptor() {
        return new NullCryptor();
    }
}

