/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.models;

import com.metamatrix.common.log.LogManager;
import com.metamatrix.console.ConsolePlugin;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.AuthenticationProviderManager;
import com.metamatrix.console.models.ConfigurationManager;
import com.metamatrix.console.models.ConnectorManager;
import com.metamatrix.console.models.EntitlementManager;
import com.metamatrix.console.models.ExtensionSourceManager;
import com.metamatrix.console.models.GroupsManager;
import com.metamatrix.console.models.Managers;
import com.metamatrix.console.models.PropertiesManager;
import com.metamatrix.console.models.QueryManager;
import com.metamatrix.console.models.ResourceManager;
import com.metamatrix.console.models.RuntimeMgmtManager;
import com.metamatrix.console.models.ServerLogManager;
import com.metamatrix.console.models.SessionManager;
import com.metamatrix.console.models.SummaryManager;
import com.metamatrix.console.models.VdbManager;
import com.metamatrix.console.security.UserCapabilities;
import com.metamatrix.console.ui.ViewManager;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.console.util.ExternalException;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.platform.admin.api.AuthorizationAdminAPI;
import com.metamatrix.platform.admin.api.ConfigurationAdminAPI;
import com.metamatrix.platform.admin.api.ExtensionSourceAdminAPI;
import com.metamatrix.platform.admin.api.MembershipAdminAPI;
import com.metamatrix.platform.admin.api.RuntimeStateAdminAPI;
import com.metamatrix.platform.admin.api.SessionAdminAPI;
import com.metamatrix.platform.admin.api.SubSystemAdminAPI;
import com.metamatrix.platform.security.api.MetaMatrixPrincipalName;
import com.metamatrix.server.admin.api.QueryAdminAPI;
import com.metamatrix.server.admin.api.RuntimeMetadataAdminAPI;
import com.metamatrix.server.admin.api.TransactionAdminAPI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ModelManager {
    private static List connectionsList = new ArrayList(5);
    private static Map connectionToAPIMap = new HashMap(5);
    private static Map mgrsMap = new HashMap(5);

    public static ConnectionInfo[] getConnections() {
        ConnectionInfo[] connections = new ConnectionInfo[connectionsList.size()];
        Iterator it = connectionsList.iterator();
        int i = 0;
        while (it.hasNext()) {
            connections[i] = (ConnectionInfo)it.next();
            ++i;
        }
        return connections;
    }

    public static int getNumberofConnections() {
        return connectionsList.size();
    }

    public static void removeConnection(ConnectionInfo connection) {
        ModelManager.removeConnectionLo(connection);
    }

    public static void removeConnectionLo(ConnectionInfo connection) {
        HashMap capi = (HashMap)connectionToAPIMap.remove(connection);
        if (capi != null) {
            capi.clear();
        }
        mgrsMap.remove(connection);
        connectionsList.remove(connection);
    }

    public static boolean initViews(ConnectionInfo connection, boolean createFrame) {
        boolean initialized = false;
        boolean continuing = true;
        try {
            if (!UserCapabilities.getInstance().hasAnyRole(connection)) {
                continuing = false;
                MetaMatrixPrincipalName name = UserCapabilities.getLoggedInUser(connection);
                String title = ConsolePlugin.Util.getString("ModelManager.noRolesAssignedDialog.title");
                String msg = ConsolePlugin.Util.getString("ModelManager.noRolesAssignedDialog.msg", new Object[]{name.getName()});
                StaticUtilities.displayModalDialogWithOK(null, title, msg);
                connection.close();
            }
        }
        catch (Exception e) {
            continuing = false;
            String msg = ConsolePlugin.Util.getString("ModelManager.roleVerifyError.msg");
            ExceptionUtility.showCannotInitializeMessage(msg, e);
        }
        if (continuing) {
            if (createFrame) {
                ViewManager.init(connection);
            }
            initialized = true;
        }
        return initialized;
    }

    public static boolean init(ConnectionInfo conn) throws ExternalException, Exception {
        ModelManager.removeConnection(conn);
        connectionsList.add(conn);
        connectionToAPIMap.put(conn, new HashMap(5));
        GroupsManager userManager = new GroupsManager(conn);
        SessionManager sessionManager = new SessionManager(conn);
        QueryManager queryManager = new QueryManager(conn);
        EntitlementManager entitlementManager = new EntitlementManager(conn);
        ResourceManager resourceManager = new ResourceManager(conn);
        SummaryManager summaryManager = new SummaryManager(conn);
        ServerLogManager serverLogManager = new ServerLogManager(conn);
        PropertiesManager propertiesManager = new PropertiesManager(conn);
        ConnectorManager connectorManager = new ConnectorManager(conn);
        AuthenticationProviderManager authenticationProviderManager = new AuthenticationProviderManager(conn);
        ConfigurationManager configurationManager = new ConfigurationManager(conn);
        VdbManager vdbManager = new VdbManager(conn);
        RuntimeMgmtManager runtimeMgmtManager = new RuntimeMgmtManager(conn);
        ExtensionSourceManager extensionSourceManager = new ExtensionSourceManager(conn);
        Managers mgrs = new Managers(userManager, sessionManager, queryManager, entitlementManager, resourceManager, summaryManager, serverLogManager, propertiesManager, vdbManager, configurationManager, connectorManager, authenticationProviderManager, runtimeMgmtManager, extensionSourceManager);
        mgrsMap.put(conn, mgrs);
        userManager.init();
        sessionManager.init();
        queryManager.init();
        entitlementManager.init();
        resourceManager.init();
        summaryManager.init();
        serverLogManager.init();
        propertiesManager.init();
        vdbManager.init();
        extensionSourceManager.init();
        configurationManager.init();
        return true;
    }

    public static ServerLogManager getServerLogManager(ConnectionInfo conn) {
        ServerLogManager mgr = null;
        Managers mgrs = (Managers)mgrsMap.get(conn);
        if (mgrs != null) {
            mgr = mgrs.getServerLogManager();
        }
        return mgr;
    }

    public static GroupsManager getGroupsManager(ConnectionInfo conn) {
        GroupsManager mgr = null;
        Managers mgrs = (Managers)mgrsMap.get(conn);
        if (mgrs != null) {
            mgr = mgrs.getGroupsManager();
        }
        return mgr;
    }

    public static SessionManager getSessionManager(ConnectionInfo conn) {
        SessionManager mgr = null;
        Managers mgrs = (Managers)mgrsMap.get(conn);
        if (mgrs != null) {
            mgr = mgrs.getSessionManager();
        }
        return mgr;
    }

    public static QueryManager getQueryManager(ConnectionInfo conn) {
        QueryManager mgr = null;
        Managers mgrs = (Managers)mgrsMap.get(conn);
        if (mgrs != null) {
            mgr = mgrs.getQueryManager();
        }
        return mgr;
    }

    public static EntitlementManager getEntitlementManager(ConnectionInfo conn) {
        EntitlementManager mgr = null;
        Managers mgrs = (Managers)mgrsMap.get(conn);
        if (mgrs != null) {
            mgr = mgrs.getEntitlementManager();
        }
        return mgr;
    }

    public static ResourceManager getResourceManager(ConnectionInfo conn) {
        ResourceManager mgr = null;
        Managers mgrs = (Managers)mgrsMap.get(conn);
        if (mgrs != null) {
            mgr = mgrs.getPoolManager();
        }
        return mgr;
    }

    public static SummaryManager getSummaryManager(ConnectionInfo conn) {
        SummaryManager mgr = null;
        Managers mgrs = (Managers)mgrsMap.get(conn);
        if (mgrs != null) {
            mgr = mgrs.getSummaryManager();
        }
        return mgr;
    }

    public static PropertiesManager getPropertiesManager(ConnectionInfo conn) {
        PropertiesManager mgr = null;
        Managers mgrs = (Managers)mgrsMap.get(conn);
        if (mgrs != null) {
            mgr = mgrs.getPropertiesManager();
        }
        return mgr;
    }

    public static VdbManager getVdbManager(ConnectionInfo conn) {
        VdbManager mgr = null;
        Managers mgrs = (Managers)mgrsMap.get(conn);
        if (mgrs != null) {
            mgr = mgrs.getVDBManager();
        }
        return mgr;
    }

    public static ConfigurationManager getConfigurationManager(ConnectionInfo conn) {
        ConfigurationManager mgr = null;
        Managers mgrs = (Managers)mgrsMap.get(conn);
        if (mgrs != null) {
            mgr = mgrs.getConfigurationManager();
        }
        return mgr;
    }

    public static RuntimeMgmtManager getRuntimeMgmtManager(ConnectionInfo conn) {
        RuntimeMgmtManager mgr = null;
        Managers mgrs = (Managers)mgrsMap.get(conn);
        if (mgrs != null) {
            mgr = mgrs.getRuntimeMgmtManager();
        }
        return mgr;
    }

    public static ConnectorManager getConnectorManager(ConnectionInfo conn) {
        ConnectorManager mgr = null;
        Managers mgrs = (Managers)mgrsMap.get(conn);
        if (mgrs != null) {
            mgr = mgrs.getConnectorManager();
        }
        return mgr;
    }

    public static AuthenticationProviderManager getAuthenticationProviderManager(ConnectionInfo conn) {
        AuthenticationProviderManager mgr = null;
        Managers mgrs = (Managers)mgrsMap.get(conn);
        if (mgrs != null) {
            mgr = mgrs.getAuthenticationProviderManager();
        }
        return mgr;
    }

    public static ExtensionSourceManager getExtensionSourceManager(ConnectionInfo conn) {
        ExtensionSourceManager mgr = null;
        Managers mgrs = (Managers)mgrsMap.get(conn);
        if (mgrs != null) {
            mgr = mgrs.getExtensionSourceManager();
        }
        return mgr;
    }

    public static AuthorizationAdminAPI getAuthorizationAPI(ConnectionInfo conn) {
        return (AuthorizationAdminAPI)ModelManager.getSubSystemAdminAPI(AuthorizationAdminAPI.class, conn);
    }

    public static ConfigurationAdminAPI getConfigurationAPI(ConnectionInfo conn) {
        return (ConfigurationAdminAPI)ModelManager.getSubSystemAdminAPI(ConfigurationAdminAPI.class, conn);
    }

    public static MembershipAdminAPI getMembershipAPI(ConnectionInfo conn) {
        return (MembershipAdminAPI)ModelManager.getSubSystemAdminAPI(MembershipAdminAPI.class, conn);
    }

    public static RuntimeStateAdminAPI getRuntimeStateAPI(ConnectionInfo conn) {
        return (RuntimeStateAdminAPI)ModelManager.getSubSystemAdminAPI(RuntimeStateAdminAPI.class, conn);
    }

    public static SessionAdminAPI getSessionAPI(ConnectionInfo conn) {
        return (SessionAdminAPI)ModelManager.getSubSystemAdminAPI(SessionAdminAPI.class, conn);
    }

    public static QueryAdminAPI getQueryAPI(ConnectionInfo conn) {
        return (QueryAdminAPI)ModelManager.getSubSystemAdminAPI(QueryAdminAPI.class, conn);
    }

    public static RuntimeMetadataAdminAPI getRuntimeMetadataAPI(ConnectionInfo conn) {
        return (RuntimeMetadataAdminAPI)ModelManager.getSubSystemAdminAPI(RuntimeMetadataAdminAPI.class, conn);
    }

    public static TransactionAdminAPI getTransactionAPI(ConnectionInfo conn) {
        return (TransactionAdminAPI)ModelManager.getSubSystemAdminAPI(TransactionAdminAPI.class, conn);
    }

    public static ExtensionSourceAdminAPI getExtensionSourceAPI(ConnectionInfo conn) {
        return (ExtensionSourceAdminAPI)ModelManager.getSubSystemAdminAPI(ExtensionSourceAdminAPI.class, conn);
    }

    private static synchronized SubSystemAdminAPI getSubSystemAdminAPI(Class serviceInterface, ConnectionInfo conn) {
        SubSystemAdminAPI impl = null;
        Map apiToImplMap = (Map)connectionToAPIMap.get(conn);
        impl = (SubSystemAdminAPI)apiToImplMap.get(serviceInterface);
        if (impl == null) {
            try {
                impl = (SubSystemAdminAPI)conn.getServerConnection().getService(serviceInterface);
            }
            catch (Exception e) {
                LogManager.logCritical((String)"INITIALIZATION", (Throwable)e, (String)e.getMessage());
            }
            if (impl != null) {
                apiToImplMap.put(serviceInterface, impl);
            }
        }
        return impl;
    }

    public static synchronized void clearServices(ConnectionInfo conn) {
        Map apiToImplMap = (Map)connectionToAPIMap.get(conn);
        if (apiToImplMap != null) {
            apiToImplMap.clear();
        }
    }
}

