/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.models;

import com.metamatrix.admin.api.exception.security.InvalidSessionException;
import com.metamatrix.api.exception.ComponentNotFoundException;
import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.security.AuthorizationException;
import com.metamatrix.common.actions.ModificationActionQueue;
import com.metamatrix.common.actions.ModificationException;
import com.metamatrix.common.config.api.ComponentObject;
import com.metamatrix.common.config.api.ComponentTypeDefn;
import com.metamatrix.common.config.api.ComponentTypeID;
import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ConfigurationObjectEditor;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.common.object.PropertyDefinition;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.Manager;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.console.util.ExternalException;
import com.metamatrix.platform.admin.api.ConfigurationAdminAPI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class PropertiesManager
extends Manager {
    private static final String[] UNDISPLAYED_PROPERTIES = new String[]{"Essential Service"};
    private ConfigurationObjectEditor coeConfigEditor = null;

    public PropertiesManager(ConnectionInfo connection) {
        super(connection);
    }

    @Override
    public void init() {
        super.init();
        this.setIsStale(false);
    }

    public Map getProperties() throws ExternalException, AuthorizationException, ComponentNotFoundException {
        try {
            return this.getConfiguration().getProperties();
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (ComponentNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExternalException(e);
        }
    }

    public String getProperty(String key) throws ExternalException, AuthorizationException, ComponentNotFoundException {
        try {
            Object o = this.getConfiguration().getProperties().get(key);
            if (o != null) {
                return o.toString();
            }
            return null;
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (ComponentNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExternalException(e);
        }
    }

    public void setProperty(String name, String value, int cfgNumber) throws ExternalException, AuthorizationException, ComponentNotFoundException {
        try {
            if (cfgNumber == 2) {
                this.setProperty(name, value, this.getNextStartUpConfiguration());
            }
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (ComponentNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExternalException(e);
        }
    }

    public void setProperty(String name, String value, Configuration cfg) throws ExternalException, AuthorizationException, ComponentNotFoundException {
        try {
            this.getObjectEditor().setProperty((ComponentObject)cfg, name, value);
            this.applyUpdates();
            this.fireModelChangedEvent("Managed model changed.");
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (ComponentNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExternalException(e);
        }
    }

    private ConfigurationAdminAPI getConfigAPI() {
        return ModelManager.getConfigurationAPI(this.getConnection());
    }

    public Configuration getNextStartUpConfiguration() throws AuthorizationException, InvalidSessionException, ConfigurationException, MetaMatrixComponentException {
        Configuration nsuConfig = ModelManager.getConfigurationManager(this.getConnection()).getConfig(Configuration.NEXT_STARTUP_ID);
        return nsuConfig;
    }

    public Collection getNextStartUpDefn() throws ExternalException, AuthorizationException, ComponentNotFoundException {
        ArrayList<PropertyDefinition> nextStartUpDefn = new ArrayList<PropertyDefinition>();
        ComponentTypeDefn compTypeDefn2 = null;
        PropertyDefinition nDefinition = null;
        try {
            Configuration nextStartupConfig = this.getNextStartUpConfiguration();
            if (nextStartupConfig == null) {
                throw new RuntimeException("nextStartupConfig should not be null");
            }
            ComponentTypeID configTypeID = nextStartupConfig.getComponentTypeID();
            Collection componentTypeDefns = this.getConfigAPI().getAllComponentTypeDefinitions(configTypeID);
            for (ComponentTypeDefn compTypeDefn2 : componentTypeDefns) {
                nDefinition = compTypeDefn2.getPropertyDefinition();
                if (this.undisplayed(nDefinition)) continue;
                nextStartUpDefn.add(nDefinition);
            }
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (ComponentNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ExternalException(e);
        }
        return nextStartUpDefn;
    }

    public Properties getNSUProperties() throws ExternalException, AuthorizationException, ComponentNotFoundException {
        Properties nextStartupProps = null;
        try {
            Configuration nextStartupConfig = this.getNextStartUpConfiguration();
            nextStartupProps = nextStartupConfig.getProperties();
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (ComponentNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExternalException(e);
        }
        return nextStartupProps;
    }

    private void applyUpdates() throws AuthorizationException, InvalidSessionException, ComponentNotFoundException, ConfigurationException, ModificationException, MetaMatrixComponentException {
        ModificationActionQueue maq = this.getObjectEditor().getDestination();
        List lstActions = maq.popActions();
        ModelManager.getConfigurationAPI(this.getConnection()).executeTransaction(lstActions);
    }

    public Configuration getStartUpConfiguration() throws AuthorizationException, InvalidSessionException, ComponentNotFoundException, ConfigurationException, ModificationException, MetaMatrixComponentException {
        Configuration suConfig = ModelManager.getConfigurationManager(this.getConnection()).getConfig(Configuration.STARTUP_ID);
        return suConfig;
    }

    public Collection getStartUpDefn() throws ExternalException, AuthorizationException, ComponentNotFoundException {
        ArrayList<PropertyDefinition> startupDefn = new ArrayList<PropertyDefinition>();
        ComponentTypeDefn compTypeDefn2 = null;
        PropertyDefinition nDefinition = null;
        try {
            Configuration startupConfig = this.getStartUpConfiguration();
            ComponentTypeID configTypeID = startupConfig.getComponentTypeID();
            Collection componentTypeDefns = this.getConfigAPI().getAllComponentTypeDefinitions(configTypeID);
            for (ComponentTypeDefn compTypeDefn2 : componentTypeDefns) {
                nDefinition = compTypeDefn2.getPropertyDefinition();
                if (this.undisplayed(nDefinition)) continue;
                startupDefn.add(nDefinition);
            }
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (ComponentNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExternalException(e);
        }
        return startupDefn;
    }

    public Properties getSUProperties() throws ExternalException, AuthorizationException, ComponentNotFoundException {
        Properties startupProps = null;
        try {
            Configuration startupConfig = this.getStartUpConfiguration();
            startupProps = startupConfig.getProperties();
        }
        catch (Exception e) {
            throw new ExternalException(e);
        }
        return startupProps;
    }

    private Configuration getConfiguration() throws AuthorizationException, InvalidSessionException, ComponentNotFoundException, ConfigurationException, ModificationException, MetaMatrixComponentException {
        return this.getConfigurationNotLocked();
    }

    private Configuration getConfigurationNotLocked() throws AuthorizationException, InvalidSessionException, ComponentNotFoundException, ConfigurationException, ModificationException, MetaMatrixComponentException {
        return this.getConfiguration(false);
    }

    private Configuration getConfiguration(boolean bGetLocked) throws AuthorizationException, InvalidSessionException, ComponentNotFoundException, ConfigurationException, ModificationException, MetaMatrixComponentException {
        return ModelManager.getConfigurationManager(this.getConnection()).getConfig(Configuration.NEXT_STARTUP_ID);
    }

    private ConfigurationObjectEditor getObjectEditor() throws AuthorizationException, InvalidSessionException, ComponentNotFoundException, ConfigurationException, ModificationException, MetaMatrixComponentException {
        if (this.coeConfigEditor == null) {
            this.coeConfigEditor = this.getConfigAPI().createEditor();
        }
        return this.coeConfigEditor;
    }

    private boolean undisplayed(PropertyDefinition def) {
        String displayName = def.getDisplayName();
        boolean match = false;
        int i = 0;
        while (!match && i < UNDISPLAYED_PROPERTIES.length) {
            if (displayName.equalsIgnoreCase(UNDISPLAYED_PROPERTIES[i])) {
                match = true;
                continue;
            }
            ++i;
        }
        return match;
    }
}

