/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.models;

import com.metamatrix.admin.api.exception.security.InvalidSessionException;
import com.metamatrix.api.exception.ComponentNotFoundException;
import com.metamatrix.api.exception.security.AuthorizationException;
import com.metamatrix.api.exception.server.InvalidRequestIDException;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.ManagerListener;
import com.metamatrix.console.models.ModelChangedEvent;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.console.models.TimedManager;
import com.metamatrix.console.ui.ViewManager;
import com.metamatrix.console.util.AutoRefresher;
import com.metamatrix.console.util.ExternalException;
import com.metamatrix.console.util.InvalidRequestException;
import com.metamatrix.platform.admin.api.SessionAdminAPI;
import com.metamatrix.platform.security.api.MetaMatrixSessionID;
import com.metamatrix.platform.security.api.MetaMatrixSessionInfo;
import com.metamatrix.server.admin.api.QueryAdminAPI;
import com.metamatrix.server.serverapi.RequestInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.Action;

public class QueryManager
extends TimedManager
implements ManagerListener {
    private HashSet queryRequests;
    private MetaMatrixSessionID currentToken = null;
    private Action refreshAction;
    private AutoRefresher ar;

    public QueryManager(ConnectionInfo connection) {
        super(connection);
    }

    @Override
    public void init() {
        super.init();
        super.setRefreshRate(5);
        this.setQueryRequests(new HashSet());
        this.setIsStale(true);
        ModelManager.getSessionManager(this.getConnection()).addManagerListener(this);
        super.setIsAutoRefreshEnabled(false);
    }

    private QueryAdminAPI getQueryAdminAPI() {
        return ModelManager.getQueryAPI(this.getConnection());
    }

    private SessionAdminAPI getSessionAdminAPI() {
        return ModelManager.getSessionAPI(this.getConnection());
    }

    @Override
    public void modelChanged(ModelChangedEvent e) {
        if (e.getMessage().equals("A Session was terminated.")) {
            this.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelQueryRequests(Collection selected) throws ExternalException, AuthorizationException, InvalidRequestException, ComponentNotFoundException {
        try {
            ViewManager.startBusy();
            Iterator iterator = selected.iterator();
            ArrayList<RequestInfo> queries = new ArrayList<RequestInfo>(selected.size());
            while (iterator.hasNext()) {
                RequestInfo q = (RequestInfo)iterator.next();
                if (q.isAtomicQuery()) continue;
                queries.add(q);
            }
            for (RequestInfo q : selected) {
                try {
                    if (q.isAtomicQuery()) {
                        if (queries.contains(q)) continue;
                        this.getQueryAdminAPI().cancelRequest(q.getRequestID(), q.getNodeID());
                        continue;
                    }
                    this.getQueryAdminAPI().cancelRequest(q.getRequestID());
                }
                catch (AuthorizationException e) {
                    throw e;
                }
                catch (ComponentNotFoundException e) {
                    throw e;
                }
                catch (InvalidRequestIDException e) {
                    throw new InvalidRequestException((Exception)((Object)e));
                }
                catch (InvalidSessionException e) {
                    throw new InvalidRequestException((Exception)((Object)e));
                }
                catch (Exception e) {
                    throw new ExternalException(e);
                }
            }
            this.refresh();
        }
        finally {
            ViewManager.endBusy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAllQueryRequests(MetaMatrixSessionID token) throws ComponentNotFoundException, InvalidRequestException, AuthorizationException, ExternalException {
        try {
            ViewManager.startBusy();
            try {
                this.getQueryAdminAPI().cancelRequests(token);
            }
            catch (ComponentNotFoundException e) {
                throw e;
            }
            catch (InvalidSessionException e) {
                throw new InvalidRequestException((Exception)((Object)e));
            }
            catch (AuthorizationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ExternalException(e);
            }
            this.refresh();
        }
        finally {
            ViewManager.endBusy();
        }
    }

    public Collection getAllRequests() throws AuthorizationException, ExternalException {
        this.loadRealData();
        return (Collection)this.getQueryRequests().clone();
    }

    public Collection getRequestsForSession(MetaMatrixSessionInfo session) throws AuthorizationException, ExternalException {
        this.loadRealData(session.getSessionToken().getSessionID());
        Collection result = (Collection)this.getQueryRequests().clone();
        return result;
    }

    public void setAutoRefresher(AutoRefresher autoRefresher) {
        this.ar = autoRefresher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadRealData() throws ExternalException, AuthorizationException {
        boolean autoRefresh;
        boolean bl = autoRefresh = this.ar != null && this.ar.isAutoRefreshEnabled();
        if (this.getIsStale() || autoRefresh || this.currentToken != null) {
            try {
                Collection col;
                this.currentToken = null;
                ViewManager.startBusy();
                try {
                    col = this.getQueryAdminAPI().getAllRequests();
                }
                catch (AuthorizationException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new ExternalException(e);
                }
                if (col != null) {
                    this.setQueryRequests(new HashSet(col));
                } else {
                    this.setQueryRequests(new HashSet(0));
                }
                this.setIsStale(false);
                super.startTimer();
            }
            finally {
                ViewManager.endBusy();
            }
        }
    }

    private void loadRealData(MetaMatrixSessionID token) throws ExternalException, AuthorizationException {
        Collection col = null;
        if (this.getIsStale() || !token.equals((Object)this.currentToken)) {
            try {
                this.currentToken = token;
                ViewManager.startBusy();
                if (this.getSessionAdminAPI().isSessionValid(token).booleanValue()) {
                    col = this.getQueryAdminAPI().getRequestsForSession(token);
                }
                if (col != null) {
                    this.setQueryRequests(new HashSet(col));
                } else {
                    this.setQueryRequests(new HashSet(0));
                }
                this.setIsStale(false);
                super.startTimer();
            }
            catch (InvalidSessionException e) {
                this.setQueryRequests(new HashSet(0));
            }
            catch (AuthorizationException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ExternalException(e);
            }
            finally {
                ViewManager.endBusy();
            }
        }
    }

    private HashSet getQueryRequests() {
        return this.queryRequests;
    }

    private void setQueryRequests(HashSet set) {
        this.queryRequests = set;
    }

    @Override
    public void refresh() {
        super.refresh();
        if (this.refreshAction != null) {
            this.refreshAction.actionPerformed(null);
        }
    }

    public void setRefreshAction(Action refAction) {
        this.refreshAction = refAction;
    }
}

