/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.models;

import com.metamatrix.api.exception.security.AuthorizationException;
import com.metamatrix.common.config.api.ComponentObject;
import com.metamatrix.common.config.api.ConfigurationID;
import com.metamatrix.common.config.api.ResourceDescriptor;
import com.metamatrix.common.config.api.SharedResource;
import com.metamatrix.common.object.PropertiedObject;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.ConfigurationManager;
import com.metamatrix.console.models.Manager;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.console.models.ResourcePropertiedObjectEditor;
import com.metamatrix.console.ui.views.pools.PoolConfigTableRowData;
import com.metamatrix.console.util.ExternalException;
import com.metamatrix.platform.admin.api.ConfigurationAdminAPI;
import java.util.Collection;
import java.util.Iterator;

public class ResourceManager
extends Manager {
    public static final int NEXT_STARTUP_CONFIG = 1;
    public static final int STARTUP_CONFIG = 2;

    public ResourceManager(ConnectionInfo connection) {
        super(connection);
    }

    public PropertiedObject getPropertiedObjectForResourceDescriptor(ComponentObject rd) {
        ConfigurationManager mgr = ModelManager.getConfigurationManager(this.getConnection());
        PropertiedObject po = mgr.getPropertiedObjectForComponentObject(rd);
        return po;
    }

    public ConfigurationID getConfigurationID(int type) throws AuthorizationException, ExternalException {
        ConfigurationID configID = null;
        ConfigurationAdminAPI capi = ModelManager.getConfigurationAPI(this.getConnection());
        try {
            switch (type) {
                case 1: {
                    configID = capi.getNextStartupConfigurationID();
                    break;
                }
                case 2: {
                    configID = capi.getStartupConfigurationID();
                }
            }
        }
        catch (AuthorizationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExternalException(ex);
        }
        return configID;
    }

    public void updateResourceProperties(ResourcePropertiedObjectEditor editor) throws Exception {
        editor.apply();
    }

    public ResourcePropertiedObjectEditor getResourcePropertiedObjectEditor() throws AuthorizationException, ExternalException {
        ConfigurationID configID = this.getConfigurationID(1);
        return new ResourcePropertiedObjectEditor(this.getConnection(), configID);
    }

    public SharedResource[] getResources() throws AuthorizationException, ExternalException {
        Collection r = this.readResources();
        SharedResource[] rd = new SharedResource[r.size()];
        Iterator it = r.iterator();
        int i = 0;
        while (it.hasNext()) {
            rd[i] = (SharedResource)it.next();
            ++i;
        }
        return rd;
    }

    private Collection readResources() throws AuthorizationException, ExternalException {
        ConfigurationAdminAPI capi = ModelManager.getConfigurationAPI(this.getConnection());
        Collection r = null;
        try {
            r = capi.getResources();
        }
        catch (AuthorizationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExternalException(ex);
        }
        return r;
    }

    private boolean containsPool(Collection pools, String poolName, String poolType) {
        boolean found = false;
        Iterator it = pools.iterator();
        while (!found && it.hasNext()) {
            String curPoolType;
            String curPoolName;
            Object obj = it.next();
            if (obj instanceof ResourceDescriptor) {
                ResourceDescriptor rd = (ResourceDescriptor)obj;
                curPoolName = rd.getName();
                curPoolType = rd.getComponentTypeID().getFullName();
            } else {
                PoolConfigTableRowData row = (PoolConfigTableRowData)obj;
                curPoolName = row.getPoolName();
                curPoolType = row.getPoolType();
            }
            if (!poolName.equals(curPoolName) || !poolType.equals(curPoolType)) continue;
            found = true;
        }
        return found;
    }
}

