/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.models;

import com.metamatrix.admin.AdminPlugin;
import com.metamatrix.admin.api.exception.security.InvalidSessionException;
import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.security.AuthorizationException;
import com.metamatrix.common.actions.ModificationActionQueue;
import com.metamatrix.common.config.api.ComponentObject;
import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.common.config.api.ComponentTypeDefn;
import com.metamatrix.common.config.api.ConfigurationID;
import com.metamatrix.common.config.api.ConfigurationObjectEditor;
import com.metamatrix.common.config.api.ResourceModel;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.common.config.model.BasicConfigurationObjectEditor;
import com.metamatrix.common.object.PropertiedObject;
import com.metamatrix.common.object.PropertyDefinition;
import com.metamatrix.common.object.PropertyDefinitionImpl;
import com.metamatrix.common.transaction.TransactionException;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.ConfigurationPropertiedObjectEditor;
import com.metamatrix.core.util.Assertion;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ResourcePropertiedObjectEditor
extends ConfigurationPropertiedObjectEditor {
    private ConfigurationID configID;
    private Map resources = new HashMap();
    private ConfigurationObjectEditor editor;

    ResourcePropertiedObjectEditor(ConnectionInfo connectionInfo, ConfigurationID configurationID) {
        super(connectionInfo);
        this.configID = configurationID;
    }

    ResourcePropertiedObjectEditor(ConnectionInfo connectionInfo, ConfigurationID configurationID, ModificationActionQueue destination) {
        super(connectionInfo, destination);
        this.configID = configurationID;
    }

    @Override
    protected ConfigurationObjectEditor getEditor() {
        if (this.editor == null) {
            this.editor = new BasicConfigurationObjectEditor(false);
        }
        return this.editor;
    }

    @Override
    public void begin() throws TransactionException {
    }

    @Override
    public void rollback() throws TransactionException {
    }

    @Override
    public List getAllowedValues(PropertiedObject obj, PropertyDefinition def) {
        this.assertComponentObject(obj);
        if (def == null) {
            Assertion.isNotNull((Object)def, (String)AdminPlugin.Util.getString("ERR.014.001.0018", new Object[]{"PropertyDefinition"}));
        }
        return def.getAllowedValues();
    }

    @Override
    public List getPropertyDefinitions(PropertiedObject obj) {
        ComponentObject componentObject = this.assertComponentObject(obj);
        ArrayList<Object> result = null;
        ComponentType type = ResourceModel.getComponentType((String)componentObject.getName());
        Iterator defns = type.getComponentTypeDefinitions().iterator();
        result = new ArrayList<Object>(type.getComponentTypeDefinitions().size());
        while (defns.hasNext()) {
            ComponentTypeDefn defn = (ComponentTypeDefn)defns.next();
            PropertyDefinition pd = defn.getPropertyDefinition();
            if (pd.isConstrainedToAllowedValues()) {
                if (defn.getFullName().equalsIgnoreCase("metamatrix.common.pooling.resource.name")) {
                    PropertyDefinitionImpl pDefn = new PropertyDefinitionImpl(pd);
                    pDefn.setAllowedValues(Collections.EMPTY_LIST);
                    result.add(pDefn);
                    continue;
                }
                result.add(pd);
                continue;
            }
            result.add(pd);
        }
        return result;
    }

    @Override
    public void setValue(PropertiedObject obj, PropertyDefinition def, Object value) {
        ComponentObject componentObject = this.assertComponentObject(obj);
        if (def == null) {
            Assertion.isNotNull((Object)def, (String)AdminPlugin.Util.getString("ERR.014.001.0018", new Object[]{"PropertyDefinition"}));
        }
        componentObject = this.getObject(componentObject);
        if (value == null) {
            componentObject = def.getDefaultValue() == null ? this.getEditor().removeProperty(componentObject, def.getName()) : this.getEditor().setProperty(componentObject, def.getName(), def.getDefaultValue().toString());
        } else {
            String stringValue = null;
            if (value instanceof Boolean) {
                Boolean bValue = (Boolean)value;
                stringValue = Boolean.toString(bValue);
                stringValue = stringValue.toLowerCase();
            } else {
                stringValue = (String)value;
            }
            componentObject = this.getEditor().setProperty(componentObject, def.getName(), stringValue);
        }
        this.storeObject(componentObject);
    }

    private ComponentObject getObject(ComponentObject object) {
        if (this.resources.containsKey(object.getID())) {
            return (ComponentObject)this.resources.get(object.getID());
        }
        this.storeObject(object);
        return object;
    }

    private void storeObject(ComponentObject object) {
        this.resources.put(object.getID(), object);
    }

    @Override
    public void commit() throws TransactionException {
    }

    public void apply() throws TransactionException {
        if (this.isAutomaticTransaction()) {
            try {
                ArrayList r = new ArrayList(this.resources.size());
                r.addAll(this.resources.values());
                this.getConfigurationAPI().saveResources(r);
            }
            catch (ConfigurationException e) {
                throw new TransactionException((Exception)((Object)e), "ERR.014.001.0047", AdminPlugin.Util.getString("ERR.014.001.0047"));
            }
            catch (InvalidSessionException e) {
                throw new TransactionException((Exception)((Object)e), "ERR.014.001.0031", AdminPlugin.Util.getString("ERR.014.001.0031"));
            }
            catch (AuthorizationException e) {
                throw new TransactionException((Exception)((Object)e), "ERR.014.001.0031", AdminPlugin.Util.getString("ERR.014.001.0031"));
            }
            catch (MetaMatrixComponentException e) {
                throw new TransactionException((Exception)((Object)e), "ERR.014.001.0031", AdminPlugin.Util.getString("ERR.014.001.0031"));
            }
        }
    }
}

