/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.models;

import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.Manager;
import com.metamatrix.console.models.ManagerListener;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.console.models.QueryManager;
import com.metamatrix.console.ui.util.property.PropertyProvider;
import com.metamatrix.console.util.ExternalException;
import com.metamatrix.platform.admin.api.RuntimeStateAdminAPI;
import com.metamatrix.platform.admin.api.runtime.HostData;
import com.metamatrix.platform.admin.api.runtime.PSCData;
import com.metamatrix.platform.admin.api.runtime.ProcessData;
import com.metamatrix.platform.admin.api.runtime.ServiceData;
import com.metamatrix.platform.admin.api.runtime.SystemState;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public final class RuntimeMgmtManager
extends Manager {
    private HashMap procPscMap = new HashMap();
    private PropertyProvider propProvider = new PropertyProvider("com/metamatrix/console/data/runtime_mgr");

    public RuntimeMgmtManager(ConnectionInfo connection) throws ExternalException {
        super(connection);
        this.refreshImpl();
    }

    public void bounceServer() throws ExternalException {
        this.refreshImpl();
        try {
            ConnectionInfo connection = this.getConnection();
            List qmListeners = ModelManager.getQueryManager(connection).getEventListeners();
            this.getAPI().bounceServer();
            ModelManager.removeConnection(connection);
            connection.relogin();
            this.refreshImpl();
            QueryManager qm = ModelManager.getQueryManager(connection);
            Iterator iter = qmListeners.iterator();
            while (iter.hasNext()) {
                qm.addManagerListener((ManagerListener)iter.next());
            }
        }
        catch (Exception theException) {
            theException.printStackTrace();
            throw new ExternalException(this.formatErrorMsg("bounceServer", theException), theException);
        }
    }

    private String formatErrorMsg(String theMethodName, Exception theException) {
        return this.formatErrorMsg(theMethodName, null, theException);
    }

    private String formatErrorMsg(String theMethodName, String theDetails, Exception theException) {
        return theException.getMessage() + " < RuntimeMgmtManager." + theMethodName + (theDetails == null ? "" : ":" + theDetails) + " >";
    }

    public Integer[] getPscCounts(ProcessData theProcess) {
        Integer[] counts = (Integer[])this.procPscMap.get(theProcess);
        if (counts == null) {
            int notRegistered = 0;
            int registered = 0;
            Collection pscs = theProcess.getPSCs();
            if (pscs != null && !pscs.isEmpty()) {
                Iterator itr = pscs.iterator();
                PSCData psc = (PSCData)itr.next();
                if (psc.isRegistered()) {
                    ++registered;
                } else {
                    ++notRegistered;
                }
            }
            counts = new Integer[]{new Integer(registered), new Integer(notRegistered)};
            this.procPscMap.put(theProcess, counts);
        }
        return counts;
    }

    public SystemState getServerState() throws ExternalException {
        this.refreshImpl();
        try {
            return this.getAPI().getSystemState();
        }
        catch (Exception theException) {
            theException.printStackTrace();
            throw new ExternalException(this.formatErrorMsg("getServerState", theException), theException);
        }
    }

    private boolean isNotRegistered(ServiceData theService) {
        return theService.getCurrentState() == 5;
    }

    public boolean isServiceInSystemState(String serviceName) throws ExternalException {
        try {
            SystemState state = this.getServerState();
            Collection hosts = state.getHosts();
            if (hosts != null && !hosts.isEmpty()) {
                for (HostData host : hosts) {
                    Collection procs = host.getProcesses();
                    if (procs == null || procs.isEmpty()) continue;
                    for (ProcessData process : procs) {
                        Collection pscs = process.getPSCs();
                        if (pscs == null || pscs.isEmpty()) continue;
                        for (PSCData psc : pscs) {
                            Collection services = psc.getServices();
                            if (services == null || services.isEmpty()) continue;
                            for (ServiceData service : services) {
                                if (!service.getComponentDefnID().getName().equalsIgnoreCase(serviceName) || service.getCurrentState() != 1) continue;
                                return true;
                            }
                        }
                    }
                }
            }
        }
        catch (Exception theException) {
            theException.printStackTrace();
            throw new ExternalException(this.formatErrorMsg("getHostNamesWhereServiceiSRunning", theException), theException);
        }
        return false;
    }

    public void refreshImpl() throws ExternalException {
        this.procPscMap.clear();
    }

    public void shutdownServer() throws ExternalException {
        this.refreshImpl();
        try {
            this.getAPI().shutdownServer();
        }
        catch (Exception theException) {
            theException.printStackTrace();
            throw new ExternalException(this.formatErrorMsg("shutdownServer", theException), theException);
        }
    }

    public void startHost(HostData theHost) throws ExternalException {
        this.refreshImpl();
        try {
            this.getAPI().startHost(theHost.getName());
        }
        catch (Exception theException) {
            theException.printStackTrace();
            throw new ExternalException(this.formatErrorMsg("startHost", "host=" + theHost, theException), theException);
        }
    }

    public void startProcess(ProcessData theProcess) throws ExternalException {
        this.refreshImpl();
        try {
            this.getAPI().startProcess(theProcess.getHostName(), theProcess.getName());
        }
        catch (Exception theException) {
            theException.printStackTrace();
            throw new ExternalException(this.formatErrorMsg("startProcess", "process=" + theProcess, theException), theException);
        }
    }

    public void startPsc(PSCData thePsc) throws ExternalException {
        this.refreshImpl();
        try {
            this.getAPI().startPSC(thePsc.getPscID());
        }
        catch (Exception theException) {
            theException.printStackTrace();
            throw new ExternalException(this.formatErrorMsg("startPsc", "psc=" + thePsc, theException), theException);
        }
    }

    public void startService(ServiceData theService) throws ExternalException {
        this.refreshImpl();
        try {
            this.getAPI().restartService(theService.getServiceID());
        }
        catch (Exception theException) {
            theException.printStackTrace();
            throw new ExternalException(this.formatErrorMsg("startService", "service=" + theService, theException), theException);
        }
    }

    public void stopHost(HostData theHost) throws ExternalException {
        this.refreshImpl();
        try {
            this.getAPI().stopHost(theHost.getName());
        }
        catch (Exception theException) {
            theException.printStackTrace();
        }
    }

    public void stopHostNow(HostData theHost) throws ExternalException {
        this.refreshImpl();
        try {
            this.getAPI().stopHostNow(theHost.getName());
        }
        catch (Exception theException) {
            theException.printStackTrace();
        }
    }

    public void stopProcess(ProcessData theProcess) throws ExternalException {
        this.refreshImpl();
        try {
            this.getAPI().stopProcess(theProcess.getHostName(), theProcess.getName(), true);
        }
        catch (Exception theException) {
            theException.printStackTrace();
        }
    }

    public void stopProcessNow(ProcessData theProcess) throws ExternalException {
        this.refreshImpl();
        try {
            this.getAPI().stopProcess(theProcess.getHostName(), theProcess.getName(), true);
        }
        catch (Exception theException) {
            theException.printStackTrace();
        }
    }

    public void stopPsc(PSCData thePsc) throws ExternalException {
        this.refreshImpl();
        try {
            this.getAPI().stopPSC(thePsc.getPscID());
        }
        catch (Exception theException) {
            theException.printStackTrace();
            throw new ExternalException(this.formatErrorMsg("stopPsc", "psc=" + thePsc, theException), theException);
        }
    }

    public void stopPscNow(PSCData thePsc) throws ExternalException {
        this.refreshImpl();
        try {
            this.getAPI().stopPSCNow(thePsc.getPscID());
        }
        catch (Exception theException) {
            theException.printStackTrace();
            throw new ExternalException(this.formatErrorMsg("stopPscNow", "psc=" + thePsc, theException), theException);
        }
    }

    public void stopService(ServiceData theService) throws ExternalException {
        this.refreshImpl();
        try {
            this.getAPI().stopService(theService.getServiceID());
        }
        catch (Exception theException) {
            theException.printStackTrace();
            throw new ExternalException(this.formatErrorMsg("stopService", "service=" + theService, theException), theException);
        }
    }

    public void stopServiceNow(ServiceData theService) throws ExternalException {
        this.refreshImpl();
        try {
            this.getAPI().stopServiceNow(theService.getServiceID());
        }
        catch (Exception theException) {
            theException.printStackTrace();
            throw new ExternalException(this.formatErrorMsg("stopServiceNow", "service=" + theService, theException), theException);
        }
    }

    public synchronized void synchronizeServer() throws ExternalException {
        this.refreshImpl();
        try {
            this.getAPI().synchronizeServer();
            int synchLoop = 0;
            int LOOPS = this.propProvider.getInt("synch.maxduration.sec", 20);
            int DURATION = 1000 * this.propProvider.getInt("synch.sleep.sec", 1);
            boolean synching = true;
            while (synching && synchLoop < LOOPS) {
                ++synchLoop;
                synching = false;
                SystemState state = this.getServerState();
                Collection hosts = state.getHosts();
                if (hosts != null && !hosts.isEmpty()) {
                    block5: for (HostData host : hosts) {
                        Collection procs = host.getProcesses();
                        if (procs == null || procs.isEmpty()) continue;
                        for (ProcessData process : procs) {
                            Collection pscs = process.getPSCs();
                            if (pscs == null || pscs.isEmpty()) continue;
                            for (PSCData psc : pscs) {
                                Collection services = psc.getServices();
                                if (services == null || services.isEmpty()) continue;
                                for (ServiceData service : services) {
                                    if (!this.isNotRegistered(service)) continue;
                                    synching = true;
                                    break block5;
                                }
                            }
                        }
                    }
                }
                if (!synching) continue;
                try {
                    Thread.sleep(DURATION);
                }
                catch (InterruptedException theException) {}
            }
        }
        catch (Exception theException) {
            theException.printStackTrace();
            throw new ExternalException(this.formatErrorMsg("synchronizeServer", theException), theException);
        }
    }

    private RuntimeStateAdminAPI getAPI(boolean reconnect) {
        return ModelManager.getRuntimeStateAPI(this.getConnection(reconnect));
    }

    private RuntimeStateAdminAPI getAPI() {
        return this.getAPI(true);
    }
}

