/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.models;

import com.metamatrix.api.exception.security.AuthorizationException;
import com.metamatrix.common.actions.ModificationActionQueue;
import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ConfigurationObjectEditor;
import com.metamatrix.common.log.LogConfiguration;
import com.metamatrix.common.util.LogContextsUtil;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.console.models.TimedManager;
import com.metamatrix.console.util.ExternalException;
import com.metamatrix.core.log.MessageLevel;
import com.metamatrix.platform.admin.api.ConfigurationAdminAPI;
import com.metamatrix.platform.admin.api.RuntimeStateAdminAPI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class ServerLogManager
extends TimedManager {
    private String[] messageLevelDisplayNames = null;
    private Set allContexts = null;

    public ServerLogManager(ConnectionInfo connection) {
        super(connection);
        super.init();
    }

    @Override
    public void init() {
        super.init();
    }

    public Set getAllContexts() {
        if (this.allContexts == null) {
            this.allContexts = new TreeSet(LogContextsUtil.ALL_CONTEXTS);
        }
        return this.allContexts;
    }

    private Configuration getConfigurationForIndex(int index) throws AuthorizationException, ExternalException {
        Configuration config = null;
        try {
            switch (index) {
                case 1: {
                    config = this.getConfigAPI().getStartupConfiguration();
                    break;
                }
                case 0: {
                    config = this.getConfigAPI().getNextStartupConfiguration();
                }
            }
        }
        catch (AuthorizationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExternalException("Error retrieving configuration.", ex);
        }
        return config;
    }

    private Collection convertDiscardedToReported(Collection discardedContexts) {
        int totalContextsCount = this.allContexts.size();
        ArrayList allContextsCopy = new ArrayList(totalContextsCount);
        Iterator it = this.allContexts.iterator();
        while (it.hasNext()) {
            allContextsCopy.add(it.next());
        }
        for (int i = totalContextsCount - 1; i >= 0; --i) {
            String curContext = (String)allContextsCopy.get(i);
            if (!discardedContexts.contains(curContext)) continue;
            allContextsCopy.remove(i);
        }
        return allContextsCopy;
    }

    public Collection getContextsForConfigurationIndex(int index) throws AuthorizationException, ExternalException {
        Configuration config = this.getConfigurationForIndex(index);
        LogConfiguration logConfig = config.getLogConfiguration();
        Set discardedContexts = logConfig.getDiscardedContexts();
        Collection reportedContexts = this.convertDiscardedToReported(discardedContexts);
        return reportedContexts;
    }

    public void setContextsForConfigurationIndex(int index, Collection contexts) throws AuthorizationException, ExternalException {
        Configuration config = this.getConfigurationForIndex(index);
        LogConfiguration logConfig = config.getLogConfiguration();
        logConfig.discardContexts((Collection)this.allContexts);
        logConfig.recordContexts(contexts);
        ConfigurationObjectEditor coe = null;
        try {
            coe = this.getConfigAPI().createEditor();
            coe.setLogConfiguration(config, logConfig);
            ModificationActionQueue maq = coe.getDestination();
            List actions = maq.popActions();
            this.getRuntimeAPI().setLoggingConfiguration(config, logConfig, actions);
        }
        catch (AuthorizationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExternalException(ex);
        }
    }

    public int getLoggingLevelForConfigurationIndex(int index) throws AuthorizationException, ExternalException {
        Configuration config = this.getConfigurationForIndex(index);
        LogConfiguration logConfig = config.getLogConfiguration();
        int level = logConfig.getMessageLevel();
        return level;
    }

    public void setLoggingLevelForConfigurationIndex(int index, int level) throws AuthorizationException, ExternalException {
        Configuration config = this.getConfigurationForIndex(index);
        LogConfiguration logConfig = config.getLogConfiguration();
        logConfig.setMessageLevel(level);
        ConfigurationObjectEditor coe = null;
        try {
            coe = this.getConfigAPI().createEditor();
            coe.setLogConfiguration(config, logConfig);
            ModificationActionQueue maq = coe.getDestination();
            List actions = maq.popActions();
            this.getRuntimeAPI().setLoggingConfiguration(config, logConfig, actions);
        }
        catch (AuthorizationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExternalException(ex);
        }
    }

    public String[] getMessageLevelDisplayNames() {
        if (this.messageLevelDisplayNames == null) {
            Collection displayNames = MessageLevel.getDisplayNames();
            this.messageLevelDisplayNames = new String[displayNames.size()];
            Iterator it = displayNames.iterator();
            int i = 0;
            while (it.hasNext()) {
                this.messageLevelDisplayNames[i] = (String)it.next();
                ++i;
            }
        }
        return this.messageLevelDisplayNames;
    }

    public List getLogEntries(Date startTime, Date endTime, List levels, List contexts, int maxRows) throws AuthorizationException, ExternalException {
        try {
            return this.getRuntimeAPI().getLogEntries(startTime, endTime, levels, contexts, maxRows);
        }
        catch (AuthorizationException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new ExternalException(e);
        }
    }

    private ConfigurationAdminAPI getConfigAPI() {
        return ModelManager.getConfigurationAPI(this.getConnection());
    }

    private RuntimeStateAdminAPI getRuntimeAPI() {
        return ModelManager.getRuntimeStateAPI(this.getConnection());
    }
}

