/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.models;

import com.metamatrix.api.exception.ComponentNotFoundException;
import com.metamatrix.api.exception.security.AuthorizationException;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.console.models.TimedManager;
import com.metamatrix.console.ui.ViewManager;
import com.metamatrix.console.util.ExternalException;
import com.metamatrix.platform.security.api.MetaMatrixSessionID;
import com.metamatrix.platform.security.api.MetaMatrixSessionInfo;
import java.util.Collection;

public class SessionManager
extends TimedManager {
    public static final String SESSION_TERMINATED = "A Session was terminated.";

    public SessionManager(ConnectionInfo connection) {
        super(connection);
    }

    @Override
    public void init() {
        super.init();
        super.setRefreshRate(10);
        this.setIsStale(true);
        super.setIsAutoRefreshEnabled(false);
    }

    public Collection getActiveSessions() throws Exception {
        Collection result = null;
        result = ModelManager.getSessionAPI(this.getConnection()).getActiveSessions();
        return result;
    }

    public void terminateSession(MetaMatrixSessionInfo userSessionInfo) throws ExternalException, AuthorizationException, ComponentNotFoundException {
        try {
            ViewManager.startBusy();
            ModelManager.getSessionAPI(this.getConnection()).terminateSession(userSessionInfo.getSessionID());
        }
        catch (ComponentNotFoundException e) {
            throw e;
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExternalException(e);
        }
        finally {
            ViewManager.endBusy();
        }
        super.fireModelChangedEvent(SESSION_TERMINATED, userSessionInfo.getSessionToken());
    }

    public Collection getSessions() throws Exception {
        return this.getActiveSessions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSignedOnUserSessionValid() {
        Boolean BIsValid = Boolean.FALSE;
        try {
            ViewManager.startBusy();
            MetaMatrixSessionID mmsidSessionID = this.getConnection().getServerConnection().getLogonResult().getSessionID();
            BIsValid = ModelManager.getSessionAPI(this.getConnection()).isSessionValid(mmsidSessionID);
        }
        catch (Exception exception) {
        }
        finally {
            ViewManager.endBusy();
        }
        return BIsValid;
    }
}

