/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.models;

import com.metamatrix.api.exception.security.AuthorizationException;
import com.metamatrix.common.config.api.Host;
import com.metamatrix.common.config.api.HostID;
import com.metamatrix.common.config.api.ReleaseInfo;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.console.models.TimedManager;
import com.metamatrix.console.ui.views.summary.SummaryConnectionInfo;
import com.metamatrix.console.ui.views.summary.SummaryHostInfo;
import com.metamatrix.console.ui.views.summary.SummaryInfoProvider;
import com.metamatrix.console.util.ExternalException;
import com.metamatrix.platform.admin.api.RuntimeStateAdminAPI;
import com.metamatrix.platform.admin.api.runtime.HostData;
import com.metamatrix.platform.admin.api.runtime.SystemState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;

public class SummaryManager
extends TimedManager
implements SummaryInfoProvider {
    private Date systemStartUpTime = null;

    public SummaryManager(ConnectionInfo connection) {
        super(connection);
        super.init();
    }

    @Override
    public void init() {
        super.init();
    }

    public String getSysURL() throws ExternalException {
        return this.getConnection().getURL();
    }

    @Override
    public String getSystemName() throws Exception {
        return this.getConnection().getClusterName();
    }

    @Override
    public String getSystemURL() throws Exception {
        String serverName = "";
        return serverName;
    }

    @Override
    public int getSystemState() throws Exception {
        RuntimeStateAdminAPI api = ModelManager.getRuntimeStateAPI(this.getConnection());
        int state = 1;
        if (!api.isSystemStarted()) {
            state = 3;
        } else if (api.getSystemState().hasFailedService()) {
            state = 2;
        }
        return state;
    }

    @Override
    public Date getSystemStartUpTime() throws Exception {
        RuntimeStateAdminAPI runtimeState = ModelManager.getRuntimeStateAPI(this.getConnection());
        this.systemStartUpTime = runtimeState.getServerStartTime();
        return this.systemStartUpTime;
    }

    @Override
    public int getActiveSessionCount() throws Exception {
        return ModelManager.getSessionAPI(this.getConnection()).getActiveSessionsCount();
    }

    @Override
    public SummaryHostInfo[] getHostInfo() throws Exception {
        SystemState state = ModelManager.getRuntimeStateAPI(this.getConnection()).getSystemState();
        Collection hostDataColl = state.getHosts();
        Iterator it = hostDataColl.iterator();
        HostData[] hostData = new HostData[hostDataColl.size()];
        int i = 0;
        while (it.hasNext()) {
            hostData[i] = (HostData)it.next();
            ++i;
        }
        Collection hosts = this.getHosts();
        SummaryHostInfo[] info = new SummaryHostInfo[hosts.size()];
        it = hosts.iterator();
        int i2 = 0;
        while (it.hasNext()) {
            Host curHost = (Host)it.next();
            info[i2] = new SummaryHostInfo(curHost.getName(), this.hostStatus(curHost.getName(), hostData));
            ++i2;
        }
        return info;
    }

    @Override
    public SummaryConnectionInfo[] getConnectionInfo() throws Exception {
        Collection products = ModelManager.getConfigurationAPI(this.getConnection()).getProducts();
        ArrayList<SummaryConnectionInfo> sum = new ArrayList<SummaryConnectionInfo>(5);
        for (ReleaseInfo ri : products) {
            String productName = ri.getName();
            if (productName.equals("Platform") || productName.equals("Connectors")) continue;
            SummaryConnectionInfo sci = new SummaryConnectionInfo(productName, ModelManager.getSessionAPI(this.getConnection()).getActiveConnectionsCountForProduct(productName));
            sum.add(sci);
        }
        SummaryConnectionInfo[] summaryInfo = new SummaryConnectionInfo[sum.size()];
        Iterator it = sum.iterator();
        int i = 0;
        while (it.hasNext()) {
            summaryInfo[i] = (SummaryConnectionInfo)it.next();
            ++i;
        }
        return summaryInfo;
    }

    public Collection getHostName() throws AuthorizationException, ExternalException {
        Collection hostList = null;
        try {
            hostList = this.getHosts();
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExternalException(e);
        }
        return hostList;
    }

    public Collection getHosts() throws Exception {
        HashSet<Host> hosts = new HashSet<Host>();
        Iterator itDeployedHostIDs = ModelManager.getConfigurationAPI(this.getConnection()).getCurrentConfiguration().getHostIDs().iterator();
        Host host = null;
        HostID hostID = null;
        while (itDeployedHostIDs.hasNext()) {
            hostID = (HostID)itDeployedHostIDs.next();
            host = ModelManager.getConfigurationAPI(this.getConnection()).getHost(hostID);
            hosts.add(host);
        }
        return hosts;
    }

    @Override
    public ReleaseInfo[] getProductReleaseInfo() throws Exception {
        Collection products = ModelManager.getConfigurationAPI(this.getConnection()).getProducts();
        ReleaseInfo[] ri = new ReleaseInfo[products.size()];
        Iterator it = products.iterator();
        int i = 0;
        while (it.hasNext()) {
            ri[i] = (ReleaseInfo)it.next();
            ++i;
        }
        return ri;
    }

    private int hostStatus(String hostName, HostData[] hostData) {
        int status;
        int loc = -1;
        int i = 0;
        while (i < hostData.length && loc < 0) {
            if (hostName.equalsIgnoreCase(hostData[i].getName())) {
                loc = i;
                continue;
            }
            ++i;
        }
        if (loc < 0) {
            LogManager.logError((String)"SUMMARY", (String)("Host Identifier " + hostName + " found in configuration but " + "not found in runtime state."));
            status = 2;
        } else {
            status = hostData[loc].isRegistered() ? 1 : 2;
        }
        return status;
    }
}

