/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.models;

import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.Manager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;

public abstract class TimedManager
extends Manager
implements ActionListener {
    public static final int DEFAULT_DELAY = 60;
    private Timer timer;
    private int refreshRate;
    private boolean isAutoRefreshEnabled;
    private boolean busy = false;

    public TimedManager(ConnectionInfo connection) {
        this(connection, 60, true);
    }

    public TimedManager(ConnectionInfo connection, int refreshRateSeconds) {
        this(connection, refreshRateSeconds, true);
    }

    public TimedManager(ConnectionInfo connection, int refreshRateSeconds, boolean isAutoRefreshEnabled) {
        super(connection);
        this.setRefreshRate(refreshRateSeconds);
        this.setIsAutoRefreshEnabled(isAutoRefreshEnabled);
    }

    @Override
    public void init() {
        super.init();
        this.setTimer(new Timer(this.getRefreshRate() * 1000, this));
    }

    public void startTimer() {
        if (!this.getTimer().isRunning() && this.getIsAutoRefreshEnabled()) {
            this.getTimer().start();
        }
    }

    public void refresh(boolean setIsStale) {
        this.getTimer().stop();
        if (setIsStale) {
            super.refresh();
        }
    }

    @Override
    public void refresh() {
        this.refresh(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isBusy()) {
            this.refresh();
        }
    }

    public int getRefreshRate() {
        return this.refreshRate;
    }

    public void setRefreshRate(int seconds) {
        this.refreshRate = seconds;
        boolean started = false;
        if (this.getTimer() != null) {
            this.getTimer().removeActionListener(this);
            if (this.getTimer().isRunning()) {
                started = true;
            }
        }
        this.setTimer(new Timer(this.getRefreshRate() * 1000, this));
        if (started) {
            this.startTimer();
        }
    }

    public boolean getIsAutoRefreshEnabled() {
        return this.isAutoRefreshEnabled;
    }

    public void setIsAutoRefreshEnabled(boolean isAutoRefreshEnabled) {
        this.isAutoRefreshEnabled = isAutoRefreshEnabled;
        if (!isAutoRefreshEnabled && this.getTimer() != null && this.getTimer().isRunning()) {
            this.getTimer().stop();
        }
        if (isAutoRefreshEnabled && this.getTimer() != null) {
            this.startTimer();
        }
    }

    protected Timer getTimer() {
        return this.timer;
    }

    private void setTimer(Timer timer) {
        if (this.timer != null) {
            this.timer.removeActionListener(this);
        }
        this.timer = timer;
    }

    public boolean isBusy() {
        return this.busy;
    }

    public synchronized void setBusy(boolean busy) {
        this.busy = busy;
    }
}

