/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.models;

import com.metamatrix.api.exception.ComponentNotFoundException;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.xa.TransactionID;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.console.models.TimedManager;
import com.metamatrix.console.ui.views.transactions.TransactionTableModel;
import com.metamatrix.console.util.RuntimeExternalException;
import com.metamatrix.server.admin.api.TransactionAdminAPI;
import java.util.Collection;

public class TransactionManager
extends TimedManager {
    private TransactionAdminAPI transAPI;
    private TransactionTableModel tableModel;

    public TransactionManager(ConnectionInfo connection) {
        super(connection);
        super.init();
        this.transAPI = ModelManager.getTransactionAPI(this.getConnection());
        this.tableModel = new TransactionTableModel();
    }

    public TransactionTableModel getTableModel() {
        return this.tableModel;
    }

    @Override
    public void refresh() {
        this.refreshTableModel();
    }

    public void refreshTableModel() {
        super.refresh(false);
        Collection tx = null;
        try {
            tx = this.transAPI.getAllTransactions();
        }
        catch (ComponentNotFoundException ex) {
            LogManager.logError((String)"TRANSACTIONS", (Throwable)ex, (String)"Error retrieving list of transactions.  Transaction Service may not be running.");
            throw new RuntimeExternalException((Exception)((Object)ex));
        }
        catch (Exception ex) {
            LogManager.logError((String)"TRANSACTIONS", (Throwable)ex, (String)"Error retrieving list of transactions.");
            throw new RuntimeExternalException(ex);
        }
        this.tableModel.resetFromTransactionsList(tx);
    }

    public TransactionID transactionIDForTransactionNum(Long transactionNum) {
        return this.tableModel.transactionIDForTransactionNum(transactionNum);
    }
}

