/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.models;

import com.metamatrix.admin.api.server.ServerAdmin;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.tree.TreeView;
import com.metamatrix.common.vdb.api.ModelInfo;
import com.metamatrix.common.vdb.api.VDBArchive;
import com.metamatrix.common.vdb.api.VDBDefn;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.Manager;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.console.security.UserCapabilities;
import com.metamatrix.console.ui.views.deploy.util.DeployPkgUtils;
import com.metamatrix.console.ui.views.vdb.WSDLOperationsDescription;
import com.metamatrix.console.util.StaticProperties;
import com.metamatrix.core.util.FileUtils;
import com.metamatrix.metadata.runtime.api.Model;
import com.metamatrix.metadata.runtime.api.VirtualDatabase;
import com.metamatrix.metadata.runtime.api.VirtualDatabaseID;
import com.metamatrix.platform.admin.api.EntitlementMigrationReport;
import com.metamatrix.platform.admin.api.PermissionDataNode;
import com.metamatrix.platform.admin.api.PermissionDataNodeTreeView;
import com.metamatrix.platform.admin.api.PermissionNode;
import com.metamatrix.platform.admin.apiimpl.PermissionDataNodeTreeViewImpl;
import com.metamatrix.platform.security.api.AuthorizationRealm;
import com.metamatrix.server.admin.api.MaterializationLoadScripts;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class VdbManager
extends Manager {
    public VdbManager(ConnectionInfo connection) {
        super(connection);
    }

    public boolean hasAnyModels(TreeView treeView) {
        return true;
    }

    public Collection getVDBs() throws Exception {
        Collection colVdbs = ModelManager.getRuntimeMetadataAPI(this.getConnection()).getVirtualDatabases();
        return colVdbs;
    }

    public VirtualDatabase getVirtualDatabase(VirtualDatabaseID vdbID) throws Exception {
        VirtualDatabase vdb = ModelManager.getRuntimeMetadataAPI(this.getConnection()).getVirtualDatabase(vdbID);
        return vdb;
    }

    public Collection getVdbModels(VirtualDatabaseID vdbID) throws Exception {
        Collection colModels = ModelManager.getRuntimeMetadataAPI(this.getConnection()).getVDBModels(vdbID);
        return colModels;
    }

    public Boolean isVDBActive(String vdbName, int vdbVersion) throws Exception {
        Boolean response = null;
        Collection vdbs = null;
        vdbs = this.getVDBs();
        Iterator it = vdbs.iterator();
        while (it.hasNext() && response == null) {
            VirtualDatabaseID id;
            String versStr;
            int vers;
            VirtualDatabase vdb = (VirtualDatabase)it.next();
            String name = vdb.getName();
            if (!name.equals(vdbName) || (vers = new Integer(versStr = (id = (VirtualDatabaseID)vdb.getID()).getVersion()).intValue()) != vdbVersion) continue;
            short status = vdb.getStatus();
            response = new Boolean(status == 3 || status == 3);
        }
        return response;
    }

    public void updateVirtualDatabase(VirtualDatabase vdb) throws Exception {
        ModelManager.getRuntimeMetadataAPI(this.getConnection()).updateVirtualDatabase(vdb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean vdbHasDataRoles(VirtualDatabaseID vid) throws Exception {
        boolean hasDataRoles = false;
        byte[] vdbStream = ModelManager.getRuntimeMetadataAPI(this.getConnection()).getVDB(vid);
        VDBArchive vdbArchive = null;
        try {
            vdbArchive = new VDBArchive((InputStream)new ByteArrayInputStream(vdbStream));
            hasDataRoles = vdbArchive.getDataRoles() != null;
        }
        finally {
            if (vdbArchive != null) {
                vdbArchive.close();
            }
        }
        return hasDataRoles;
    }

    public void setConnectorBindingNames(VirtualDatabaseID vdbId, Map mapModelsToConnBinds) throws Exception {
        ModelManager.getRuntimeMetadataAPI(this.getConnection()).setConnectorBindingNames(vdbId, mapModelsToConnBinds);
    }

    public Map migrateConnectorBindingNames(VirtualDatabase vdbSourceVdb, VDBDefn vdb) throws Exception {
        Map mapModelsToBindings = ModelManager.getRuntimeMetadataAPI(this.getConnection()).migrateConnectorBindingNames(vdbSourceVdb, vdb);
        return mapModelsToBindings;
    }

    public Collection getVDBsForConnectorBinding(String routingID) throws Exception {
        if (routingID == null) {
            throw new Exception("Routing ID is NULL!");
        }
        Collection colVdbs = ModelManager.getRuntimeMetadataAPI(this.getConnection()).getVDBsForConnectorBinding(routingID);
        return colVdbs;
    }

    public void setVDBState(VirtualDatabaseID vdbID, short siState) throws Exception {
        ModelManager.getRuntimeMetadataAPI(this.getConnection()).setVDBState(vdbID, siState);
    }

    public void markVDBForDelete(VirtualDatabaseID vdbID) throws Exception {
        ModelManager.getRuntimeMetadataAPI(this.getConnection()).markVDBForDelete(vdbID);
    }

    public EntitlementMigrationReport migrateEntitlements(VirtualDatabase vdbSource, VirtualDatabase vdbTarget) throws Exception {
        EntitlementMigrationReport emrMigrateReport = ModelManager.getRuntimeMetadataAPI(this.getConnection()).migrateEntitlements(vdbSource, vdbTarget);
        return emrMigrateReport;
    }

    public EntitlementMigrationReport importEntitlements(VirtualDatabase vdbSource, char[] dataRoleContents, boolean overwriteExisting) throws Exception {
        EntitlementMigrationReport emrMigrateReport = ModelManager.getRuntimeMetadataAPI(this.getConnection()).migrateEntitlements(vdbSource, dataRoleContents, overwriteExisting);
        return emrMigrateReport;
    }

    public boolean modelSuppressed(String sModelName) {
        return false;
    }

    public boolean vdbSuppressed(String sVdbName) {
        return false;
    }

    public String getVdbStatusAsString(short siStatus) {
        String sStatus = "Unknown";
        if (siStatus == 3) {
            sStatus = "Active";
        } else if (siStatus == 2) {
            sStatus = "Inactive";
        } else if (siStatus == 4) {
            sStatus = "Deleted";
        } else if (siStatus == 1) {
            sStatus = "Incomplete";
        } else if (siStatus == 3) {
            sStatus = "Active (Default)";
        }
        return sStatus;
    }

    public Collection getVdbEntitlements(VirtualDatabaseID vdbID) throws Exception {
        AuthorizationRealm realm = new AuthorizationRealm(vdbID.getName(), vdbID.getVersion());
        Collection colEntitlementIDs = ModelManager.getAuthorizationAPI(this.getConnection()).getPolicyIDsInRealm(realm);
        return colEntitlementIDs;
    }

    public PermissionDataNodeTreeView getTreeViewForVDB(String vdbName, String vdbVersion) throws Exception {
        PermissionDataNode root = ModelManager.getRuntimeMetadataAPI(this.getConnection()).getDataNodes(vdbName, vdbVersion);
        PermissionDataNodeTreeViewImpl treeView = new PermissionDataNodeTreeViewImpl((PermissionNode)root);
        return treeView;
    }

    public int getHighestNumberedVDBVersion(String vdbName) throws Exception {
        int highest = -1;
        VirtualDatabase vdb = this.getLatestVDBVersion(vdbName);
        if (vdb != null) {
            VirtualDatabaseID id = (VirtualDatabaseID)vdb.getID();
            String curVersionStr = id.getVersion();
            highest = new Integer(curVersionStr);
        }
        return highest;
    }

    public VirtualDatabase getLatestVDBVersion(String vdbName) throws Exception {
        try {
            return ModelManager.getRuntimeMetadataAPI(this.getConnection()).getLatestVirtualDatabase(vdbName);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Object[] importVDB(VDBArchive vdbArchive, boolean importRoles) throws Exception {
        Object[] result = new Object[2];
        VirtualDatabase vdb = ModelManager.getRuntimeMetadataAPI(this.getConnection()).importVDB(VDBArchive.writeToByteArray((VDBArchive)vdbArchive));
        EntitlementMigrationReport entReport = null;
        if (importRoles && vdbArchive.getDataRoles() != null) {
            entReport = this.importEntitlements(vdb, vdbArchive.getDataRoles(), true);
        }
        result[0] = vdb;
        result[1] = entReport;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportVDB(VirtualDatabase vdb, String vdbFileName, String parentDir) throws Exception {
        VirtualDatabaseID vid = (VirtualDatabaseID)vdb.getID();
        byte[] vdbStream = ModelManager.getRuntimeMetadataAPI(this.getConnection()).getVDB(vid);
        Properties headerProps = new Properties();
        String userName = UserCapabilities.getLoggedInUser(this.getConnection()).getName();
        String version = StaticProperties.getVersion();
        headerProps.put("ApplicationCreatedBy", DeployPkgUtils.getString("dmp.console.name"));
        headerProps.put("ApplicationVersion", version);
        headerProps.put("UserCreatedBy", userName);
        File archiveFile = null;
        archiveFile = parentDir != null ? new File(parentDir, vdbFileName) : new File(vdbFileName);
        ServerAdmin admin = this.getConnection().getServerAdmin();
        char[] rolesContent = admin.exportDataRoles(vid.getName(), vid.getVersion());
        VDBArchive vdbArchive = null;
        try {
            vdbArchive = new VDBArchive((InputStream)new ByteArrayInputStream(vdbStream));
            vdbArchive.updateRoles(rolesContent);
            vdbArchive.getConfigurationDef().setHeaderProperties(headerProps);
            FileUtils.write((InputStream)vdbArchive.getInputStream(), (File)archiveFile);
        }
        finally {
            if (vdbArchive != null) {
                vdbArchive.close();
            }
        }
    }

    public WSDLOperationsDescription getWSDLOperationsDescription(VirtualDatabase vdb) {
        WSDLOperationsDescription opsDesc = null;
        if (vdb.hasWSDLDefined()) {
            opsDesc = new WSDLOperationsDescription(vdb);
        }
        return opsDesc;
    }

    public ModelInfo getMaterializationTableModel(VDBDefn vdb) {
        ModelInfo model = null;
        Collection models = vdb.getModels();
        Iterator it = models.iterator();
        while (model == null && it.hasNext()) {
            ModelInfo curModel = (ModelInfo)it.next();
            if (!curModel.isMaterialization()) continue;
            model = curModel;
        }
        return model;
    }

    public MaterializationLoadScripts getMaterializationScripts(ConnectorBinding materializationConnector, VDBDefn vdb, String mmHost, String mmPort, String materializationUserName, String materializationUserPwd, String metamatrixUserName, String metamatrixUserPwd) throws Exception {
        return ModelManager.getRuntimeMetadataAPI(this.getConnection()).getMaterializationScripts(materializationConnector, vdb, mmHost, mmPort, materializationUserName, materializationUserPwd, metamatrixUserName, metamatrixUserPwd);
    }

    public boolean hasMaterializationModels(VirtualDatabase virtualDatabase) throws Exception {
        Collection models = this.getVdbModels(virtualDatabase.getVirtualDatabaseID());
        for (Model model : models) {
            if (!model.isMaterialization()) continue;
            return true;
        }
        return false;
    }
}

