/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.security;

import com.metamatrix.admin.api.exception.security.InvalidSessionException;
import com.metamatrix.admin.api.exception.security.MetaMatrixSecurityException;
import com.metamatrix.api.exception.ComponentNotFoundException;
import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.security.AuthorizationException;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.models.ModelManager;
import com.metamatrix.console.security.Roles;
import com.metamatrix.console.ui.views.users.RoleDisplay;
import com.metamatrix.console.util.ExternalException;
import com.metamatrix.platform.security.api.MetaMatrixPrincipal;
import com.metamatrix.platform.security.api.MetaMatrixPrincipalName;
import com.metamatrix.platform.security.api.MetaMatrixSessionID;
import java.util.HashMap;
import java.util.Map;

public class UserCapabilities {
    private static UserCapabilities theInstance;
    private Map rolesMap = new HashMap();

    public static UserCapabilities getInstance() {
        return theInstance;
    }

    public static UserCapabilities createInstance() throws AuthorizationException, ComponentNotFoundException, MetaMatrixSecurityException, MetaMatrixComponentException, ExternalException {
        theInstance = new UserCapabilities();
        return theInstance;
    }

    private UserCapabilities() {
    }

    public void init(ConnectionInfo conn) throws IllegalArgumentException, ComponentNotFoundException, AuthorizationException, InvalidSessionException, MetaMatrixSecurityException, MetaMatrixComponentException, ExternalException {
        boolean systemAdmin = false;
        boolean systemAdminMMS = false;
        boolean viewOnly = false;
        MetaMatrixSessionID mmsidSessionID = conn.getSessionID();
        MetaMatrixPrincipal mmpPrincipal = ModelManager.getSessionAPI(conn).getPrincipal(mmsidSessionID);
        RoleDisplay[] rd = ModelManager.getGroupsManager(conn).getRolesForPrincipal(mmpPrincipal, true);
        for (int i = 0; i < rd.length; ++i) {
            String sRole = rd[i].getName();
            if (sRole.equals("Admin.SystemAdmin")) {
                systemAdmin = true;
                continue;
            }
            if (sRole.equals("Admin.ProductAdmin")) {
                systemAdminMMS = true;
                continue;
            }
            if (!sRole.equals("Admin.ReadOnlyAdmin")) continue;
            viewOnly = true;
        }
        Roles roles = new Roles(systemAdmin, systemAdminMMS, viewOnly);
        this.rolesMap.put(conn, roles);
    }

    public void remove(ConnectionInfo connection) {
        this.rolesMap.remove(connection);
    }

    public boolean hasAnyRole(ConnectionInfo conn) {
        Roles roles = (Roles)this.rolesMap.get(conn);
        if (roles != null) {
            return roles.isSystemAdmin() || roles.isProductAdmin() || roles.isViewOnly();
        }
        return false;
    }

    public boolean isProductAdmin(ConnectionInfo conn) {
        Roles roles = (Roles)this.rolesMap.get(conn);
        if (roles != null) {
            return roles.isProductAdmin();
        }
        return false;
    }

    public boolean isSystemAdmin(ConnectionInfo conn) {
        Roles roles = (Roles)this.rolesMap.get(conn);
        if (roles != null) {
            return roles.isSystemAdmin();
        }
        return false;
    }

    public boolean canViewPrincipalInfo(ConnectionInfo conn) {
        return this.hasAnyRole(conn);
    }

    public boolean canViewRoleInfo(ConnectionInfo conn) {
        return this.hasAnyRole(conn);
    }

    public boolean canModifyRoleInfo(ConnectionInfo conn) {
        return this.isSystemAdmin(conn);
    }

    public boolean canViewLoggingConfig(ConnectionInfo conn) {
        return this.hasAnyRole(conn);
    }

    public boolean canModifyLoggingConfig(ConnectionInfo conn) {
        return this.isSystemAdmin(conn);
    }

    public boolean canViewLogMessages(ConnectionInfo conn) {
        return this.hasAnyRole(conn);
    }

    public boolean canViewEntitlements(ConnectionInfo conn) {
        return this.hasAnyRole(conn);
    }

    public boolean canModifyEntitlements(ConnectionInfo conn) {
        return this.isSystemAdmin(conn);
    }

    public boolean canModifySecurity(ConnectionInfo conn) {
        return this.isSystemAdmin(conn);
    }

    public boolean canViewMetadataEntitlements(ConnectionInfo conn) {
        return this.hasAnyRole(conn);
    }

    public boolean canModifyMetadataEntitlements(ConnectionInfo conn) {
        return this.isSystemAdmin(conn);
    }

    public boolean canViewSystemHealth(ConnectionInfo conn) {
        return this.hasAnyRole(conn);
    }

    public boolean canViewDeployment(ConnectionInfo conn) {
        return this.hasAnyRole(conn);
    }

    public boolean canViewRealTimeInfo(ConnectionInfo conn) {
        return this.hasAnyRole(conn);
    }

    public boolean canViewSessions(ConnectionInfo conn) {
        return this.hasAnyRole(conn);
    }

    public boolean canModifySessions(ConnectionInfo conn) {
        return this.isSystemAdmin(conn);
    }

    public boolean canViewQueries(ConnectionInfo conn) {
        return this.hasAnyRole(conn);
    }

    public boolean canModifyQueries(ConnectionInfo conn) {
        return this.isProductAdmin(conn);
    }

    public boolean canViewServerProperties(ConnectionInfo conn) {
        return this.hasAnyRole(conn);
    }

    public boolean canModifyServerProperties(ConnectionInfo conn) {
        return this.isSystemAdmin(conn);
    }

    public boolean canViewConnectorTypes(ConnectionInfo conn) {
        return this.hasAnyRole(conn);
    }

    public boolean canViewConnectors(ConnectionInfo conn) {
        return this.hasAnyRole(conn);
    }

    public boolean canModifyConnectors(ConnectionInfo conn) {
        return this.isSystemAdmin(conn);
    }

    public boolean canModifyConnectorBindings(ConnectionInfo conn) {
        return this.isSystemAdmin(conn);
    }

    public boolean canViewTransactionInfo(ConnectionInfo conn) {
        return this.hasAnyRole(conn);
    }

    public boolean canTerminateTransactions(ConnectionInfo conn) {
        return this.isProductAdmin(conn);
    }

    public boolean canUpdateConfiguration(ConnectionInfo conn) {
        return this.isProductAdmin(conn);
    }

    public boolean canUpdateSystemProperties(ConnectionInfo conn) {
        return this.isSystemAdmin(conn);
    }

    public boolean canViewSystemProperties(ConnectionInfo conn) {
        return this.hasAnyRole(conn);
    }

    public boolean canModifyVDBs(ConnectionInfo conn) {
        return this.isProductAdmin(conn);
    }

    public boolean canViewVDBs(ConnectionInfo conn) {
        return this.hasAnyRole(conn);
    }

    public boolean canViewExtensionSources(ConnectionInfo conn) {
        return this.hasAnyRole(conn);
    }

    public boolean canModifyExtensionSources(ConnectionInfo conn) {
        return this.isSystemAdmin(conn);
    }

    public boolean canModifyPools(ConnectionInfo conn) {
        return this.isSystemAdmin(conn);
    }

    public boolean canModifyResources(ConnectionInfo conn) {
        return this.isSystemAdmin(conn);
    }

    public boolean canPerformRuntimeOperations(ConnectionInfo conn) {
        return this.isProductAdmin(conn);
    }

    public static MetaMatrixPrincipalName getLoggedInUser(ConnectionInfo connection) throws Exception {
        MetaMatrixSessionID mmsidSessionID = connection.getSessionID();
        MetaMatrixPrincipal mmpPrincipal = ModelManager.getSessionAPI(connection).getPrincipal(mmsidSessionID);
        MetaMatrixPrincipalName loggedInUser = mmpPrincipal.getMetaMatrixPrincipalName();
        return loggedInUser;
    }
}

