/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui;

import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import com.metamatrix.toolbox.ui.widget.TextFieldWidget;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class StatusPanel
extends JPanel {
    public static final String DEFAULT_STATUS_TEXT = "READY";
    public static final String BUSY_STATUS_TEXT = "PLEASE WAIT...";
    private LabelWidget statusLabel = new LabelWidget("  status:  ");
    private TextFieldWidget statusField = new TextFieldWidget(" READY");
    private ButtonWidget busyIndicator = new ButtonWidget();

    public void createComponent() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.statusLabel, "West");
        this.add((Component)this.statusField, "Center");
        this.busyIndicator.setBackground(Color.green);
        this.add((Component)this.busyIndicator, "East");
        this.statusField.setEditable(false);
        this.statusField.setBackground(Color.white);
    }

    public void setStatusText(String text) {
        this.statusField.setText(" " + text);
    }

    public void clearStatusText() {
        this.statusField.setText(DEFAULT_STATUS_TEXT);
    }

    public void startBusySyncronize() {
        this.busyIndicator.setBackground(Color.red);
        this.setStatusText(BUSY_STATUS_TEXT);
    }

    public void startBusy() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StatusPanel.this.busyIndicator.setBackground(Color.red);
                StatusPanel.this.setStatusText(StatusPanel.BUSY_STATUS_TEXT);
            }
        });
    }

    public void endBusySyncronize() {
        this.busyIndicator.setBackground(Color.green);
        this.setStatusText(DEFAULT_STATUS_TEXT);
    }

    public void endBusy() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                StatusPanel.this.busyIndicator.setBackground(Color.green);
                StatusPanel.this.setStatusText(StatusPanel.DEFAULT_STATUS_TEXT);
            }
        });
    }
}

