/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui;

import com.metamatrix.common.log.LogConfiguration;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.ui.StatusPanel;
import com.metamatrix.console.ui.layout.ConsoleMainFrame;
import com.metamatrix.console.util.DialogUtility;
import com.metamatrix.toolbox.event.UserPreferencesEvent;
import com.metamatrix.toolbox.preference.UserPreferences;
import com.metamatrix.toolbox.ui.widget.util.IconFactory;
import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.EventObject;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JWindow;

public class ViewManager {
    private static ConsoleMainFrame mainFrame;
    private static StatusPanel statusPanel;
    private static JWindow splash;
    public static final ImageIcon CONSOLE_ICON;
    public static Image CONSOLE_ICON_IMAGE;

    public static void init(ConnectionInfo connection) {
        ConsoleMainFrame.createInstance(true, connection);
        mainFrame = ConsoleMainFrame.getInstance();
        mainFrame.addWindowListener(new SplashCloser());
        statusPanel = new StatusPanel();
        statusPanel.createComponent();
        DialogUtility.setDefaultComponent(ViewManager.getMainFrame());
        CONSOLE_ICON_IMAGE = IconFactory.getIconForImageFile("console_medium.gif").getImage();
        if (CONSOLE_ICON_IMAGE != null) {
            mainFrame.setIconImage(CONSOLE_ICON_IMAGE);
        }
        mainFrame.setInitialView(connection);
        mainFrame.show();
    }

    public static JFrame getMainFrame() {
        return mainFrame;
    }

    public static void setStatus(String statusMessage) {
        statusPanel.setStatusText(statusMessage);
    }

    public static void clearStatus() {
        statusPanel.clearStatusText();
    }

    public static void fireApplicationEvent(EventObject event) {
        if (event instanceof UserPreferencesEvent) {
            ViewManager.setLoggingPreferences();
        }
    }

    public static void setLoggingPreferences() {
        UserPreferences preferences = UserPreferences.getInstance();
        LogConfiguration config = LogManager.getLogConfigurationCopy();
        int level = Integer.parseInt(preferences.getProperties().getProperty("metamatrix.log", "3"));
        config.setMessageLevel(level);
        Collection contexts = UserPreferences.getInstance().getValues("metamatrix.log.contexts", ';');
        config.recordAllContexts();
        config.discardContexts(contexts);
        LogManager.setLogConfiguration((LogConfiguration)config);
    }

    public static void startBusy() {
        if (statusPanel != null) {
            statusPanel.startBusy();
        }
    }

    public static void startBusySyncronize() {
        if (statusPanel != null) {
            statusPanel.startBusySyncronize();
        }
    }

    public static void endBusy() {
        if (statusPanel != null) {
            statusPanel.endBusy();
        }
    }

    public static void endBusySyncronize() {
        if (statusPanel != null) {
            statusPanel.endBusySyncronize();
        }
    }

    static {
        CONSOLE_ICON = IconFactory.getIconForImageFile("console_medium.gif");
        CONSOLE_ICON_IMAGE = null;
    }

    private static class SplashCloser
    extends WindowAdapter {
        private SplashCloser() {
        }

        @Override
        public void windowOpened(WindowEvent theEvent) {
            if (splash != null) {
                splash.dispose();
            }
        }
    }
}

