/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.dialog;

import com.metamatrix.console.ui.layout.ConsoleMainFrame;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import com.metamatrix.toolbox.ui.widget.TextFieldWidget;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

class AddURLDialog
extends JDialog {
    private List urlNamesList;
    private TextFieldWidget urlText;
    private ButtonWidget okButton;
    private ButtonWidget cancelButton;
    private String url = null;

    public AddURLDialog(List urls) {
        super(ConsoleMainFrame.getInstance(), "Add URL", true);
        this.urlNamesList = urls;
        this.createComponent();
    }

    private void createComponent() {
        GridBagLayout layout = new GridBagLayout();
        this.getContentPane().setLayout(layout);
        LabelWidget addLabel = new LabelWidget("Enter a URL:");
        this.getContentPane().add(addLabel);
        layout.setConstraints(addLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 20, 0, 20), 0, 0));
        this.urlText = new TextFieldWidget(40);
        this.urlText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent ev) {
                AddURLDialog.this.textChanged(ev.getDocument());
            }

            @Override
            public void insertUpdate(DocumentEvent ev) {
                AddURLDialog.this.textChanged(ev.getDocument());
            }

            @Override
            public void removeUpdate(DocumentEvent ev) {
                AddURLDialog.this.textChanged(ev.getDocument());
            }
        });
        this.getContentPane().add(this.urlText);
        layout.setConstraints(this.urlText, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 5, 20), 0, 0));
        this.okButton = new ButtonWidget("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                AddURLDialog.this.okPressed();
            }
        });
        this.okButton.setEnabled(false);
        this.cancelButton = new ButtonWidget("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                AddURLDialog.this.cancelPressed();
            }
        });
        JPanel buttonsPanel = new JPanel(new GridLayout(1, 2, 10, 0));
        buttonsPanel.add(this.okButton);
        buttonsPanel.add(this.cancelButton);
        this.getContentPane().add(buttonsPanel);
        layout.setConstraints(buttonsPanel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 5, 0), 0, 0));
        this.pack();
        this.setLocation(StaticUtilities.centerFrame(this.getSize()));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AddURLDialog.this.cancelPressed();
            }
        });
    }

    private void cancelPressed() {
        this.url = null;
        this.dispose();
    }

    private void okPressed() {
        this.url = this.urlText.getText().trim();
        this.dispose();
    }

    private void textChanged(Document doc) {
        int docLen = doc.getLength();
        String str = null;
        try {
            str = doc.getText(0, docLen);
        }
        catch (Exception ex) {
            // empty catch block
        }
        str = str.trim();
        if (str.length() == 0) {
            this.okButton.setEnabled(false);
        } else if (this.matchesExistingURL(str)) {
            this.okButton.setEnabled(false);
        } else {
            this.okButton.setEnabled(true);
        }
    }

    private boolean matchesExistingURL(String str) {
        boolean matches = false;
        Iterator it = this.urlNamesList.iterator();
        while (!matches && it.hasNext()) {
            String curURL = (String)it.next();
            matches = str.equalsIgnoreCase(curURL);
        }
        return matches;
    }

    public String getURL() {
        return this.url;
    }
}

