/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.dialog;

import com.metamatrix.api.exception.security.LogonException;
import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.common.comm.exception.ConnectionException;
import com.metamatrix.console.ConsolePlugin;
import com.metamatrix.console.connections.ConnectionInfo;
import com.metamatrix.console.ui.dialog.ConsoleLoginDialog;
import com.metamatrix.console.ui.dialog.ConsoleLoginPanel;
import com.metamatrix.console.ui.dialog.ConsoleLoginWindow;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.LoginPanel;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.AbstractButton;

public class ConsoleLogin {
    public static final String APPLICATION_NAME = ConsolePlugin.Util.getString("ConsoleLogin.applicationName");
    public static final int LOGON_SUCCEEDED = 1;
    public static final int CANCELLED_LOGON = 2;
    private ConsoleLoginDialog dlg;
    private ConsoleLoginWindow wdw;
    private ConsoleLoginPanel panel;
    private ConnectionInfo connectionInfo = null;
    private int result = -1;
    private boolean isFirstLogin;
    private ConnectionInfo[] existingConnections;
    private boolean existingConnectionURLAndUserEntered = false;
    private List urls;
    private String initialPassword;

    public ConsoleLogin(List urls, boolean isFirstLogin, ConnectionInfo[] existingConnections, String password) {
        this.urls = urls;
        this.isFirstLogin = isFirstLogin;
        this.existingConnections = existingConnections;
        this.initialPassword = password;
        if (this.existingConnections == null) {
            this.existingConnections = new ConnectionInfo[0];
        }
    }

    public ConsoleLogin(List urls, boolean isFirstLogin, ConnectionInfo[] existingConnections) {
        this(urls, isFirstLogin, existingConnections, null);
    }

    public int showDialog() {
        this.panel = new ConsoleLoginPanel(this.urls, this.isFirstLogin);
        String appName = this.isFirstLogin ? APPLICATION_NAME : APPLICATION_NAME + " Additional Login";
        if (this.isFirstLogin) {
            this.wdw = new ConsoleLoginWindow(appName, this.panel, !this.isFirstLogin, this.isFirstLogin);
            Dimension wdwSize = this.wdw.getPreferredSize();
            int newWidth = (int)((double)wdwSize.width * 1.3);
            wdwSize = new Dimension(newWidth, wdwSize.height);
            this.wdw.setSize(wdwSize);
            this.wdw.setLocation(StaticUtilities.centerFrame(wdwSize));
        } else {
            this.dlg = new ConsoleLoginDialog(appName, this.panel, !this.isFirstLogin, this.isFirstLogin);
            AbstractButton exitButton = this.dlg.getDisplayedExitButton();
            exitButton.setText("Cancel");
            this.dlg.setExitingBlocked(true);
            this.dlg.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent ev) {
                    ConsoleLogin.this.exitButtonPressed();
                }
            });
            Dimension wdwSize = this.dlg.getPreferredSize();
            int newWidth = (int)((double)wdwSize.width * 1.3);
            wdwSize = new Dimension(newWidth, wdwSize.height);
            this.dlg.setSize(wdwSize);
            this.dlg.setLocation(StaticUtilities.centerFrame(wdwSize));
        }
        this.addListeners();
        if (this.initialPassword != null) {
            this.setPassword(this.initialPassword);
        }
        if (this.isFirstLogin) {
            this.wdw.setVisible(true);
        } else {
            this.dlg.show();
        }
        return this.getResult();
    }

    private void addListeners() {
        this.addLogonButtonListener();
        this.addExitButtonListener();
    }

    private void addLogonButtonListener() {
        ButtonWidget logonButton = this.isFirstLogin ? this.wdw.getLoginButton() : this.dlg.getLoginButton();
        logonButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ConsoleLogin.this.logonButtonPressed();
            }
        });
    }

    private void addExitButtonListener() {
        ButtonWidget exitButton = this.isFirstLogin ? this.wdw.getExitButton() : this.dlg.getExitButton();
        exitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ConsoleLogin.this.exitButtonPressed();
            }
        });
    }

    private void logonButtonPressed() {
        String url = this.getUrl();
        String user = this.getUser();
        boolean found = false;
        int i = 0;
        while (i < this.existingConnections.length && !found) {
            if (url.equalsIgnoreCase(this.existingConnections[i].getURL()) && user.equalsIgnoreCase(this.existingConnections[i].getUser())) {
                found = true;
                continue;
            }
            ++i;
        }
        if (found) {
            String msg = "Connection to " + url + " for user " + user + " already exists.  " + "Must select another server or user.";
            StaticUtilities.displayModalDialogWithOK("Connection Already Exists", msg);
            this.existingConnectionURLAndUserEntered = true;
        } else {
            this.existingConnectionURLAndUserEntered = false;
            this.login();
            if (this.result == 1) {
                this.panel.saveURLs(this.isFirstLogin);
                if (this.isFirstLogin) {
                    this.wdw.dispose();
                } else {
                    this.dlg.dispose();
                }
            } else if (this.isFirstLogin) {
                this.wdw.setVisible(true);
            }
        }
    }

    private String getUser() {
        return this.panel.getUserNameField().getText().trim();
    }

    private String getUrl() {
        return ((String)this.panel.getSystemField().getSelectedItem()).trim();
    }

    public boolean isExistingConnectionURLAndUserEntered() {
        return this.existingConnectionURLAndUserEntered;
    }

    private void exitButtonPressed() {
        this.result = 2;
        if (!this.isFirstLogin) {
            this.dlg.exit();
        }
    }

    public LoginPanel getLoginPanel() {
        return this.panel;
    }

    public String getPassword() {
        return new String(this.getPasswordField());
    }

    private void setPassword(String password) {
        this.panel.getPasswordField().setText(password);
    }

    private void login() {
        String userName = this.getUser();
        char[] password = this.getPasswordField();
        String url = this.getUrl();
        String failureHdrMsg = ConsolePlugin.Util.getString("ConsoleLogin.failureHdrMsg");
        String logonExceptionMsg = ConsolePlugin.Util.getString("ConsoleLogin.logonFailureMsg");
        String serverNotRunningMsg = ConsolePlugin.Util.getString("ConsoleLogin.serverNotRunningMsg");
        String generalExceptionMsg = ConsolePlugin.Util.getString("ConsoleLogin.generalErrorMsg");
        try {
            this.connectionInfo = new ConnectionInfo(url, userName, password, APPLICATION_NAME);
            this.connectionInfo.login();
            this.result = 1;
        }
        catch (ConnectionException ex) {
            ExceptionUtility.showMessage(failureHdrMsg, logonExceptionMsg, ex);
        }
        catch (CommunicationException ex) {
            if (ExceptionUtility.containsExceptionOfType(ex, LogonException.class)) {
                ExceptionUtility.showMessage(failureHdrMsg, logonExceptionMsg, ex);
            } else {
                ExceptionUtility.showMessage(failureHdrMsg, serverNotRunningMsg, ex);
            }
        }
        catch (Throwable t) {
            String msg = null;
            if (t instanceof Exception) {
                msg = generalExceptionMsg;
            }
            ExceptionUtility.showMessage(failureHdrMsg, msg, t);
        }
    }

    private char[] getPasswordField() {
        return this.panel.getPasswordField().getPassword();
    }

    public ConnectionInfo getConnectionInfo() {
        return this.connectionInfo;
    }

    public boolean selectNewConnection() {
        boolean result = this.isFirstLogin ? this.wdw.selectNewConnection() : this.dlg.selectNewConnection();
        return result;
    }

    private int getResult() {
        return this.result;
    }
}

