/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.dialog;

import com.metamatrix.console.ConsolePlugin;
import com.metamatrix.console.ui.dialog.ConsoleLoginPanel;
import com.metamatrix.console.ui.layout.ConsoleMainFrame;
import com.metamatrix.toolbox.ui.IconConstants;
import com.metamatrix.toolbox.ui.widget.ButtonConstants;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.CheckBox;
import com.metamatrix.toolbox.ui.widget.WidgetFactory;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;

public class ConsoleLoginDialog
extends JDialog
implements ButtonConstants,
IconConstants {
    private ConsoleLoginPanel panel;
    private AbstractButton displayedExitButton;
    private boolean exitingBlocked = false;
    private JCheckBox selectNewConnectionCB = new CheckBox("Change display to select the new connection");

    public ConsoleLoginDialog(String title, ConsoleLoginPanel panel, boolean showSelectConnectionCheckBox, boolean insertDefaultUserName) {
        super(ConsoleMainFrame.getInstance(), ConsolePlugin.Util.getString("ConsoleLoginDialog.titlePrefix", new Object[]{title}), true);
        this.panel = panel;
        this.initializeLoginWindow(showSelectConnectionCheckBox, insertDefaultUserName);
    }

    public synchronized ConsoleLoginPanel getLoginPanel() {
        return this.panel;
    }

    public synchronized AbstractButton getDisplayedExitButton() {
        return this.displayedExitButton;
    }

    public void setExitingBlocked(boolean flag) {
        this.exitingBlocked = flag;
    }

    public void exit() {
        if (this.exitingBlocked) {
            this.dispose();
        } else {
            System.exit(0);
        }
    }

    public ButtonWidget getExitButton() {
        return this.panel.getCancelButton();
    }

    public ButtonWidget getLoginButton() {
        return this.panel.getLoginButton();
    }

    protected void initializeLoginWindow(boolean showSelectConnectionCheckBox, boolean insertDefaultUserName) {
        if (this.panel == null) {
            this.panel = new ConsoleLoginPanel(insertDefaultUserName);
        }
        if (showSelectConnectionCheckBox) {
            GridBagLayout layout = new GridBagLayout();
            this.getContentPane().setLayout(layout);
            this.getContentPane().add(this.panel);
            this.getContentPane().add(this.selectNewConnectionCB);
            this.selectNewConnectionCB.setSelected(true);
            layout.setConstraints(this.panel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            layout.setConstraints(this.selectNewConnectionCB, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 4, 4, 4), 0, 0));
        } else {
            this.getContentPane().add(this.panel);
        }
        ButtonWidget loginButton = this.panel.getAcceptButton();
        this.displayedExitButton = this.panel.getCancelButton();
        ButtonWidget button = WidgetFactory.createButton("exit");
        this.displayedExitButton.setText(button.getText());
        this.displayedExitButton.setIcon(button.getIcon());
        this.displayedExitButton.setMnemonic(button.getMnemonic());
        this.setResizable(false);
        this.getRootPane().setDefaultButton(loginButton);
        this.pack();
    }

    public boolean selectNewConnection() {
        return this.selectNewConnectionCB.isVisible() && this.selectNewConnectionCB.isSelected();
    }
}

