/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.dialog;

import com.metamatrix.console.util.StaticProperties;
import com.metamatrix.toolbox.ui.widget.LoginPanel;
import com.metamatrix.toolbox.ui.widget.util.IconFactory;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class ConsoleLoginPanel
extends LoginPanel {
    private String systemURL;
    private static final ImageIcon LOGIN_ICON = IconFactory.getIconForImageFile("logoAndName.gif");

    public ConsoleLoginPanel(List urls, boolean insertDefaultUserName) {
        super(true, LOGIN_ICON);
        this.init(urls, insertDefaultUserName);
    }

    public ConsoleLoginPanel(boolean insertDefaultUserName) {
        this((List)null, insertDefaultUserName);
    }

    public void init(List urls, boolean insertDefaultUserName) {
        this.initURLs(urls, insertDefaultUserName);
    }

    private void initURLs(List urls, boolean insertDefaultUserName) {
        boolean nameSupplied;
        String name = null;
        if (insertDefaultUserName) {
            name = StaticProperties.getProperty("default.username");
        }
        boolean bl = nameSupplied = name != null && name.length() > 0;
        if (nameSupplied) {
            this.getUserNameField().setText(name);
            this.getPasswordField().addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(final ComponentEvent event) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ((JComponent)event.getSource()).requestFocus();
                        }
                    });
                    ConsoleLoginPanel.this.removeComponentListener(this);
                }
            });
        }
        if (urls != null) {
            int index;
            String defaultURL = StaticProperties.getDefaultURL();
            for (String url : urls) {
                this.getSystemField().addItem(url);
            }
            if (defaultURL != null && (index = urls.indexOf(defaultURL)) >= 0) {
                this.getSystemField().setSelectedIndex(index);
            }
        }
    }

    public void saveURLs(boolean replaceCurrent) {
        boolean listAlreadyHasURL;
        this.systemURL = (String)this.getSystemField().getSelectedItem();
        if (this.systemURL == null) {
            if (replaceCurrent) {
                StaticProperties.setCurrentURL("");
            }
            StaticProperties.setURLs(new ArrayList(0));
            return;
        }
        List currentURLs = StaticProperties.getURLsCopy();
        if (replaceCurrent) {
            StaticProperties.setCurrentURL(this.systemURL);
        }
        boolean bl = listAlreadyHasURL = currentURLs != null && currentURLs.contains(this.systemURL);
        if (!listAlreadyHasURL) {
            ArrayList<String> newList = new ArrayList<String>();
            if (currentURLs != null) {
                newList.addAll(currentURLs);
            }
            newList.add(this.systemURL);
            StaticProperties.setURLs(newList);
        }
    }
}

