/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.dialog;

import com.metamatrix.console.ConsolePlugin;
import com.metamatrix.console.ui.dialog.ConsoleLoginPanel;
import com.metamatrix.toolbox.ui.IconConstants;
import com.metamatrix.toolbox.ui.widget.ButtonConstants;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.CheckBox;
import com.metamatrix.toolbox.ui.widget.DialogWindow;
import com.metamatrix.toolbox.ui.widget.WidgetFactory;
import com.metamatrix.toolbox.ui.widget.util.IconFactory;
import java.awt.AWTEvent;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JFrame;

public class ConsoleLoginWindow
extends JFrame
implements ButtonConstants,
IconConstants {
    private static final ImageIcon LOGO_ICON = IconFactory.getIconForImageFile("logo.gif");
    private static final long TIMEOUT = 500L;
    private ConsoleLoginPanel panel;
    private AbstractButton displayedExitButton;
    private boolean exitingBlocked = false;
    private JCheckBox selectNewConnectionCB = new CheckBox("Change display to select the new connection");

    public static void show(String title, boolean isFirstLogin) {
        ConsoleLoginWindow.show(title, null, isFirstLogin);
    }

    public static void show(String title, ConsoleLoginPanel panel, boolean isFirstLogin) {
        ConsoleLoginWindow wdw = new ConsoleLoginWindow(title, panel, !isFirstLogin, isFirstLogin);
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension wdwSize = wdw.getPreferredSize();
        wdw.setLocation((screen.width - wdwSize.width) / 2, (screen.height - wdwSize.height) / 2);
        wdw.setVisible(true);
    }

    public ConsoleLoginWindow(String title, ConsoleLoginPanel panel, boolean showSelectConnectionCheckBox, boolean insertDefaultUserName) {
        super(ConsolePlugin.Util.getString("ConsoleLoginDialog.titlePrefix", new Object[]{title}));
        this.panel = panel;
        this.initializeLoginWindow(showSelectConnectionCheckBox, insertDefaultUserName);
    }

    public synchronized ConsoleLoginPanel getLoginPanel() {
        return this.panel;
    }

    public synchronized AbstractButton getDisplayedExitButton() {
        return this.displayedExitButton;
    }

    public void setExitingBlocked(boolean flag) {
        this.exitingBlocked = flag;
    }

    protected void exit(AWTEvent event) {
        if (this.exitingBlocked) {
            this.dispose();
        } else {
            System.exit(0);
        }
    }

    public ButtonWidget getExitButton() {
        return this.panel.getCancelButton();
    }

    public ButtonWidget getLoginButton() {
        return this.panel.getLoginButton();
    }

    protected void initializeLoginWindow(boolean showSelectConnectionCheckBox, boolean insertDefaultUserName) {
        if (this.panel == null) {
            this.panel = new ConsoleLoginPanel(insertDefaultUserName);
        }
        this.setIconImage(LOGO_ICON.getImage());
        if (showSelectConnectionCheckBox) {
            GridBagLayout layout = new GridBagLayout();
            this.getContentPane().setLayout(layout);
            this.getContentPane().add(this.panel);
            this.getContentPane().add(this.selectNewConnectionCB);
            this.selectNewConnectionCB.setSelected(true);
            layout.setConstraints(this.panel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            layout.setConstraints(this.selectNewConnectionCB, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 4, 4, 4), 0, 0));
        } else {
            this.getContentPane().add(this.panel);
        }
        ButtonWidget loginButton = this.panel.getAcceptButton();
        if (loginButton != null) {
            loginButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    ConsoleLoginWindow.this.login(event);
                }
            });
        }
        this.displayedExitButton = this.panel.getCancelButton();
        if (this.displayedExitButton != null) {
            this.displayedExitButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    ConsoleLoginWindow.this.exit(event);
                }
            });
        }
        ButtonWidget button = WidgetFactory.createButton("exit");
        this.displayedExitButton.setText(button.getText());
        this.displayedExitButton.setIcon(button.getIcon());
        this.displayedExitButton.setMnemonic(button.getMnemonic());
        this.setResizable(false);
        this.getRootPane().setDefaultButton(loginButton);
        this.pack();
    }

    protected void login(ActionEvent event) {
        DialogWindow.disposeConditionally(this, event);
    }

    @Override
    protected void processWindowEvent(WindowEvent event) {
        super.processWindowEvent(event);
        if (event.getID() == 201) {
            this.exit(event);
        }
    }

    @Override
    public synchronized void hide() {
        super.hide();
        this.notifyAll();
    }

    @Override
    public synchronized void show() {
        super.show();
        EventQueue q = Toolkit.getDefaultToolkit().getSystemEventQueue();
        q.push(new EventQueue());
        while (this.isVisible()) {
            try {
                this.wait(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public boolean selectNewConnection() {
        return this.selectNewConnectionCB.isVisible() && this.selectNewConnectionCB.isSelected();
    }
}

