/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.dialog;

import com.metamatrix.console.ui.ViewManager;
import com.metamatrix.console.ui.dialog.DetailsFileChooser;
import com.metamatrix.console.ui.util.CenteredOptionPane;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class DetailsDialog
extends JDialog {
    public static final int PREFERRED_TEXT_WIDTH = 100;
    public static final int MAX_TEXT_WIDTH = 130;
    private boolean detailsPressed = false;
    private Point smallLocation;
    private LabelWidget iconLabel;
    private JTextArea message;
    private String formattedMessageText;
    private ButtonWidget detailsButton = new ButtonWidget("Details");
    private ButtonWidget okButton = new ButtonWidget("OK");
    private ButtonWidget saveButton = new ButtonWidget("Save Details to File");
    private JTextArea details;
    private JScrollPane jScrollPane;
    private JPanel upperPanel;
    private String detailsText;
    private JPanel buttonPanel;
    private GridBagLayout bl;
    public static final String DIALOG_MESSAGE_TEXT = "DetailsDialog.messagetext";
    public static final String DIALOG_DETAILS_TEXT = "DetailsDialog.detailstext";
    private Dimension lastDimension;

    public DetailsDialog(Frame parentFrame, String title, String messageText, String dt, Icon icon) {
        super(parentFrame, title, false);
        this.setResizable(true);
        this.iconLabel = new LabelWidget(icon);
        this.formattedMessageText = StaticUtilities.insertLineBreaks(messageText, 100, 130);
        this.message = new JTextArea(this.formattedMessageText);
        this.message.setName(DIALOG_MESSAGE_TEXT);
        this.detailsText = dt;
        this.details = new JTextArea(this.detailsText);
        this.details.setName(DIALOG_DETAILS_TEXT);
        this.jScrollPane = new JScrollPane(this.details);
        this.lastDimension = new Dimension(300, 100);
        this.jScrollPane.setMinimumSize(this.lastDimension);
        this.jScrollPane.setPreferredSize(this.lastDimension);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DetailsDialog.this.okClicked();
            }
        });
        this.detailsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DetailsDialog.this.detailsClicked();
            }
        });
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DetailsDialog.this.saveClicked();
            }
        });
        this.layoutStuff();
        this.message.setBackground(this.upperPanel.getBackground());
        this.message.setForeground(this.iconLabel.getForeground());
        this.message.setFont(this.iconLabel.getFont());
        this.pack();
        this.invalidate();
        this.setLocation(StaticUtilities.centerFrame(this.getSize()));
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
    }

    private void layoutStuff() {
        this.getContentPane().setLayout(new BorderLayout());
        this.upperPanel = new JPanel();
        this.upperPanel.setLayout(new BoxLayout(this.upperPanel, 1));
        JPanel labelPanel = new JPanel();
        labelPanel.add(this.iconLabel);
        labelPanel.add(this.message);
        this.upperPanel.add(labelPanel);
        this.buttonPanel = new JPanel();
        this.bl = new GridBagLayout();
        this.buttonPanel.setLayout(this.bl);
        this.buttonPanel.add(this.okButton);
        this.bl.setConstraints(this.okButton, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.1, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.buttonPanel.add(this.detailsButton);
        this.bl.setConstraints(this.detailsButton, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.1, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.buttonPanel.add(this.saveButton);
        this.bl.setConstraints(this.saveButton, new GridBagConstraints(2, 0, 1, 1, 0.1, 0.1, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.saveButton.setVisible(false);
        this.upperPanel.add(this.buttonPanel);
        this.getContentPane().add((Component)this.upperPanel, "North");
    }

    private void okClicked() {
        this.dispose();
    }

    private void detailsClicked() {
        if (!this.detailsPressed) {
            this.detailsPressed = true;
            this.saveButton.setVisible(true);
            this.getContentPane().add((Component)this.jScrollPane, "Center");
            this.smallLocation = this.getLocation();
            this.getSize();
            if (ViewManager.getMainFrame() != null) {
                Point thisLocation = ViewManager.getMainFrame().getLocation();
                Dimension thisSize = ViewManager.getMainFrame().getSize();
                this.setLocation(thisLocation);
                this.setSize(thisSize);
            } else {
                this.setLocation(0, 0);
                this.setSize(Toolkit.getDefaultToolkit().getScreenSize());
            }
        } else {
            this.detailsPressed = false;
            this.lastDimension = this.jScrollPane.getSize();
            this.getContentPane().remove(this.jScrollPane);
            this.saveButton.setVisible(false);
            this.setLocation(this.smallLocation);
            this.pack();
        }
        this.setResizable(this.detailsPressed);
        super.validate();
    }

    private void saveClicked() {
        DetailsFileChooser chooser = new DetailsFileChooser();
        int response = chooser.showSaveDialog(null);
        if (response == 0) {
            File file = chooser.getSelectedFile();
            boolean fileOK = false;
            if (file.exists()) {
                if (file.canWrite()) {
                    fileOK = true;
                }
            } else {
                try {
                    file.createNewFile();
                    fileOK = true;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (!fileOK) {
                String msg = "Error in opening or writing to file.";
                CenteredOptionPane.showMessageDialog(ViewManager.getMainFrame(), msg, "File Error", -1, null);
            } else {
                FileWriter writer = null;
                try {
                    writer = new FileWriter(file);
                    writer.write(this.detailsText);
                }
                catch (Exception ex) {
                    String msg = "Error in opening or writing to file.";
                    CenteredOptionPane.showMessageDialog(ViewManager.getMainFrame(), msg, "File Error", -1, null);
                }
                if (writer != null) {
                    try {
                        writer.flush();
                        writer.close();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

