/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.dialog;

import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class PendingChangesDialog
extends JDialog {
    public static final int YES = 0;
    public static final int NO = 1;
    public static final int CANCEL = 2;
    private AbstractButton yesButton;
    private AbstractButton noButton;
    private AbstractButton cancelButton;
    private int response = -1;

    public PendingChangesDialog(JFrame owner, String msg, String url, String userName) {
        super(owner, "Changes Pending", true);
        this.init(msg, url, userName);
    }

    private void init(String msg, String url, String userName) {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent ev) {
                PendingChangesDialog.this.cancelPressed();
            }
        });
        this.yesButton = new ButtonWidget("Yes");
        this.noButton = new ButtonWidget("No");
        this.cancelButton = new ButtonWidget("Cancel");
        this.yesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                PendingChangesDialog.this.yesPressed();
            }
        });
        this.noButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                PendingChangesDialog.this.noPressed();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                PendingChangesDialog.this.cancelPressed();
            }
        });
        JPanel buttonsPanel = new JPanel(new GridLayout(1, 3, 10, 0));
        buttonsPanel.add(this.yesButton);
        buttonsPanel.add(this.noButton);
        buttonsPanel.add(this.cancelButton);
        String formattedString = StaticUtilities.insertLineBreaks(msg, 70, 130);
        String[] substrings = StaticUtilities.getLineBreakSubstrings(formattedString);
        JPanel textPanel = new JPanel(new GridLayout(substrings.length, 1, 0, 0));
        for (int i = 0; i < substrings.length; ++i) {
            textPanel.add(new LabelWidget(substrings[i]));
        }
        String urlAndUser = url + " [" + userName + "]";
        LabelWidget urlLabel = new LabelWidget(urlAndUser);
        Font newFont = urlLabel.getFont().deriveFont(1);
        urlLabel.setFont(newFont);
        GridBagLayout layout = new GridBagLayout();
        this.getContentPane().setLayout(layout);
        this.getContentPane().add(urlLabel);
        this.getContentPane().add(textPanel);
        this.getContentPane().add(buttonsPanel);
        layout.setConstraints(urlLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 4, 10, 4), 0, 0));
        layout.setConstraints(textPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 17, 0, new Insets(10, 4, 5, 4), 0, 0));
        layout.setConstraints(buttonsPanel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 4, 4, 4), 0, 0));
        this.pack();
        this.setLocation(StaticUtilities.centerFrame(this.getSize()));
    }

    private void yesPressed() {
        this.response = 0;
        this.dispose();
    }

    private void noPressed() {
        this.response = 1;
        this.dispose();
    }

    private void cancelPressed() {
        this.response = 2;
        this.dispose();
    }

    public int getResponse() {
        return this.response;
    }
}

