/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.dialog;

import com.metamatrix.console.ui.dialog.TextFieldInfo;
import com.metamatrix.console.ui.layout.WorkspaceController;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.console.util.ExternalException;
import com.metamatrix.console.util.StaticProperties;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.CheckBox;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import com.metamatrix.toolbox.ui.widget.TextFieldWidget;
import com.metamatrix.toolbox.ui.widget.TitledBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class RefreshRatesDialog
extends JDialog {
    private static final String TITLE = "Refresh Rates";
    private static final String SUMMARY = "Summary ";
    private static final String SESSION = "Sessions";
    private static final String QUERY = "Queries";
    private static final String SYSLOG = "Log Viewer";
    private static final String RESOURCE_POOLS = "Connection Pools";
    private static final int NUM_ITEMS = 5;
    private static final int SUMMARY_POSIT = 0;
    private static final int SESSION_POSIT = 1;
    private static final int QUERY_POSIT = 2;
    private static final int SYSLOG_POSIT = 3;
    private static final int RESOURCE_POOLS_POSIT = 4;
    private static final String SERVER_REFRESH = "Server Data Refresh";
    private static final String AUTO = "Auto";
    private static final String SECLBL = " sec.";
    private static final String SAVE = "Save";
    private static final String CANCEL = "Cancel";
    private static final String RESET = "Reset";
    private static final String BLANK = " ";
    private CheckBox chkbxSummary = new CheckBox("  Summary ");
    private CheckBox chkbxSession = new CheckBox("  Sessions");
    private CheckBox chkbxQuery = new CheckBox("  Queries");
    private CheckBox chkbxSyslog = new CheckBox("  Log Viewer");
    private CheckBox chkbxResourcePools = new CheckBox("  Connection Pools");
    private TextFieldWidget txtSummary = new TextFieldWidget(4);
    private TextFieldWidget txtSession = new TextFieldWidget(4);
    private TextFieldWidget txtQuery = new TextFieldWidget(4);
    private TextFieldWidget txtSyslog = new TextFieldWidget(4);
    private TextFieldWidget txtResourcePools = new TextFieldWidget(4);
    private ButtonWidget resetButton;
    private ButtonWidget saveButton;
    private TextFieldInfo[] savedState;

    public RefreshRatesDialog(Frame owner) {
        super(owner, TITLE, true);
        this.setDefaultCloseOperation(2);
    }

    public RefreshRatesDialog() {
    }

    public void createComponent() {
        this.getContentPane().setLayout(new BorderLayout());
        JPanel border = new JPanel(new BorderLayout());
        border.setBorder(new EmptyBorder(5, 5, 5, 5));
        border.add((Component)this.buildRefreshPanel(), "Center");
        border.add((Component)this.buildButtonPanel(), "South");
        this.getContentPane().add((Component)border, "Center");
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        this.pack();
        Dimension mySize = this.getSize();
        this.setLocation((screen.width - mySize.width) / 2, (screen.height - mySize.height) / 2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                RefreshRatesDialog.this.panelClosing();
            }
        });
        this.chkbxSummary.setSelected(false);
        this.chkbxSession.setSelected(false);
        this.chkbxQuery.setSelected(false);
        this.chkbxSyslog.setSelected(false);
        this.chkbxResourcePools.setSelected(false);
        this.loadPreferences();
        this.chkbxSummary.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ev) {
                RefreshRatesDialog.this.adjustSaveAndResetState();
            }
        });
        this.chkbxSession.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ev) {
                RefreshRatesDialog.this.adjustSaveAndResetState();
            }
        });
        this.chkbxQuery.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ev) {
                RefreshRatesDialog.this.adjustSaveAndResetState();
            }
        });
        this.chkbxSyslog.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ev) {
                RefreshRatesDialog.this.adjustSaveAndResetState();
            }
        });
        this.chkbxResourcePools.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ev) {
                RefreshRatesDialog.this.adjustSaveAndResetState();
            }
        });
        this.txtSummary.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent ev) {
                RefreshRatesDialog.this.adjustSaveAndResetState();
            }

            @Override
            public void insertUpdate(DocumentEvent ev) {
                RefreshRatesDialog.this.adjustSaveAndResetState();
            }

            @Override
            public void removeUpdate(DocumentEvent ev) {
                RefreshRatesDialog.this.adjustSaveAndResetState();
            }
        });
        this.txtSession.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent ev) {
                RefreshRatesDialog.this.adjustSaveAndResetState();
            }

            @Override
            public void insertUpdate(DocumentEvent ev) {
                RefreshRatesDialog.this.adjustSaveAndResetState();
            }

            @Override
            public void removeUpdate(DocumentEvent ev) {
                RefreshRatesDialog.this.adjustSaveAndResetState();
            }
        });
        this.txtQuery.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent ev) {
                RefreshRatesDialog.this.adjustSaveAndResetState();
            }

            @Override
            public void insertUpdate(DocumentEvent ev) {
                RefreshRatesDialog.this.adjustSaveAndResetState();
            }

            @Override
            public void removeUpdate(DocumentEvent ev) {
                RefreshRatesDialog.this.adjustSaveAndResetState();
            }
        });
        this.txtSyslog.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent ev) {
                RefreshRatesDialog.this.adjustSaveAndResetState();
            }

            @Override
            public void insertUpdate(DocumentEvent ev) {
                RefreshRatesDialog.this.adjustSaveAndResetState();
            }

            @Override
            public void removeUpdate(DocumentEvent ev) {
                RefreshRatesDialog.this.adjustSaveAndResetState();
            }
        });
        this.txtResourcePools.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent ev) {
                RefreshRatesDialog.this.adjustSaveAndResetState();
            }

            @Override
            public void insertUpdate(DocumentEvent ev) {
                RefreshRatesDialog.this.adjustSaveAndResetState();
            }

            @Override
            public void removeUpdate(DocumentEvent ev) {
                RefreshRatesDialog.this.adjustSaveAndResetState();
            }
        });
    }

    private JPanel buildRefreshPanel() {
        JPanel lblPanel = new JPanel();
        lblPanel.setLayout(new BorderLayout());
        lblPanel.setBorder(new EmptyBorder(0, 39, 0, 0));
        LabelWidget lblAuto = new LabelWidget(AUTO);
        lblPanel.add((Component)lblAuto, "West");
        JPanel grid = new JPanel(new GridLayout(5, 3));
        grid.setBorder(new EmptyBorder(0, 40, 10, 0));
        block7: for (int i = 0; i < 5; ++i) {
            switch (i) {
                case 0: {
                    grid.add(this.chkbxSummary);
                    grid.add(this.txtSummary);
                    grid.add(this.getSecLabel());
                    continue block7;
                }
                case 1: {
                    grid.add(this.chkbxSession);
                    grid.add(this.txtSession);
                    grid.add(this.getSecLabel());
                    continue block7;
                }
                case 2: {
                    grid.add(this.chkbxQuery);
                    grid.add(this.txtQuery);
                    grid.add(this.getSecLabel());
                    continue block7;
                }
                case 3: {
                    grid.add(this.chkbxSyslog);
                    grid.add(this.txtSyslog);
                    grid.add(this.getSecLabel());
                    continue block7;
                }
                case 4: {
                    grid.add(this.chkbxResourcePools);
                    grid.add(this.txtResourcePools);
                    grid.add(this.getSecLabel());
                }
            }
        }
        GridBagLayout l = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel rPanel = new JPanel(l);
        rPanel.setBorder(new TitledBorder(SERVER_REFRESH));
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.ipadx = 5;
        gbc.ipady = 5;
        gbc.gridx = 0;
        gbc.weightx = 1.0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 11;
        gbc.fill = 2;
        gbc.gridy = 0;
        gbc.weighty = 0.0;
        l.setConstraints(lblPanel, gbc);
        rPanel.add(lblPanel);
        gbc.fill = 2;
        gbc.gridy = 1;
        gbc.weighty = 1.0;
        l.setConstraints(grid, gbc);
        rPanel.add(grid);
        return rPanel;
    }

    private LabelWidget getSecLabel() {
        LabelWidget lbl = new LabelWidget(SECLBL);
        return lbl;
    }

    private JPanel buildButtonPanel() {
        JPanel buttonPanel = new JPanel();
        GridBagLayout bl = new GridBagLayout();
        buttonPanel.setLayout(bl);
        JPanel innerButtonPanel = new JPanel();
        innerButtonPanel.setLayout(new GridLayout(1, 3, 8, 0));
        this.saveButton = new ButtonWidget(SAVE);
        this.saveButton.setEnabled(false);
        innerButtonPanel.add(this.saveButton);
        ButtonWidget cancelButton = new ButtonWidget(CANCEL);
        cancelButton.setEnabled(true);
        innerButtonPanel.add(cancelButton);
        this.resetButton = new ButtonWidget(RESET);
        this.resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                RefreshRatesDialog.this.resetPressed();
            }
        });
        this.resetButton.setEnabled(false);
        innerButtonPanel.add(this.resetButton);
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                boolean saved = RefreshRatesDialog.this.savePreferences();
                if (saved) {
                    RefreshRatesDialog.this.panelClosing();
                }
            }
        });
        this.getRootPane().setDefaultButton(this.saveButton);
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                RefreshRatesDialog.this.cancelButtonPressed();
            }
        });
        buttonPanel.add(innerButtonPanel);
        bl.setConstraints(innerButtonPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 10, 10), 0, 0));
        return buttonPanel;
    }

    private void loadPreferences() {
        StaticProperties.getProperties();
        String value = StaticProperties.getProperty("refresh_enabled.session");
        if (value != null && value.trim().length() > 0) {
            if (value.trim().equals("true")) {
                this.chkbxSession.setSelected(true);
            } else {
                this.chkbxSession.setSelected(false);
            }
        } else {
            this.chkbxSession.setSelected(false);
        }
        value = StaticProperties.getProperty("refresh_rate.session");
        if (value != null && (value = value.trim()).equals("0")) {
            value = "";
        }
        if (value != null && value.length() > 0) {
            this.txtSession.setText(value.trim());
        } else {
            this.txtSession.setText(BLANK);
        }
        value = StaticProperties.getProperty("refresh_enabled.query");
        if (value != null && value.trim().length() > 0) {
            if (value.trim().equals("true")) {
                this.chkbxQuery.setSelected(true);
            } else {
                this.chkbxQuery.setSelected(false);
            }
        } else {
            this.chkbxQuery.setSelected(false);
        }
        value = StaticProperties.getProperty("refresh_rate.query");
        if (value != null && (value = value.trim()).equals("0")) {
            value = "";
        }
        if (value != null && value.length() > 0) {
            this.txtQuery.setText(value.trim());
        } else {
            this.txtQuery.setText(BLANK);
        }
        value = StaticProperties.getProperty("refresh_enabled.summary");
        if (value != null && value.trim().length() > 0) {
            if (value.trim().equals("true")) {
                this.chkbxSummary.setSelected(true);
            } else {
                this.chkbxSummary.setSelected(false);
            }
        } else {
            this.chkbxSummary.setSelected(false);
        }
        value = StaticProperties.getProperty("refresh_rate.summary");
        if (value != null && (value = value.trim()).equals("0")) {
            value = "";
        }
        if (value != null && value.length() > 0) {
            this.txtSummary.setText(value.trim());
        } else {
            this.txtSummary.setText(BLANK);
        }
        value = StaticProperties.getProperty("refresh_enabled.syslog");
        if (value != null && value.trim().length() > 0) {
            if (value.trim().equals("true")) {
                this.chkbxSyslog.setSelected(true);
            } else {
                this.chkbxSyslog.setSelected(false);
            }
        } else {
            this.chkbxSyslog.setSelected(false);
        }
        value = StaticProperties.getProperty("refresh_rate.syslog");
        if (value != null && (value = value.trim()).equals("0")) {
            value = "";
        }
        if (value != null && value.length() > 0) {
            this.txtSyslog.setText(value.trim());
        } else {
            this.txtSyslog.setText(BLANK);
        }
        value = StaticProperties.getProperty("refresh_enabled.resource_pools");
        if (value != null && value.trim().length() > 0) {
            if (value.trim().equals("true")) {
                this.chkbxResourcePools.setSelected(true);
            } else {
                this.chkbxResourcePools.setSelected(false);
            }
        } else {
            this.chkbxResourcePools.setSelected(false);
        }
        value = StaticProperties.getProperty("refresh_rate.resource_pools");
        if (value != null && (value = value.trim()).equals("0")) {
            value = "";
        }
        if (value != null && value.length() > 0) {
            this.txtResourcePools.setText(value.trim());
        } else {
            this.txtResourcePools.setText(BLANK);
        }
        this.saveState(this.getState());
    }

    private boolean refreshRateOK(TextFieldInfo info) {
        boolean okay;
        String text = info.getTextField().getText().trim();
        if (text.length() == 0 && !info.getCheckBox().isSelected()) {
            okay = true;
        } else {
            Integer ii = null;
            try {
                ii = new Integer(text);
            }
            catch (Exception ex) {
                // empty catch block
            }
            okay = ii != null && ii >= 15 && ii <= 3600;
        }
        if (!okay) {
            StaticUtilities.displayModalDialogWithOK("Illegal Value", "Illegal value entered for " + info.getName() + ".  Must be an integer from " + 15 + " to " + 3600 + ".");
            info.getTextField().requestFocus();
        }
        return okay;
    }

    private boolean savePreferences() {
        TextFieldInfo[] tfi = this.getState();
        boolean okay = true;
        for (int i = 0; i < tfi.length && okay; ++i) {
            okay = this.refreshRateOK(tfi[i]);
        }
        if (okay) {
            StaticProperties.setProperty("refresh_enabled.session", this.cvtBooleanToString(this.chkbxSession.isSelected()));
            StaticProperties.setProperty("refresh_rate.session", this.txtSession.getText().trim());
            StaticProperties.setProperty("refresh_enabled.query", this.cvtBooleanToString(this.chkbxQuery.isSelected()));
            StaticProperties.setProperty("refresh_rate.query", this.txtQuery.getText().trim());
            StaticProperties.setProperty("refresh_enabled.summary", this.cvtBooleanToString(this.chkbxSummary.isSelected()));
            StaticProperties.setProperty("refresh_rate.summary", this.txtSummary.getText().trim());
            StaticProperties.setProperty("refresh_enabled.syslog", this.cvtBooleanToString(this.chkbxSyslog.isSelected()));
            StaticProperties.setProperty("refresh_rate.syslog", this.txtSyslog.getText().trim());
            StaticProperties.setProperty("refresh_enabled.resource_pools", this.cvtBooleanToString(this.chkbxResourcePools.isSelected()));
            StaticProperties.setProperty("refresh_rate.resource_pools", this.txtResourcePools.getText().trim());
            boolean continuing = true;
            try {
                StaticProperties.saveProperties();
            }
            catch (ExternalException e) {
                ExceptionUtility.showExternalFailureMessage("Updating Preferences", (Exception)((Object)e));
                continuing = false;
            }
            if (continuing) {
                WorkspaceController.getInstance().applyAutoRefreshParmsToAll();
                this.saveState(tfi);
            }
        }
        return okay;
    }

    private TextFieldInfo[] getState() {
        TextFieldInfo[] tfi = new TextFieldInfo[]{new TextFieldInfo(SUMMARY, this.txtSummary, this.chkbxSummary), new TextFieldInfo(SESSION, this.txtSession, this.chkbxSession), new TextFieldInfo(QUERY, this.txtQuery, this.chkbxQuery), new TextFieldInfo(SYSLOG, this.txtSyslog, this.chkbxSyslog), new TextFieldInfo(RESOURCE_POOLS, this.txtResourcePools, this.chkbxResourcePools)};
        return tfi;
    }

    private void resetPressed() {
        this.resetState();
    }

    private void resetState() {
        for (int i = 0; i < this.savedState.length; ++i) {
            this.savedState[i].getCheckBox().setSelected(this.savedState[i].isCheckBoxSelected());
            this.savedState[i].getTextField().setText(this.savedState[i].getTextFieldText());
        }
    }

    private void adjustSaveAndResetState() {
        TextFieldInfo[] first = this.savedState;
        TextFieldInfo[] second = this.getState();
        boolean allSame = TextFieldInfo.allEqual(first, second);
        boolean enable = !allSame;
        this.resetButton.setEnabled(enable);
        this.saveButton.setEnabled(enable);
    }

    private void saveState(TextFieldInfo[] tfi) {
        this.savedState = tfi;
    }

    private String cvtBooleanToString(boolean b) {
        String str = b ? "true" : "false";
        return str;
    }

    private void cancelButtonPressed() {
        this.panelClosing();
    }

    private void panelClosing() {
        this.dispose();
    }

    public static void viewPreferences(Frame parent) {
        RefreshRatesDialog dialog = new RefreshRatesDialog(parent);
        dialog.createComponent();
        dialog.show();
    }
}

