/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.dialog;

import com.metamatrix.toolbox.ui.widget.LabelWidget;
import com.metamatrix.toolbox.ui.widget.TextFieldWidget;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Arrays;
import javax.swing.JPanel;
import javax.swing.JPasswordField;

public class ResetPasswordPanel
extends JPanel {
    public static final String TITLE = "Change password";
    public static final String SUCCESS_MESSAGE = "Password changed.";
    public static final String FAIL_MESSAGE = "Password was not changed.\nCheck that password was entered correctly twice.";
    private static final String USERNAME_LABEL_TEXT = "Username:";
    private static final String PASSWORD_LABEL_TEXT = "Password:";
    private static final String CONFIRM_PASSWORD_LABEL_TEXT = "Confirm Password:";
    private LabelWidget usernameLabel;
    private LabelWidget passwordLabel;
    private LabelWidget confirmPasswordLabel;
    private TextFieldWidget usernameField;
    private JPasswordField passwordField;
    private JPasswordField confirmPasswordField;
    private GridBagLayout l;
    private GridBagConstraints c;

    public char[] getPassword() {
        if (this.validatePasswords()) {
            return this.passwordField.getPassword();
        }
        return null;
    }

    private boolean validatePasswords() {
        return Arrays.equals(this.passwordField.getPassword(), this.confirmPasswordField.getPassword());
    }

    public void setUsername(String username) {
        this.usernameField.setText(username);
    }

    public String getUsername() {
        return this.usernameField.getText().trim();
    }

    public void init() {
        this.usernameLabel = new LabelWidget(USERNAME_LABEL_TEXT);
        this.passwordLabel = new LabelWidget(PASSWORD_LABEL_TEXT);
        this.confirmPasswordLabel = new LabelWidget(CONFIRM_PASSWORD_LABEL_TEXT);
        this.usernameField = new TextFieldWidget();
        this.usernameField.setText("");
        this.usernameField.setEditable(false);
        this.passwordField = new JPasswordField();
        this.passwordField.setText("");
        this.confirmPasswordField = new JPasswordField();
        this.confirmPasswordField.setText("");
        this.l = new GridBagLayout();
        this.setLayout(this.l);
        this.c = new GridBagConstraints();
        this.layoutStuff();
        this.setVisible(true);
    }

    private void layoutStuff() {
        Insets insets = new Insets(5, 5, 5, 5);
        this.c.ipadx = 0;
        this.c.ipady = 0;
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.c.fill = 0;
        this.c.anchor = 12;
        this.c.weightx = 0.1;
        this.c.weighty = 0.1;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.insets = insets;
        this.l.setConstraints(this.usernameLabel, this.c);
        this.add(this.usernameLabel);
        this.c.ipadx = 0;
        this.c.ipady = 0;
        this.c.gridx = 1;
        this.c.gridy = 0;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 1.0;
        this.c.weighty = 0.1;
        this.c.fill = 2;
        this.c.anchor = 11;
        this.c.insets = insets;
        this.l.setConstraints(this.usernameField, this.c);
        this.add(this.usernameField);
        this.c.ipadx = 0;
        this.c.ipady = 0;
        this.c.gridx = 0;
        this.c.gridy = 1;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.1;
        this.c.weighty = 0.1;
        this.c.fill = 0;
        this.c.anchor = 12;
        this.c.insets = insets;
        this.l.setConstraints(this.passwordLabel, this.c);
        this.add(this.passwordLabel);
        this.c.ipadx = 0;
        this.c.ipady = 0;
        this.c.gridx = 1;
        this.c.gridy = 1;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 1.0;
        this.c.weighty = 0.1;
        this.c.fill = 2;
        this.c.anchor = 11;
        this.c.insets = insets;
        this.l.setConstraints(this.passwordField, this.c);
        this.add(this.passwordField);
        this.c.ipadx = 0;
        this.c.ipady = 0;
        this.c.gridx = 0;
        this.c.gridy = 2;
        this.c.gridheight = 1;
        this.c.gridwidth = 1;
        this.c.weightx = 0.1;
        this.c.weighty = 1.0;
        this.c.fill = 0;
        this.c.anchor = 12;
        this.c.insets = insets;
        this.l.setConstraints(this.confirmPasswordLabel, this.c);
        this.add(this.confirmPasswordLabel);
        this.c.ipadx = 0;
        this.c.ipady = 0;
        this.c.gridx = 1;
        this.c.gridy = 2;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 1.0;
        this.c.weighty = 1.0;
        this.c.fill = 2;
        this.c.anchor = 11;
        this.c.insets = insets;
        this.l.setConstraints(this.confirmPasswordField, this.c);
        this.add(this.confirmPasswordField);
    }
}

