/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.dialog;

import com.metamatrix.console.ui.dialog.AddURLDialog;
import com.metamatrix.console.ui.dialog.PanelState;
import com.metamatrix.console.util.ExceptionUtility;
import com.metamatrix.console.util.ExternalException;
import com.metamatrix.console.util.StaticProperties;
import com.metamatrix.console.util.StaticUtilities;
import com.metamatrix.toolbox.ui.widget.ButtonWidget;
import com.metamatrix.toolbox.ui.widget.LabelWidget;
import com.metamatrix.toolbox.ui.widget.TitledBorder;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ServerURLsDialog
extends JDialog {
    private static final String TITLE = "Server URLs";
    private static final String SAVE = "Save";
    private static final String CANCEL = "Cancel";
    private static final String ADD = "Add...";
    private static final String REMOVE = "Remove";
    private List urlNamesList;
    private JList urlList;
    private JRadioButton jrbDefault = new JRadioButton("Set as default URL", false);
    private JRadioButton jrbUseLastLogin = new JRadioButton("Use last URL as default", false);
    private ButtonWidget removeButton = new ButtonWidget("Remove");
    private ButtonWidget addButton = new ButtonWidget("Add...");
    private ButtonWidget saveButton = new ButtonWidget("Save");
    private ButtonWidget cancelButton = new ButtonWidget("Cancel");
    private String currentDefaultURL = null;
    private boolean useLastLogin = false;
    private PanelState savedPanelState;
    private boolean programmaticChange = false;

    public ServerURLsDialog(Frame owner) {
        super(owner, TITLE, true);
        this.setDefaultCloseOperation(2);
    }

    public ServerURLsDialog() {
    }

    public void createComponent() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ServerURLsDialog.this.panelClosing();
            }
        });
        this.jrbDefault.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ev) {
                if (ServerURLsDialog.this.jrbDefault.isSelected()) {
                    String selectedItem;
                    ServerURLsDialog.this.jrbUseLastLogin.setSelected(false);
                    ServerURLsDialog.this.useLastLogin = false;
                    if (ServerURLsDialog.this.urlList != null && (selectedItem = (String)ServerURLsDialog.this.urlList.getSelectedValue()) != null) {
                        ServerURLsDialog.this.currentDefaultURL = selectedItem;
                    }
                }
                ServerURLsDialog.this.checkButtonEnabling();
            }
        });
        this.jrbUseLastLogin.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ev) {
                if (ServerURLsDialog.this.jrbUseLastLogin.isSelected()) {
                    ServerURLsDialog.this.jrbDefault.setSelected(false);
                    ServerURLsDialog.this.useLastLogin = true;
                }
                ServerURLsDialog.this.checkButtonEnabling();
            }
        });
        this.urlList = new JList();
        this.urlList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent se) {
                ServerURLsDialog.this.urlListSelectionChanged();
            }
        });
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ServerURLsDialog.this.addURL();
                ServerURLsDialog.this.checkButtonEnabling();
            }
        });
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ServerURLsDialog.this.removeURL();
                ServerURLsDialog.this.checkButtonEnabling();
            }
        });
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ServerURLsDialog.this.savePreferences();
                ServerURLsDialog.this.panelClosing();
            }
        });
        this.saveButton.setEnabled(false);
        this.getRootPane().setDefaultButton(this.saveButton);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ServerURLsDialog.this.cancelButtonPressed();
            }
        });
        this.doTheLayout();
        this.loadPreferences();
        this.savedPanelState = this.currentPanelState();
        this.checkButtonEnabling();
        this.pack();
        Dimension tempSize = this.getSize();
        Dimension newSize = new Dimension(Math.max(tempSize.width, (int)((double)Toolkit.getDefaultToolkit().getScreenSize().width * 0.4)), tempSize.height);
        this.setSize(newSize);
        this.setLocation(StaticUtilities.centerFrame(this.getSize()));
    }

    private void doTheLayout() {
        GridBagLayout layout = new GridBagLayout();
        this.getContentPane().setLayout(layout);
        JPanel upperPanel = new JPanel();
        upperPanel.setBorder(new TitledBorder(""));
        this.getContentPane().add(upperPanel);
        layout.setConstraints(upperPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(4, 4, 4, 4), 0, 0));
        JPanel saveCancelButtonsPanel = new JPanel(new GridLayout(1, 2, 10, 0));
        saveCancelButtonsPanel.add(this.saveButton);
        saveCancelButtonsPanel.add(this.cancelButton);
        this.getContentPane().add(saveCancelButtonsPanel);
        layout.setConstraints(saveCancelButtonsPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 4, 4, 4), 0, 0));
        GridBagLayout ul = new GridBagLayout();
        upperPanel.setLayout(ul);
        JPanel urlsPanel = new JPanel();
        GridBagLayout urlsLayout = new GridBagLayout();
        urlsPanel.setLayout(urlsLayout);
        upperPanel.add(urlsPanel);
        ul.setConstraints(urlsPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(4, 4, 2, 4), 0, 0));
        LabelWidget urlsLabel = new LabelWidget("Server URLs:");
        urlsPanel.add(urlsLabel);
        urlsLayout.setConstraints(urlsPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 4), 0, 0));
        JScrollPane listJSP = new JScrollPane(this.urlList);
        urlsPanel.add(listJSP);
        urlsLayout.setConstraints(listJSP, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 4, 0, 0), 0, 0));
        JPanel defaultsPanel = new JPanel();
        GridBagLayout dl = new GridBagLayout();
        defaultsPanel.setLayout(dl);
        defaultsPanel.add(this.jrbDefault);
        defaultsPanel.add(this.jrbUseLastLogin);
        dl.setConstraints(this.jrbDefault, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 2), 0, 0));
        dl.setConstraints(this.jrbUseLastLogin, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 2), 0, 0));
        upperPanel.add(defaultsPanel);
        ul.setConstraints(defaultsPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 4, 0), 0, 0));
        JPanel addRemoveButtonsPanel = new JPanel(new GridLayout(1, 2, 10, 0));
        addRemoveButtonsPanel.add(this.addButton);
        addRemoveButtonsPanel.add(this.removeButton);
        upperPanel.add(addRemoveButtonsPanel);
        ul.setConstraints(addRemoveButtonsPanel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 0, 8, 0), 0, 0));
    }

    private void addURL() {
        AddURLDialog dlg = new AddURLDialog(this.urlNamesList);
        dlg.show();
        String newURL = dlg.getURL();
        if (newURL != null) {
            this.urlNamesList.add(newURL);
            this.urlList.setListData(this.urlNamesList.toArray());
            int index = this.urlNamesList.indexOf(newURL);
            this.urlList.setSelectedIndex(index);
        }
    }

    private void removeURL() {
        Object o = this.urlList.getSelectedValue();
        this.urlNamesList.remove(o);
        this.urlList.setListData(this.urlNamesList.toArray());
    }

    private void urlListSelectionChanged() {
        if (this.urlList.getSelectedIndex() >= 0) {
            String currentURL = (String)this.urlList.getSelectedValue();
            this.jrbDefault.setSelected(currentURL != null && currentURL.equals(this.currentDefaultURL) && !this.useLastLogin);
        }
        this.checkButtonEnabling();
    }

    private void checkButtonEnabling() {
        if (!this.programmaticChange && this.urlList != null) {
            this.programmaticChange = true;
            if (this.urlList.getSelectedIndex() >= 0) {
                this.removeButton.setEnabled(true);
                this.jrbDefault.setEnabled(true);
            } else {
                this.removeButton.setEnabled(false);
                this.jrbDefault.setSelected(false);
                this.jrbDefault.setEnabled(false);
            }
            this.programmaticChange = false;
        }
        this.saveButton.setEnabled(!this.panelStateMatchesStartingState());
    }

    private boolean panelStateMatchesStartingState() {
        return this.currentPanelState().equals(this.savedPanelState);
    }

    private PanelState currentPanelState() {
        String[] urls;
        if (this.urlNamesList != null) {
            urls = new String[this.urlNamesList.size()];
            Iterator it = this.urlNamesList.iterator();
            int i = 0;
            while (it.hasNext()) {
                urls[i] = (String)it.next();
                ++i;
            }
        } else {
            urls = new String[]{};
        }
        return new PanelState(urls, this.currentDefaultURL, this.jrbUseLastLogin.isSelected());
    }

    private void loadPreferences() {
        this.currentDefaultURL = StaticProperties.getDefaultURL();
        this.useLastLogin = StaticProperties.getUseLastURLAsDefault();
        this.jrbUseLastLogin.setSelected(this.useLastLogin);
        if (this.useLastLogin) {
            this.selectURL(StaticProperties.getCurrentURL());
        } else {
            this.selectURL(this.currentDefaultURL);
        }
    }

    private void selectURL(String targetURL) {
        List urls;
        this.urlNamesList = urls = StaticProperties.getURLsCopy();
        if (this.urlNamesList == null) {
            this.urlNamesList = new ArrayList();
        }
        this.urlList.setListData(this.urlNamesList.toArray());
        this.urlList.setVisibleRowCount(5);
        boolean matchFound = false;
        Iterator it = urls.iterator();
        while (it.hasNext() && !matchFound) {
            String url = (String)it.next();
            if (!url.equalsIgnoreCase(targetURL)) continue;
            this.urlList.setSelectedValue(url, true);
            matchFound = true;
        }
        if (matchFound) {
            this.urlListSelectionChanged();
        }
    }

    private void savePreferences() {
        StaticProperties.setURLs(this.urlNamesList, this.currentDefaultURL, this.useLastLogin);
        try {
            StaticProperties.saveProperties();
        }
        catch (ExternalException e) {
            ExceptionUtility.showExternalFailureMessage("Updating Preferences", (Exception)((Object)e));
        }
    }

    private void cancelButtonPressed() {
        this.panelClosing();
    }

    private void panelClosing() {
        this.dispose();
    }

    public static void viewPreferences(Frame parent) {
        ServerURLsDialog dialog = new ServerURLsDialog(parent);
        dialog.createComponent();
        dialog.show();
    }
}

