/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.console.ui.dialog;

import com.metamatrix.toolbox.ui.widget.CheckBox;
import com.metamatrix.toolbox.ui.widget.TextFieldWidget;

class TextFieldInfo {
    private String name;
    private TextFieldWidget textField;
    private CheckBox checkBox;
    private String textFieldText;
    private boolean checkBoxSelected;

    public static boolean allEqual(TextFieldInfo[] first, TextFieldInfo[] second) {
        boolean same = false;
        if (first.length == second.length) {
            int i = 0;
            boolean mismatchFound = false;
            while (i < first.length && !mismatchFound) {
                boolean currentItemsSame = first[i].equals(second[i]);
                if (currentItemsSame) {
                    ++i;
                    continue;
                }
                mismatchFound = true;
            }
            same = !mismatchFound;
        }
        return same;
    }

    public TextFieldInfo(String n, TextFieldWidget tf, CheckBox cb) {
        this.name = n;
        this.textField = tf;
        this.checkBox = cb;
        this.textFieldText = this.textField.getText().trim();
        this.checkBoxSelected = this.checkBox.isSelected();
    }

    public String getName() {
        return this.name;
    }

    public TextFieldWidget getTextField() {
        return this.textField;
    }

    public CheckBox getCheckBox() {
        return this.checkBox;
    }

    public String getTextFieldText() {
        return this.textFieldText;
    }

    public boolean isCheckBoxSelected() {
        return this.checkBoxSelected;
    }

    public boolean equals(Object obj) {
        TextFieldInfo tfi;
        boolean same = false;
        if (obj instanceof TextFieldInfo && (tfi = (TextFieldInfo)obj).getName().equals(this.name) && tfi.getTextField() == this.textField && tfi.getCheckBox() == this.checkBox && tfi.getTextFieldText().equals(this.textFieldText) && tfi.isCheckBoxSelected() == this.checkBoxSelected) {
            same = true;
        }
        return same;
    }
}

